/*
 * Decompiled with CFR 0.152.
 */
package us.minecraftchest2.hdm_mod.block.custom;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import us.minecraftchest2.hdm_mod.world.dimension.ModDimensions;
import us.minecraftchest2.hdm_mod.world.dimension.SimpleTeleporter;

public class Window
extends HorizontalBlock {
    private static final VoxelShape SHAPE_N = Stream.of(Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)6.0, (double)13.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)12.0), Block.func_208617_a((double)5.0, (double)11.0, (double)4.0, (double)11.0, (double)12.0, (double)5.0), Block.func_208617_a((double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)14.0, (double)12.0), Block.func_208617_a((double)10.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)6.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0), Block.func_208617_a((double)11.0, (double)11.0, (double)5.0, (double)12.0, (double)12.0, (double)11.0), Block.func_208617_a((double)4.0, (double)11.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0), Block.func_208617_a((double)5.0, (double)11.0, (double)10.0, (double)11.0, (double)13.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.func_208617_a((double)10.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)12.0), Block.func_208617_a((double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)12.0, (double)12.0), Block.func_208617_a((double)5.0, (double)11.0, (double)4.0, (double)11.0, (double)14.0, (double)5.0), Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)6.0, (double)13.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.func_208617_a((double)5.0, (double)11.0, (double)10.0, (double)11.0, (double)13.0, (double)11.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.func_208617_a((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.func_208617_a((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0), Block.func_208617_a((double)4.0, (double)11.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0), Block.func_208617_a((double)11.0, (double)11.0, (double)5.0, (double)12.0, (double)14.0, (double)11.0), Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)6.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public Window(AbstractBlock.Properties builder) {
        super(builder);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.func_201670_d() && !player.func_213453_ef()) {
            ServerWorld overWorld;
            ServerWorld targetWorld;
            MinecraftServer server = worldIn.func_73046_m();
            if (server == null) {
                return ActionResultType.PASS;
            }
            boolean goingToCustom = worldIn.func_234923_W_() != ModDimensions.World1;
            ServerWorld serverWorld = targetWorld = worldIn.func_234923_W_() == ModDimensions.World1 ? server.func_71218_a(World.field_234918_g_) : server.func_71218_a(ModDimensions.World1);
            if (worldIn.func_234923_W_() == ModDimensions.World1 && (overWorld = server.func_71218_a(World.field_234918_g_)) != null) {
                player.changeDimension(overWorld, (ITeleporter)new SimpleTeleporter(pos, false));
            }
            if (targetWorld != null) {
                SimpleTeleporter teleporter = new SimpleTeleporter(pos, goingToCustom);
                player.changeDimension(targetWorld, (ITeleporter)teleporter);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
            case NORTH: {
                return SHAPE_N;
            }
            case SOUTH: {
                return SHAPE_S;
            }
            case WEST: {
                return SHAPE_W;
            }
            case EAST: {
                return SHAPE_E;
            }
        }
        return SHAPE_N;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }
}

