/*
 * Decompiled with CFR 0.152.
 */
package net.lunakibby.rtrluna.item;

import java.util.List;
import net.lunakibby.rtrluna.procedures.UnbreakingTalismanAffixProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class UnbreakingTalismanItem
extends Item {
    public UnbreakingTalismanItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 40;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.talismans_luna.unbreaking_talisman.description_0"));
        list.add((Component)Component.translatable((String)"item.talismans_luna.unbreaking_talisman.description_1"));
        list.add((Component)Component.translatable((String)"item.talismans_luna.unbreaking_talisman.description_2"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        UnbreakingTalismanAffixProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }
}

