/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.HomeManager;
import com.flummidill.simplehomes.SimpleHomes;
import com.flummidill.simplehomes.TeleportTask;
import com.flummidill.simplehomes.TeleportTaskAdmin;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final SimpleHomes plugin;
    private final HomeManager manager;
    private final Map<UUID, TeleportTask> teleportTasks = new HashMap<UUID, TeleportTask>();
    private final Map<UUID, TeleportTaskAdmin> teleportTasksAdmin = new HashMap<UUID, TeleportTaskAdmin>();

    public CommandHandler(SimpleHomes plugin, HomeManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cOnly Players can run this Command!");
            return true;
        }
        Player player = (Player)sender;
        String cmd = command.getName().toLowerCase();
        this.manager.saveOfflinePlayer(player.getUniqueId(), player.getName());
        switch (cmd) {
            case "sethome": {
                if (!player.hasPermission("simplehomes.use")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("Usage: /sethome <number>");
                    return true;
                }
                return this.handleSetHome(player, args[0]);
            }
            case "home": {
                if (!player.hasPermission("simplehomes.use")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("Usage: /home <number>");
                    return true;
                }
                return this.handleHome(player, args[0]);
            }
            case "delhome": {
                if (!player.hasPermission("simplehomes.use")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 1) {
                    player.sendMessage("Usage: /delhome <number>");
                    return true;
                }
                return this.handleDelHome(player, args[0]);
            }
            case "homeadmin": {
                if (!player.hasPermission("simplehomes.admin")) {
                    player.sendMessage("\u00a7cYou don\u2019t have permission to use this command.");
                    return true;
                }
                if (args.length != 3) {
                    player.sendMessage("Usage: /homeadmin <sethome|home|delhome|maxhomes> <player> <number>");
                    return true;
                }
                return this.handleHomeAdmin(player, args);
            }
        }
        return false;
    }

    private boolean handleSetHome(Player player, String arg) {
        int homeNum;
        UUID uuid = player.getUniqueId();
        int maxHomes = this.manager.getMaxHomes(uuid);
        try {
            homeNum = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cHome number must be a valid integer.");
            return false;
        }
        if (!(player.hasPermission("simplehomes.admin") || homeNum >= 1 && homeNum <= maxHomes)) {
            player.sendMessage("\u00a7cYou can only set homes between 1 and " + maxHomes + ".");
            return false;
        }
        if (this.manager.homeExists(uuid, homeNum)) {
            player.sendMessage("\u00a7cHome " + homeNum + " already exists.");
            return false;
        }
        this.manager.setHome(uuid, homeNum, player.getLocation());
        player.sendMessage("\u00a7aHome " + homeNum + " set!");
        return true;
    }

    private boolean handleHome(Player player, String arg) {
        int homeNum;
        UUID uuid = player.getUniqueId();
        int maxHomes = this.manager.getMaxHomes(uuid);
        try {
            homeNum = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cHome number must be a valid integer.");
            return false;
        }
        if (!(player.hasPermission("simplehomes.admin") || homeNum >= 1 && homeNum <= maxHomes)) {
            player.sendMessage("\u00a7cYou can only use homes between 1 and " + maxHomes + ".");
            return false;
        }
        if (!this.manager.homeExists(uuid, homeNum)) {
            player.sendMessage("\u00a7cHome " + homeNum + " does not exist.");
            return false;
        }
        this.cancelTeleport(player);
        TeleportTask task = new TeleportTask(this.plugin, player, this.manager.getHome(uuid, homeNum), 5, homeNum);
        task.start();
        this.teleportTasks.put(player.getUniqueId(), task);
        return true;
    }

    private boolean handleDelHome(Player player, String arg) {
        int homeNum;
        UUID uuid = player.getUniqueId();
        int maxHomes = this.manager.getMaxHomes(uuid);
        try {
            homeNum = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cHome number must be a valid integer.");
            return false;
        }
        if (!(player.hasPermission("simplehomes.admin") || homeNum >= 1 && homeNum <= maxHomes)) {
            player.sendMessage("\u00a7cYou can only delete homes between 1 and " + maxHomes + ".");
            return false;
        }
        if (!this.manager.homeExists(uuid, homeNum)) {
            player.sendMessage("\u00a7cHome " + homeNum + " does not exist.");
            return false;
        }
        this.manager.deleteHome(uuid, homeNum);
        player.sendMessage("\u00a7aHome " + homeNum + " deleted!");
        return true;
    }

    private boolean handleHomeAdmin(Player sender, String[] args) {
        int number;
        UUID targetUUID;
        String action = args[0].toLowerCase();
        String targetName = args[1];
        String numberStr = args[2];
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target != null) {
            targetUUID = target.getUniqueId();
        } else if (this.manager.getOfflinePlayerUUID(targetName) != null) {
            targetUUID = this.manager.getOfflinePlayerUUID(targetName);
        } else {
            sender.sendMessage("\u00a7cPlayer '" + targetName + "' not found.");
            return false;
        }
        targetName = this.manager.getOfflinePlayerName(targetUUID);
        try {
            number = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cNumber must be a valid integer.");
            return false;
        }
        switch (action) {
            case "sethome": {
                if (this.manager.homeExists(targetUUID, number)) {
                    sender.sendMessage("\u00a7cHome " + number + " already exists for " + targetName + ".");
                    return false;
                }
                this.manager.setHome(targetUUID, number, sender.getLocation());
                sender.sendMessage("\u00a7aSet Home " + number + " of " + targetName + ".");
                break;
            }
            case "home": {
                Location loc = this.manager.getHome(targetUUID, number);
                if (loc == null) {
                    sender.sendMessage("\u00a7cHome " + number + " does not exist for " + targetName + ".");
                    return false;
                }
                this.cancelTeleport(sender);
                TeleportTaskAdmin task = new TeleportTaskAdmin(this.plugin, sender, loc, 5, number, targetName);
                task.start();
                this.teleportTasksAdmin.put(sender.getUniqueId(), task);
                break;
            }
            case "delhome": {
                if (!this.manager.homeExists(targetUUID, number)) {
                    sender.sendMessage("\u00a7cHome " + number + " does not exist for " + targetName + ".");
                    return false;
                }
                this.manager.deleteHome(targetUUID, number);
                sender.sendMessage("\u00a7aDeleted Home " + number + " of " + targetName + ".");
                break;
            }
            case "maxhomes": {
                if (number < 1 || number > 50) {
                    sender.sendMessage("\u00a7cNumber must be between 1 and 50.");
                    return false;
                }
                this.manager.setMaxHomes(targetUUID, number);
                sender.sendMessage("\u00a7aSet max homes for " + targetName + " to " + number + ".");
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUsage: /homeadmin <sethome|home|delhome|maxhomes> <player> <number>");
                return false;
            }
        }
        return true;
    }

    private void cancelTeleport(Player player) {
        TeleportTaskAdmin taskAdmin;
        TeleportTask task = this.teleportTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
        if ((taskAdmin = this.teleportTasksAdmin.remove(player.getUniqueId())) != null) {
            taskAdmin.cancel();
        }
    }
}

