/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.SimpleHomes;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportTask {
    private final SimpleHomes plugin;
    private final Player player;
    private final Location targetLocation;
    private final int homeNum;
    private int secondsLeft;
    private Location startLocation;
    private BukkitRunnable task;

    public TeleportTask(SimpleHomes plugin, Player player, Location targetLocation, int seconds, int homeNum) {
        this.plugin = plugin;
        this.player = player;
        this.targetLocation = targetLocation;
        this.secondsLeft = seconds;
        this.homeNum = homeNum;
    }

    public void start() {
        this.startLocation = this.player.getLocation().getBlock().getLocation();
        this.task = new BukkitRunnable(){

            public void run() {
                if (!TeleportTask.this.player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location current = TeleportTask.this.player.getLocation().getBlock().getLocation();
                if (!current.equals((Object)TeleportTask.this.startLocation)) {
                    TeleportTask.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cTeleport cancelled! You moved!"));
                    this.cancel();
                    return;
                }
                if (TeleportTask.this.secondsLeft <= 0) {
                    TeleportTask.this.player.teleport(TeleportTask.this.targetLocation);
                    TeleportTask.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aTeleported to Home " + TeleportTask.this.homeNum + "!"));
                    this.cancel();
                    return;
                }
                TeleportTask.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a76Teleporting in \u00a7a" + TeleportTask.this.secondsLeft + " \u00a76Seconds!"));
                --TeleportTask.this.secondsLeft;
            }
        };
        this.task.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

