/*
 * Decompiled with CFR 0.152.
 */
package com.flummidill.simplehomes;

import com.flummidill.simplehomes.SimpleHomes;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportTaskAdmin {
    private final SimpleHomes plugin;
    private final Player player;
    private final Location targetLocation;
    private final String targetPlayerName;
    private final int homeNum;
    private int secondsLeft;
    private Location startLocation;
    private BukkitRunnable task;

    public TeleportTaskAdmin(SimpleHomes plugin, Player player, Location targetLocation, int seconds, int homeNum, String targetPlayerName) {
        this.plugin = plugin;
        this.player = player;
        this.targetLocation = targetLocation;
        this.secondsLeft = seconds;
        this.homeNum = homeNum;
        this.targetPlayerName = targetPlayerName;
    }

    public void start() {
        this.startLocation = this.player.getLocation().getBlock().getLocation();
        this.task = new BukkitRunnable(){

            public void run() {
                if (!TeleportTaskAdmin.this.player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location current = TeleportTaskAdmin.this.player.getLocation().getBlock().getLocation();
                if (!current.equals((Object)TeleportTaskAdmin.this.startLocation)) {
                    TeleportTaskAdmin.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7cTeleport cancelled! You moved!"));
                    this.cancel();
                    return;
                }
                if (TeleportTaskAdmin.this.secondsLeft <= 0) {
                    TeleportTaskAdmin.this.player.teleport(TeleportTaskAdmin.this.targetLocation);
                    TeleportTaskAdmin.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a7aTeleported to Home " + TeleportTaskAdmin.this.homeNum + " of " + TeleportTaskAdmin.this.targetPlayerName + "!"));
                    this.cancel();
                    return;
                }
                TeleportTaskAdmin.this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent("\u00a76Teleporting in \u00a7a" + TeleportTaskAdmin.this.secondsLeft + " \u00a76Seconds!"));
                --TeleportTaskAdmin.this.secondsLeft;
            }
        };
        this.task.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
        }
    }
}

