// 配置参数const 
RU = Resources;
const MM = ModelManager;
const MCU = MinecraftClient;
const MODELS = ModelManager.loadPartedRawModel(RU.manager(), RU.id("mtrsteamloco:eyecandies/signals/flashing_red.obj"), null);
const BASE = ModelManager.uploadVertArrays(MODELS.get("base"));
const ON = ModelManager.uploadVertArrays(MODELS.get("lighton"));
const OFF = ModelManager.uploadVertArrays(MODELS.get("lightoff"));

// 状态控制

// 定義常量
const BLINK_ON_DURATION = 100;  // 亮燈時間 (ms)
const BLINK_OFF_DURATION = 1000; // 滅燈時間 (ms)
const BLINK_CYCLE = BLINK_ON_DURATION + BLINK_OFF_DURATION; // 完整週期

// 狀態管理
let lastUpdateTime = 0;
let isCurrentlyOn = false;

// 渲染邏輯
function render(ctx) {
    const currentTime = Date.now();
    const cycleTime = currentTime % BLINK_CYCLE;

    // 判斷當前應該亮還是滅
    const shouldBeOn = (cycleTime < BLINK_ON_DURATION);

    // 如果狀態改變，更新時間戳
    if (shouldBeOn !== isCurrentlyOn) {
        isCurrentlyOn = shouldBeOn;
        lastUpdateTime = currentTime;
    }

    // 先渲染 BASE
    ctx.drawModel(BASE, new Matrices());

    // 根據狀態渲染 ON 或 OFF
    if (isCurrentlyOn) {
        ctx.drawModel(ON, new Matrices());
    } else {
        ctx.drawModel(OFF, new Matrices());
    }
}

// 返回公開方法
