const RU = Resources;
const MM = ModelManager;
const MCU = MinecraftClient;
include(Resources.id("aphrodite:library/code/util/error_supplier.js"));
include(Resources.id("aphrodite:library/code/gui/orderly_responder.js"));

// Load models
const MODELS = ModelManager.loadPartedRawModel(RU.manager(), RU.id("mtrsteamloco:eyecandies/signals/modern4.obj"), null);

const BASE = ModelManager.uploadVertArrays(MODELS.get("base"));
const BACK = ModelManager.uploadVertArrays(MODELS.get("backboard"));
const VISOR = ModelManager.uploadVertArrays(MODELS.get("visor"));
const LONGVISOR = ModelManager.uploadVertArrays(MODELS.get("longvisor"));
const NOVISOR = ModelManager.uploadVertArrays(MODELS.get("novisor"));
const G = ModelManager.uploadVertArrays(MODELS.get("g"));
const R = ModelManager.uploadVertArrays(MODELS.get("r"));
const Y = ModelManager.uploadVertArrays(MODELS.get("y"));
const YY = ModelManager.uploadVertArrays(MODELS.get("yy"));
const OFF = ModelManager.uploadVertArrays(MODELS.get("off"));
// Setup config responders
const nodePosKey = "custom"
const modeKey = "mode";
const selectLightKey = "select_light";
const visortype = "VISOR"
const hasbackboard = "yes"

const VISORTYPE = new ConfigResponder.TextField(
    visortype,
    ComponentUtil.translatable("signal.visor.type"),
    "1"
).setErrorSupplier(str => {
    if (!["0", "1", "2"].includes(str)) {
        return Optional.of(ComponentUtil.translatable("error.aph.invalid_value"));
    }
    return Optional.empty();
}).setTooltipSupplier(str => Optional.of(asJavaArray([ComponentUtil.translatable("0-short visor 1-standard visor 2-extended visor")], Component)));

const BACKBOARD = new ConfigResponder.TextField(
    hasbackboard,
    ComponentUtil.translatable("backboard"),
    "1"
).setErrorSupplier(str => {
    if (!["0", "1"].includes(str)) {
        return Optional.of(ComponentUtil.translatable("error.aph.invalid_value"));
    }
    return Optional.empty();
}).setTooltipSupplier(str => Optional.of(asJavaArray([ComponentUtil.translatable("has backboard? (1/0)")], Component)));

const nodePosINPUT = new ConfigResponder.TextField(
    nodePosKey, 
    ComponentUtil.literal("Node Pos (x,y,z)"), 
    ""
).setTooltipSupplier(str => Optional.of(asJavaArray([
            ComponentUtil.literal("Leave empty to auto-detect."),
            ComponentUtil.literal("Format: x,y,z)")
        ], Component)))
        .setErrorSupplier(str => {
            if (!str) return Optional.empty();
            const parts = str.split(",");
            if (parts.length !== 3 || parts.some(p => isNaN(parseFloat(p)))) {
                return Optional.of(ComponentUtil.literal("Invalid format. Use x,y,z."));
            }
            return Optional.empty();
        })

const MODE_RESPONDER = new ConfigResponder.TextField(
    modeKey,
    ComponentUtil.translatable("name.raf.mode"),
    "0"
).setErrorSupplier(str => {
    if (!["0", "1"].includes(str)) {
        return Optional.of(ComponentUtil.translatable("error.aph.invalid_value"));
    }
    return Optional.empty();
}).setTooltipSupplier(str => Optional.of(asJavaArray([ComponentUtil.translatable("0-Auto 1-Manual")], Component)));

const LIGHT_RESPONDER = new ConfigResponder.TextField(
    selectLightKey,
    ComponentUtil.translatable("name.raf.select_light"),
    "g"
).setErrorSupplier(str => {
    if (!["g", "r", "y", "yy","off"].includes(str)) {
        return Optional.of(ComponentUtil.translatable("error.aph.invalid_value"));
    }
    return Optional.empty();
}).setTooltipSupplier(str => Optional.of(asJavaArray([ComponentUtil.translatable("g,r,y,yy,off")], Component)));

const RESS = orderlyResponder("Modern UK Signal", "Made by Andy_Wongg", [MODE_RESPONDER, LIGHT_RESPONDER,nodePosINPUT,BACKBOARD,VISORTYPE]);

function create(ctx, state, entity) {
    entity.registerCustomConfig(RESS);
    entity.sendUpdateC2S();
}

function render(ctx, state, entity) {
    let mat = new Matrices();
    mat.translate(0, 0.00625, 0);
    mat.rotateY(Math.PI); // Slight lift
    ctx.drawModel(BASE, mat);

    let mode = entity.getCustomConfig(modeKey) + "";
    let selectedLight = entity.getCustomConfig(selectLightKey) + "";
    let backboard = entity.getCustomConfig(hasbackboard) + "";
    let visor = entity.getCustomConfig(visortype) + "";

if (backboard === "1")
    {  
    ctx.drawModel(BACK, mat);
    }

if (visor === "0")
    {  
    ctx.drawModel(NOVISOR, mat);
    } else if (visor === "2"){
        ctx.drawModel(LONGVISOR, mat);
    } else {ctx.drawModel(VISOR, mat);}

    let oa = -1;
    try {
        let pos = entity.getWorldPosVector3f();
        let facing = entity.getBlockYRot() + entity.rotateY / Math.PI * 180 + 90;
        let nodePosStr = entity.getCustomConfig(nodePosKey);
let nodePos;

if (nodePosStr && nodePosStr.trim() !== "") {
    const parts = nodePosStr.split(",").map(Number);
    if (parts.length === 3 && parts.every(n => !isNaN(n))) {
        nodePos = new Vector3f(parts[0], parts[1], parts[2]);
    }
}

if (!nodePos) {
    nodePos = MCU.getNodeAt(pos, facing);
}
        oa = MCU.getOccupiedAspect(nodePos, facing, 4); // 4 possible aspects
    } catch (e) {}

    // Decide which model to draw
    let modelToDraw = null;

    if (mode === "0") {
        if (oa === 0) modelToDraw = G;
        else if (oa === 1) modelToDraw = R;
        else if (oa === 2) modelToDraw = Y;
        else if (oa === 3) modelToDraw = YY;
        else modelToDraw = OFF;
    } else if (mode === "1") {
        if (selectedLight === "g") modelToDraw = G;
        else if (selectedLight === "r") modelToDraw = R;
        else if (selectedLight === "y") modelToDraw = Y;
        else if (selectedLight === "yy") modelToDraw = YY;
        else modelToDraw = OFF;
    }

    if (modelToDraw != null) {
        ctx.drawModel(modelToDraw, mat);
    }
}
