#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform int worldTime;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 normal;

void main() {
    // Ana albedo rengi
    vec4 albedo = texture2D(texture, texcoord) * color;
    
    // Lightmap bilgisi
    vec3 lightmapColor = texture2D(lightmap, lmcoord).rgb;
    
    // Gece/gündüz aydınlatması
    float daylight = float(worldTime < 12000 || worldTime > 23000);
    float nightlight = 1.0 - daylight;
    
    // Lighting hesabı
    float torchLight = lightmapColor.r;
    float skyLight = lightmapColor.g;
    
    vec3 finalLighting = vec3(1.0);
    finalLighting *= max(0.1, skyLight * daylight + 0.3 * nightlight);
    finalLighting += torchLight * vec3(1.0, 0.8, 0.6);
    
    albedo.rgb *= finalLighting;
    
    gl_FragData[0] = albedo;
    gl_FragData[1] = vec4(lmcoord, normal.xy);
}