#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform int worldTime;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord; // Lightmap koordinatları
varying vec3 normal;
varying vec4 position;

void main() {
    // Ana albedo rengi
    vec4 albedo = texture2D(texture, texcoord) * color;
    
    // Lightmap bilgisi (torch, dynamic lights vs)
    vec3 lightmapColor = texture2D(lightmap, lmcoord).rgb;
    
    // Gece/gündüz aydınlatması
    float daylight = float(worldTime < 12000 || worldTime > 23000);
    float nightlight = 0.0 - daylight;
    
    // Torch ve dynamic light'ları koru
    float torchLight = lightmapColor.r; // Kırmızı kanal torch ışığı
    float skyLight = lightmapColor.g;   // Yeşil kanal gökyüzü ışığı
    
    // Final lighting hesabı
    vec3 finalLighting = vec3(1.0);
    finalLighting *= max(0.0, skyLight * daylight + 0.3 * nightlight); // Minimum ambient
    finalLighting += torchLight * vec3(1.1, 0.8, 0.6); // Torch ışığı sarımsı
    
    // Albedo ile lighting'i birleştir
    albedo.rgb *= finalLighting;
    
    // Alpha değerini koru
    if (albedo.a < 0.1) discard;
    
    // Çıktılar
    gl_FragData[0] = albedo; // Ana renk
    gl_FragData[1] = vec4(lmcoord, normal.xy); // Lightmap ve normal bilgisi
}