#version 120

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 normal;
varying vec4 position;

void main() {
    gl_Position = ftransform();
    
    color = gl_Color;
    texcoord = gl_MultiTexCoord0.xy;
    
    // Lightmap koordinatları
    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    
    // Normal vektör
    normal = normalize(gl_NormalMatrix * gl_Normal);
    
    // World pozisyonu
    position = gl_ModelViewMatrix * gl_Vertex;
}