/*
 * Decompiled with CFR 0.152.
 */
package eu.netleak.spawnguard.event;

import eu.netleak.spawnguard.config.SpawnGuardConfig;
import eu.netleak.spawnguard.effect.ModEffects;
import eu.netleak.spawnguard.potion.ModPotions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber(modid="spawnguard")
public class ModEvents {
    @SubscribeEvent
    public static void onSpawn(EntityJoinLevelEvent event) {
        Player player;
        Entity entity;
        if (((Boolean)SpawnGuardConfig.CONFIG.enableSpawnGuard.get()).booleanValue() && !event.getLevel().isClientSide && (entity = event.getEntity()) instanceof Player && !(player = (Player)entity).getPersistentData().getBoolean("GivenMobAttackProtectionEffect")) {
            player.getPersistentData().putBoolean("GivenMobAttackProtectionEffect", true);
            player.addEffect(new MobEffectInstance(ModEffects.MOB_ATTACK_PROTECTION_EFFECT, ((Integer)SpawnGuardConfig.CONFIG.mobAttackProtectionDuration.get()).intValue(), 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onAttack(LivingDamageEvent.Pre event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).hasEffect(ModEffects.MOB_ATTACK_PROTECTION_EFFECT) && (event.getSource().getEntity() instanceof Mob || event.getSource() == player.damageSources().magic() || event.getSource() == player.damageSources().wither())) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onTargetSet(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Monster) {
            Player player;
            Monster monster = (Monster)livingEntity;
            livingEntity = event.getNewAboutToBeSetTarget();
            if (livingEntity instanceof Player && (player = (Player)livingEntity).hasEffect(ModEffects.MOB_ATTACK_PROTECTION_EFFECT)) {
                monster.setTarget(null);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBrewingRecipeRegister(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.WEAKNESS, Items.BLAZE_POWDER, ModPotions.MOB_ATTACK_PROTECTION_POTION);
        builder.addMix(ModPotions.MOB_ATTACK_PROTECTION_POTION, Items.REDSTONE, ModPotions.LONG_MOB_ATTACK_PROTECTION_POTION);
    }
}

