/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.battery.PowerState;
import dev.isxander.controlify.controller.dualsense.DualSenseComponent;
import dev.isxander.controlify.controller.haptic.HDHapticComponent;
import dev.isxander.controlify.controller.haptic.HapticBufferLibrary;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controller.rumble.TriggerRumbleComponent;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.driver.sdl.dualsense.DS5EffectsState;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.sdl3java.api.audio.SDL_AudioDeviceID;
import dev.isxander.sdl3java.api.audio.SDL_AudioFormat;
import dev.isxander.sdl3java.api.audio.SDL_AudioSpec;
import dev.isxander.sdl3java.api.audio.SDL_AudioStream;
import dev.isxander.sdl3java.api.audio.SdlAudio;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickGUID;
import dev.isxander.sdl3java.api.joystick.SDL_JoystickID;
import dev.isxander.sdl3java.api.properties.SDL_PropertiesID;
import dev.isxander.sdl3java.api.properties.SdlProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public abstract class SDLCommonDriver<SDL_Controller>
implements Driver {
    private static final int AUDIO_STREAM_TIMEOUT_TICKS = 360000;
    protected SDL_Controller ptrController;
    protected BatteryLevelComponent batteryLevelComponent;
    protected RumbleComponent rumbleComponent;
    protected TriggerRumbleComponent triggerRumbleComponent;
    protected HDHapticComponent hdHapticComponent;
    protected DualSenseComponent dualSenseComponent;
    protected final boolean isRumbleSupported;
    protected final boolean isTriggerRumbleSupported;
    protected final boolean isDualsense;
    protected final String guid;
    protected final String serial;
    protected final String name;
    protected final SDL_PropertiesID props;
    @Nullable
    protected SDL_AudioDeviceID dualsenseAudioDev;
    @Nullable
    protected SDL_AudioSpec dualsenseAudioSpec;
    protected final List<AudioStreamHandle> dualsenseAudioHandles;

    public SDLCommonDriver(SDL_Controller ptrController, SDL_JoystickID jid, ControllerType type) {
        this.ptrController = ptrController;
        this.props = this.SDL_GetControllerProperties(ptrController);
        this.name = this.SDL_GetControllerName(ptrController);
        this.guid = this.SDL_GetControllerGUIDForID(jid).toString();
        this.serial = this.SDL_GetControllerSerial(ptrController);
        this.isRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)this.props, (String)"SDL.joystick.cap.rumble", (boolean)false);
        this.isTriggerRumbleSupported = SdlProperties.SDL_GetBooleanProperty((SDL_PropertiesID)this.props, (String)"SDL.joystick.cap.trigger_rumble", (boolean)false);
        this.dualsenseAudioHandles = new ArrayList<AudioStreamHandle>();
        if (CUtil.rl("dualsense").equals((Object)type.namespace())) {
            this.isDualsense = true;
            if (class_156.method_668() != class_156.class_158.field_1137) {
                SDL_AudioDeviceID dualsenseAudioDev = null;
                SDL_AudioSpec.ByReference devSpec = new SDL_AudioSpec.ByReference();
                for (SDL_AudioDeviceID dev : SdlAudio.SDL_GetAudioPlaybackDevices()) {
                    String name = SdlAudio.SDL_GetAudioDeviceName((SDL_AudioDeviceID)dev).toLowerCase();
                    if (!name.contains("dualsense") && !name.contains("ps5") && !name.contains("wireless controller")) continue;
                    SdlAudio.SDL_GetAudioDeviceFormat((SDL_AudioDeviceID)dev, (SDL_AudioSpec.ByReference)devSpec, null);
                    if (devSpec.channels != 4) continue;
                    dualsenseAudioDev = dev;
                    break;
                }
                if (dualsenseAudioDev != null) {
                    this.dualsenseAudioSpec = devSpec;
                    this.dualsenseAudioDev = SdlAudio.SDL_OpenAudioDevice(dualsenseAudioDev, (SDL_AudioSpec.ByReference)((SDL_AudioSpec.ByReference)this.dualsenseAudioSpec));
                }
            }
        } else {
            this.isDualsense = false;
        }
    }

    @Override
    public void addComponents(ControllerEntity controller) {
        this.batteryLevelComponent = new BatteryLevelComponent();
        controller.setComponent(this.batteryLevelComponent);
        if (this.isRumbleSupported) {
            this.rumbleComponent = new RumbleComponent();
            controller.setComponent(this.rumbleComponent);
        }
        if (this.isTriggerRumbleSupported) {
            this.triggerRumbleComponent = new TriggerRumbleComponent();
            controller.setComponent(this.triggerRumbleComponent);
        }
        if (this.isDualsense) {
            this.dualSenseComponent = new DualSenseComponent();
            controller.setComponent(this.dualSenseComponent);
        }
        if (this.dualsenseAudioDev != null) {
            this.hdHapticComponent = new HDHapticComponent();
            controller.setComponent(this.hdHapticComponent);
            this.hdHapticComponent.acceptPlayHaptic(this::playHaptic);
        }
        if (this.isBluetooth()) {
            controller.setComponent(new BluetoothDeviceComponent());
        }
    }

    @Override
    public String getDriverName() {
        return this.name;
    }

    @Override
    public void update(ControllerEntity controller, boolean outOfFocus) {
        if (this.ptrController == null) {
            throw new IllegalStateException("Tried to update controller when it's closed.");
        }
        this.updateRumble();
        this.updateBatteryLevel();
        this.updateDualSense();
        this.updateHDHaptic();
    }

    @Override
    public void close() {
        if (this.ptrController == null) {
            throw new IllegalStateException("Tried to close controller when it's already closed.");
        }
        this.SDL_CloseController(this.ptrController);
        this.ptrController = null;
        if (this.dualsenseAudioDev != null) {
            SdlAudio.SDL_CloseAudioDevice((SDL_AudioDeviceID)this.dualsenseAudioDev);
            this.dualsenseAudioDev = null;
            for (AudioStreamHandle handle : this.dualsenseAudioHandles) {
                handle.close();
            }
        }
    }

    protected void updateRumble() {
        Optional<Record> stateOpt;
        if (this.isRumbleSupported) {
            stateOpt = this.rumbleComponent.consumeRumble();
            stateOpt.ifPresent(state -> {
                if (!this.SDL_RumbleController(this.ptrController, state.strong(), state.weak(), 5000)) {
                    CUtil.LOGGER.error("Could not rumble gamepad: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
        if (this.isTriggerRumbleSupported) {
            stateOpt = this.triggerRumbleComponent.consumeTriggerRumble();
            stateOpt.ifPresent(state -> {
                if (!this.SDL_RumbleControllerTriggers(this.ptrController, state.left(), state.right(), 0)) {
                    CUtil.LOGGER.error("Could not rumble triggers gamepad: {}", (Object)SdlError.SDL_GetError());
                }
            });
        }
    }

    private void updateBatteryLevel() {
        IntByReference percent = new IntByReference();
        int powerState = this.SDL_GetControllerPowerInfo(this.ptrController, percent);
        Record level = switch (powerState) {
            case -1, 0 -> new PowerState.Unknown();
            case 1 -> new PowerState.Depleting(percent.getValue());
            case 2 -> new PowerState.WiredOnly();
            case 3 -> new PowerState.Charging(percent.getValue());
            case 4 -> new PowerState.Full();
            default -> throw new IllegalStateException("Unexpected value");
        };
        this.batteryLevelComponent.setBatteryLevel((PowerState)((Object)level));
    }

    private void updateDualSense() {
        if (this.dualSenseComponent == null) {
            return;
        }
        DS5EffectsState.ByValue effectsState = new DS5EffectsState.ByValue();
        if (this.dualSenseComponent.consumeDirty()) {
            effectsState.ucEnableBits1 = (byte)(effectsState.ucEnableBits1 | 8);
            effectsState.rgucLeftTriggerEffect = this.dualSenseComponent.getLeftTriggerEffect();
            effectsState.ucEnableBits1 = (byte)(effectsState.ucEnableBits1 | 4);
            effectsState.rgucRightTriggerEffect = this.dualSenseComponent.getRightTriggerEffect();
            effectsState.ucEnableBits2 = (byte)(effectsState.ucEnableBits2 | 1);
            effectsState.ucMicLightMode = (byte)(this.dualSenseComponent.getMuteLight() ? 1 : 0);
            effectsState.write();
            this.SDL_SendControllerEffect(this.ptrController, effectsState.getPointer(), Native.getNativeSize(DS5EffectsState.ByValue.class));
        }
    }

    private void updateHDHaptic() {
        for (int i = 0; i < this.dualsenseAudioHandles.size(); ++i) {
            AudioStreamHandle handle = this.dualsenseAudioHandles.get(i);
            if (handle.isTimedOut()) {
                handle.close();
                this.dualsenseAudioHandles.remove(handle);
                continue;
            }
            handle.tick();
        }
    }

    private void playHaptic(HapticBufferLibrary.HapticBuffer sound) {
        if (this.ptrController == null || this.dualsenseAudioDev == null || this.dualsenseAudioSpec == null) {
            return;
        }
        SDL_AudioSpec spec = new SDL_AudioSpec();
        spec.channels = sound.format().getChannels();
        spec.freq = (int)sound.format().getSampleRate();
        int ss = sound.format().getSampleSizeInBits();
        int byteSs = ss / 8;
        AudioFormat.Encoding encoding = sound.format().getEncoding();
        if (ss == 8) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat(32776L);
            } else if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                spec.format = new SDL_AudioFormat(8L);
            }
        } else if (sound.format().isBigEndian()) {
            SDLCommonDriver.audioFmtEndian(spec, ss, encoding, 36880, 36896, 37152);
        } else {
            SDLCommonDriver.audioFmtEndian(spec, ss, encoding, 32784, 32800, 33056);
        }
        if (spec.format == null) {
            throw new IllegalStateException("Unsupported format");
        }
        AudioStreamHandle handle = null;
        for (AudioStreamHandle stream : this.dualsenseAudioHandles) {
            SDL_AudioSpec streamSpec = stream.getSpec();
            if (streamSpec.format.intValue() != spec.format.intValue() || streamSpec.freq != spec.freq || streamSpec.channels != spec.channels || stream.isInUse()) continue;
            handle = stream;
            break;
        }
        int length = sound.audio().length / spec.freq / spec.channels / byteSs * 20;
        if (handle != null) {
            handle.queueAudio(sound.audio(), length);
        } else {
            if (this.dualsenseAudioHandles.size() >= 16) {
                this.dualsenseAudioHandles.remove(0).close();
            }
            AudioStreamHandle newHandle = AudioStreamHandle.createWithAudio(this.dualsenseAudioDev, spec, this.dualsenseAudioSpec, sound.audio(), length);
            this.dualsenseAudioHandles.add(newHandle);
        }
    }

    private static void audioFmtEndian(SDL_AudioSpec spec, int ss, AudioFormat.Encoding encoding, int signed16, int signed32, int float32) {
        if (ss == 16) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed16);
            }
        } else if (ss == 32) {
            if (encoding == AudioFormat.Encoding.PCM_SIGNED) {
                spec.format = new SDL_AudioFormat((long)signed32);
            } else if (encoding == AudioFormat.Encoding.PCM_FLOAT) {
                spec.format = new SDL_AudioFormat((long)float32);
            }
        }
    }

    protected boolean isBluetooth() {
        return this.dualsenseAudioDev == null && this.isDualsense;
    }

    protected abstract SDL_PropertiesID SDL_GetControllerProperties(SDL_Controller var1);

    protected abstract String SDL_GetControllerName(SDL_Controller var1);

    protected abstract SDL_JoystickGUID SDL_GetControllerGUIDForID(SDL_JoystickID var1);

    protected abstract String SDL_GetControllerSerial(SDL_Controller var1);

    protected abstract boolean SDL_CloseController(SDL_Controller var1);

    protected abstract boolean SDL_RumbleController(SDL_Controller var1, float var2, float var3, int var4);

    protected abstract boolean SDL_RumbleControllerTriggers(SDL_Controller var1, float var2, float var3, int var4);

    protected abstract int SDL_GetControllerPowerInfo(SDL_Controller var1, IntByReference var2);

    protected abstract boolean SDL_SendControllerEffect(SDL_Controller var1, Pointer var2, int var3);

    protected static class AudioStreamHandle {
        private int streamLastPlayed;
        private final SDL_AudioStream stream;
        private final SDL_AudioSpec spec;

        private AudioStreamHandle(SDL_AudioStream stream, SDL_AudioSpec spec) {
            this.stream = stream;
            this.spec = spec;
            this.streamLastPlayed = 0;
        }

        public void queueAudio(byte[] audio, int tickLength) {
            try (Memory memory = new Memory((long)audio.length);){
                memory.write(0L, audio, 0, audio.length);
                SdlAudio.SDL_PutAudioStreamData((SDL_AudioStream)this.stream, (Pointer)memory, (int)audio.length);
                this.streamLastPlayed = Math.min(0, this.streamLastPlayed);
                this.streamLastPlayed -= tickLength;
            }
        }

        public SDL_AudioSpec getSpec() {
            return this.spec;
        }

        public boolean isInUse() {
            return this.streamLastPlayed < 0;
        }

        public boolean isTimedOut() {
            return this.streamLastPlayed >= 360000;
        }

        public void tick() {
            ++this.streamLastPlayed;
        }

        public void close() {
            SdlAudio.SDL_DestroyAudioStream((SDL_AudioStream)this.stream);
        }

        public static AudioStreamHandle createWithAudio(SDL_AudioDeviceID device, SDL_AudioSpec audioSpec, SDL_AudioSpec devSpec, byte[] audio, int tickLength) {
            SDL_AudioStream stream = SdlAudio.SDL_CreateAudioStream((SDL_AudioSpec)audioSpec, (SDL_AudioSpec)devSpec);
            SdlAudio.SDL_BindAudioStream((SDL_AudioDeviceID)device, (SDL_AudioStream)stream);
            AudioStreamHandle handle = new AudioStreamHandle(stream, audioSpec);
            handle.queueAudio(audio, tickLength);
            return handle;
        }

        public static AudioStreamHandle createWithInitialTimeout(SDL_AudioDeviceID device, SDL_AudioSpec srcSpec, SDL_AudioSpec devSpec) {
            SDL_AudioStream stream = SdlAudio.SDL_CreateAudioStream((SDL_AudioSpec)srcSpec, (SDL_AudioSpec)devSpec);
            SdlAudio.SDL_BindAudioStream((SDL_AudioDeviceID)device, (SDL_AudioStream)stream);
            return new AudioStreamHandle(stream, srcSpec);
        }
    }
}

