/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.steamdeck;

import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.steamdeck.SteamDeckMode;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.deckapi.api.SteamDeck;
import dev.isxander.deckapi.api.SteamDeckException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class SteamDeckUtil {
    @Nullable
    private static SteamDeck deckInstance;
    private static boolean triedToLoad;
    public static final boolean IS_STEAM_DECK;
    public static final SteamDeckMode DECK_MODE;
    public static final boolean IS_SANDBOXED;
    public static final class_2960 STEAM_DECK_NAMESPACE;

    public static Optional<SteamDeck> getDeckInstance() {
        if (triedToLoad) {
            return Optional.ofNullable(deckInstance);
        }
        triedToLoad = true;
        if (!DECK_MODE.isGamingMode()) {
            CUtil.LOGGER.warn("Device is not a Steam Deck or not in gaming mode, skipping Steam Deck driver initialization.");
            return Optional.empty();
        }
        try {
            String url = DebugProperties.STEAM_DECK_CUSTOM_CEF_URL;
            if (url == null) {
                url = "http://localhost:8080";
            }
            deckInstance = SteamDeck.create((String)url);
        }
        catch (SteamDeckException e) {
            CUtil.LOGGER.error("Failed to create SteamDeck instance", (Throwable)e);
            deckInstance = null;
        }
        return Optional.ofNullable(deckInstance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isHardwareSteamDeck() {
        boolean isLinux = "Linux".equals(System.getProperty("os.name"));
        if (!isLinux) {
            return false;
        }
        String kernelVersion = System.getProperty("os.version");
        boolean valveKernel = kernelVersion.contains("valve");
        String boardVendor = SteamDeckUtil.readFile("/sys/class/dmi/id/board_vendor");
        if (boardVendor == null) {
            return false;
        }
        String boardName = SteamDeckUtil.readFile("/sys/class/dmi/id/board_name");
        if (boardName == null) {
            return false;
        }
        Stream<String> validBoardNames = Stream.of("Jupiter", "Galileo");
        if (!boardVendor.contains("Valve")) return false;
        if (!validBoardNames.anyMatch(boardName::contains)) return false;
        return true;
    }

    private static SteamDeckMode getSteamDeckMode() {
        if (IS_STEAM_DECK) {
            String steamDeck = System.getenv("SteamDeck");
            if (steamDeck != null && steamDeck.equals("1")) {
                return SteamDeckMode.GAMING_MODE;
            }
            return SteamDeckMode.DESKTOP_MODE;
        }
        return SteamDeckMode.NOT_STEAM_DECK;
    }

    private static String readFile(String path) {
        try {
            return Files.readString(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    static {
        triedToLoad = false;
        IS_STEAM_DECK = SteamDeckUtil.isHardwareSteamDeck();
        DECK_MODE = SteamDeckUtil.getSteamDeckMode();
        IS_SANDBOXED = "1".equals(System.getenv("container"));
        STEAM_DECK_NAMESPACE = CUtil.rl("steam_deck");
    }
}

