/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.ReflectedAudio;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.config.ReverbParams;
import com.sonicether.soundphysics.debug.RaycastRenderer;
import com.sonicether.soundphysics.profiling.TaskProfiler;
import com.sonicether.soundphysics.utils.LevelAccessUtils;
import com.sonicether.soundphysics.utils.RaycastUtils;
import com.sonicether.soundphysics.world.ClientLevelProxy;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3f;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.EXTEfx;

public class SoundPhysics {
    private static final float PHI = 1.618034f;
    private static final Pattern AMBIENT_PATTERN = Pattern.compile("^[a-zA-Z0-9_\\-\\.]+:ambient\\..*$");
    private static final Pattern BLOCK_PATTERN = Pattern.compile(".*block..*");
    private static final Pattern VOICECHAT_PATTERN = Pattern.compile("^voicechat:.*$");
    private static int auxFXSlot0;
    private static int auxFXSlot1;
    private static int auxFXSlot2;
    private static int auxFXSlot3;
    private static int reverb0;
    private static int reverb1;
    private static int reverb2;
    private static int reverb3;
    private static int directFilter0;
    private static int sendFilter0;
    private static int sendFilter1;
    private static int sendFilter2;
    private static int sendFilter3;
    private static class_310 minecraft;
    private static TaskProfiler profiler;
    private static class_3419 lastSoundCategory;
    private static String lastSoundName;
    private static int maxAuxSends;

    public static void init() {
        Loggers.log("Initializing Sound Physics", new Object[0]);
        SoundPhysics.setupEFX();
        Loggers.log("EFX ready", new Object[0]);
        minecraft = class_310.method_1551();
        profiler = new TaskProfiler("Sound Physics");
    }

    public static void syncReverbParams() {
        if (auxFXSlot0 != 0) {
            SoundPhysics.setReverbParams(ReverbParams.getReverb0(), auxFXSlot0, reverb0);
            SoundPhysics.setReverbParams(ReverbParams.getReverb1(), auxFXSlot1, reverb1);
            SoundPhysics.setReverbParams(ReverbParams.getReverb2(), auxFXSlot2, reverb2);
            SoundPhysics.setReverbParams(ReverbParams.getReverb3(), auxFXSlot3, reverb3);
        }
    }

    static void setupEFX() {
        long currentContext = ALC10.alcGetCurrentContext();
        long currentDevice = ALC10.alcGetContextsDevice((long)currentContext);
        if (!ALC10.alcIsExtensionPresent((long)currentDevice, (CharSequence)"ALC_EXT_EFX")) {
            Loggers.error("EFX Extension not found on current device. Aborting.", new Object[0]);
            return;
        }
        Loggers.log("EFX Extension recognized", new Object[0]);
        maxAuxSends = ALC10.alcGetInteger((long)currentDevice, (int)131075);
        Loggers.log("Max auxiliary sends: {}", maxAuxSends);
        auxFXSlot0 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot0);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot0, (int)3, (int)1);
        auxFXSlot1 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot1);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot1, (int)3, (int)1);
        auxFXSlot2 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot2);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot2, (int)3, (int)1);
        auxFXSlot3 = EXTEfx.alGenAuxiliaryEffectSlots();
        Loggers.log("Aux slot {} created", auxFXSlot3);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot3, (int)3, (int)1);
        Loggers.logALError("Failed creating auxiliary effect slots");
        reverb0 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb0, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 0");
        reverb1 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb1, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 1");
        reverb2 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb2, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 2");
        reverb3 = EXTEfx.alGenEffects();
        EXTEfx.alEffecti((int)reverb3, (int)32769, (int)32768);
        Loggers.logALError("Failed creating reverb effect slot 3");
        directFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)directFilter0, (int)32769, (int)1);
        Loggers.logDebug("directFilter0: {}", directFilter0);
        sendFilter0 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter0, (int)32769, (int)1);
        Loggers.logDebug("filter0: {}", sendFilter0);
        sendFilter1 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter1, (int)32769, (int)1);
        Loggers.logDebug("filter1: {}", sendFilter1);
        sendFilter2 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter2, (int)32769, (int)1);
        Loggers.logDebug("filter2: {}", sendFilter2);
        sendFilter3 = EXTEfx.alGenFilters();
        EXTEfx.alFilteri((int)sendFilter3, (int)32769, (int)1);
        Loggers.logDebug("filter3: {}", sendFilter3);
        Loggers.logALError("Error creating lowpass filters");
        SoundPhysics.syncReverbParams();
    }

    public static void setLastSoundCategoryAndName(class_3419 sc, String name) {
        lastSoundCategory = sc;
        lastSoundName = name;
    }

    public static void onPlaySound(double posX, double posY, double posZ, int sourceID) {
        SoundPhysics.processSound(sourceID, posX, posY, posZ, lastSoundCategory, lastSoundName, false);
    }

    public static void onPlayReverb(double posX, double posY, double posZ, int sourceID) {
        SoundPhysics.processSound(sourceID, posX, posY, posZ, lastSoundCategory, lastSoundName, true);
    }

    public static class_243 processSound(int source, double posX, double posY, double posZ, class_3419 category, String sound) {
        return SoundPhysics.processSound(source, posX, posY, posZ, category, sound, false);
    }

    @Nullable
    public static class_243 processSound(int source, double posX, double posY, double posZ, class_3419 category, String sound, boolean auxOnly) {
        if (!SoundPhysicsMod.CONFIG.enabled.get().booleanValue()) {
            return null;
        }
        Loggers.logDebug("Playing sound with source id '{}', position x:{}, y:{}, z:{}, \tcategory: '{}' \tname: '{}'", source, posX, posY, posZ, category.toString(), sound);
        TaskProfiler.TaskProfilerHandle profile = profiler.profile();
        class_243 newPos = SoundPhysics.evaluateEnvironment(source, posX, posY, posZ, category, sound, auxOnly);
        profile.finish();
        Loggers.logProfiling("Evaluated environment for sound {} in {} ms", sound, profile.getDuration());
        profiler.onTally(() -> profiler.logResults());
        return newPos;
    }

    @Nullable
    private static class_243 evaluateEnvironment(int sourceID, double posX, double posY, double posZ, class_3419 category, String sound, boolean auxOnly) {
        int i;
        class_746 player = SoundPhysics.minecraft.field_1724;
        class_638 level = SoundPhysics.minecraft.field_1687;
        if (player == null || level == null || posX == 0.0 && posY == 0.0 && posZ == 0.0) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        class_243 soundPos = new class_243(posX, posY, posZ);
        double distance = player.method_19538().method_1022(soundPos);
        if (distance > SoundPhysicsMod.CONFIG.maxSoundProcessingDistance.get()) {
            Loggers.logDebug("Sound {} is too far away from player ({} blocks)", sound, distance);
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.CONFIG.updateMovingSounds.get().booleanValue() && category == class_3419.field_15247) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.ALLOWED_SOUND_CONFIG.isAllowed(sound)) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        if (!SoundPhysicsMod.CONFIG.evaluateAmbientSounds.get().booleanValue() && SoundPhysics.isAmbientSound(sound)) {
            SoundPhysics.setDefaultEnvironment(sourceID, auxOnly);
            return null;
        }
        float absorptionCoeff = (float)((double)SoundPhysicsMod.CONFIG.blockAbsorption.get().floatValue() * 3.0);
        class_243 playerPos = SoundPhysics.minecraft.field_1773.method_19418().method_19326();
        class_243 normalToPlayer = playerPos.method_1020(soundPos).method_1029();
        class_2338 soundBlockPos = class_2338.method_49638((class_2374)soundPos);
        Loggers.logDebug("Player pos: {}, {}, {} \tSound Pos: {}, {}, {} \tTo player vector: {}, {}, {}", playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, normalToPlayer.field_1352, normalToPlayer.field_1351, normalToPlayer.field_1350);
        double occlusionAccumulation = SoundPhysics.calculateOcclusion(soundPos, playerPos, category, sound);
        float directCutoff = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff);
        float directGain = auxOnly ? 0.0f : (float)Math.pow(directCutoff, 0.1);
        Loggers.logOcclusion("Direct cutoff: {}, direct gain: {}", Float.valueOf(directCutoff), Float.valueOf(directGain));
        float sendGain0 = 0.0f;
        float sendGain1 = 0.0f;
        float sendGain2 = 0.0f;
        float sendGain3 = 0.0f;
        float sendCutoff0 = 1.0f;
        float sendCutoff1 = 1.0f;
        float sendCutoff2 = 1.0f;
        float sendCutoff3 = 1.0f;
        if (SoundPhysics.minecraft.field_1724.method_5869()) {
            directCutoff *= 1.0f - SoundPhysicsMod.CONFIG.underwaterFilter.get().floatValue();
        }
        float maxDistance = 256.0f;
        int numRays = SoundPhysicsMod.CONFIG.environmentEvaluationRayCount.get();
        int rayBounces = SoundPhysicsMod.CONFIG.environmentEvaluationRayBounces.get();
        ReflectedAudio audioDirection = new ReflectedAudio(occlusionAccumulation, sound);
        float[] bounceReflectivityRatio = new float[rayBounces];
        float rcpTotalRays = 1.0f / (float)(numRays * rayBounces);
        float gAngle = 10.166408f;
        class_243 directSharedAirspaceVector = SoundPhysics.getSharedAirspace(soundPos, playerPos);
        if (directSharedAirspaceVector != null) {
            audioDirection.addDirectAirspace(directSharedAirspaceVector);
        }
        block0: for (i = 0; i < numRays; ++i) {
            float fiN = (float)i / (float)numRays;
            float longitude = gAngle * (float)i * 1.0f;
            float latitude = (float)Math.asin(fiN * 2.0f - 1.0f);
            class_243 rayDir = new class_243(Math.cos(latitude) * Math.cos(longitude), Math.cos(latitude) * Math.sin(longitude), Math.sin(latitude));
            class_243 rayEnd = new class_243(soundPos.field_1352 + rayDir.field_1352 * (double)maxDistance, soundPos.field_1351 + rayDir.field_1351 * (double)maxDistance, soundPos.field_1350 + rayDir.field_1350 * (double)maxDistance);
            class_3965 rayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), soundPos, rayEnd, soundBlockPos);
            if (rayHit.method_17783() != class_239.class_240.field_1332) continue;
            double rayLength = soundPos.method_1022(rayHit.method_17784());
            class_2338 lastHitBlock = rayHit.method_17777();
            class_243 lastHitPos = rayHit.method_17784();
            class_243 lastHitNormal = new class_243(rayHit.method_17780().method_23955());
            class_243 lastRayDir = rayDir;
            float totalRayDistance = (float)rayLength;
            RaycastRenderer.addSoundBounceRay(soundPos, rayHit.method_17784(), class_124.field_1060.method_532());
            class_243 firstSharedAirspaceVector = SoundPhysics.getSharedAirspace(rayHit, playerPos);
            if (firstSharedAirspaceVector != null) {
                audioDirection.addSharedAirspace(firstSharedAirspaceVector, totalRayDistance);
            }
            for (int j = 0; j < rayBounces; ++j) {
                class_243 newRayDir = SoundPhysics.reflect(lastRayDir, lastHitNormal);
                class_243 newRayStart = lastHitPos;
                class_243 newRayEnd = new class_243(newRayStart.field_1352 + newRayDir.field_1352 * (double)maxDistance, newRayStart.field_1351 + newRayDir.field_1351 * (double)maxDistance, newRayStart.field_1350 + newRayDir.field_1350 * (double)maxDistance);
                class_3965 newRayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), newRayStart, newRayEnd, lastHitBlock);
                float blockReflectivity = SoundPhysics.getBlockReflectivity(lastHitBlock);
                float energyTowardsPlayer = 0.25f * (blockReflectivity * 0.75f + 0.25f);
                if (newRayHit.method_17783() == class_239.class_240.field_1333) {
                    totalRayDistance = (float)((double)totalRayDistance + lastHitPos.method_1022(playerPos));
                    RaycastRenderer.addSoundBounceRay(newRayStart, newRayEnd, class_124.field_1061.method_532());
                } else {
                    class_243 newRayHitPos = newRayHit.method_17784();
                    RaycastRenderer.addSoundBounceRay(newRayStart, newRayHitPos, class_124.field_1078.method_532());
                    double newRayLength = lastHitPos.method_1022(newRayHitPos);
                    int n = j;
                    bounceReflectivityRatio[n] = bounceReflectivityRatio[n] + blockReflectivity;
                    totalRayDistance = (float)((double)totalRayDistance + newRayLength);
                    lastHitPos = newRayHitPos;
                    lastHitNormal = new class_243(newRayHit.method_17780().method_23955());
                    lastRayDir = newRayDir;
                    lastHitBlock = newRayHit.method_17777();
                    class_243 sharedAirspaceVector = SoundPhysics.getSharedAirspace(newRayHit, playerPos);
                    if (sharedAirspaceVector != null) {
                        audioDirection.addSharedAirspace(sharedAirspaceVector, totalRayDistance);
                    }
                }
                float reflectionDelay = (float)Math.max((double)totalRayDistance, 0.0) * 0.12f * blockReflectivity;
                float cross0 = 1.0f - class_3532.method_15363((float)Math.abs(reflectionDelay - 0.0f), (float)0.0f, (float)1.0f);
                float cross1 = 1.0f - class_3532.method_15363((float)Math.abs(reflectionDelay - 1.0f), (float)0.0f, (float)1.0f);
                float cross2 = 1.0f - class_3532.method_15363((float)Math.abs(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                float cross3 = class_3532.method_15363((float)(reflectionDelay - 2.0f), (float)0.0f, (float)1.0f);
                sendGain0 += cross0 * energyTowardsPlayer * 6.4f * rcpTotalRays;
                sendGain1 += cross1 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                sendGain2 += cross2 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                sendGain3 += cross3 * energyTowardsPlayer * 12.8f * rcpTotalRays;
                if (newRayHit.method_17783() == class_239.class_240.field_1333) continue block0;
            }
        }
        for (i = 0; i < bounceReflectivityRatio.length; ++i) {
            bounceReflectivityRatio[i] = bounceReflectivityRatio[i] / (float)numRays;
            Loggers.logEnvironment("Bounce reflectivity {}: {}", i, Float.valueOf(bounceReflectivityRatio[i]));
        }
        class_243 newSoundPos = audioDirection.evaluateSoundPosition(soundPos, playerPos);
        if (newSoundPos != null) {
            SoundPhysics.setSoundPos(sourceID, newSoundPos);
        }
        float sharedAirspace = (float)audioDirection.getSharedAirspaces() * 64.0f * rcpTotalRays;
        Loggers.logEnvironment("Shared airspace: {} ({})", Float.valueOf(sharedAirspace), audioDirection.getSharedAirspaces());
        float sharedAirspaceWeight0 = class_3532.method_15363((float)(sharedAirspace / 20.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight1 = class_3532.method_15363((float)(sharedAirspace / 15.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight2 = class_3532.method_15363((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
        float sharedAirspaceWeight3 = class_3532.method_15363((float)(sharedAirspace / 10.0f), (float)0.0f, (float)1.0f);
        sendCutoff0 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight0) + sharedAirspaceWeight0;
        sendCutoff1 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight1) + sharedAirspaceWeight1;
        sendCutoff2 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight2) + sharedAirspaceWeight2;
        sendCutoff3 = (float)Math.exp(-occlusionAccumulation * (double)absorptionCoeff * 1.0) * (1.0f - sharedAirspaceWeight3) + sharedAirspaceWeight3;
        float averageSharedAirspace = (sharedAirspaceWeight0 + sharedAirspaceWeight1 + sharedAirspaceWeight2 + sharedAirspaceWeight3) * 0.25f;
        directCutoff = Math.max((float)Math.pow(averageSharedAirspace, 0.5) * 0.2f, directCutoff);
        directGain = auxOnly ? 0.0f : (float)Math.pow(directCutoff, 0.1);
        sendGain1 *= bounceReflectivityRatio[1];
        if (bounceReflectivityRatio.length > 2) {
            sendGain2 *= (float)Math.pow(bounceReflectivityRatio[2], 3.0);
        }
        if (bounceReflectivityRatio.length > 3) {
            sendGain3 *= (float)Math.pow(bounceReflectivityRatio[3], 4.0);
        }
        sendGain0 = class_3532.method_15363((float)sendGain0, (float)0.0f, (float)1.0f);
        sendGain1 = class_3532.method_15363((float)sendGain1, (float)0.0f, (float)1.0f);
        sendGain2 = class_3532.method_15363((float)(sendGain2 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
        sendGain3 = class_3532.method_15363((float)(sendGain3 * 1.05f - 0.05f), (float)0.0f, (float)1.0f);
        sendGain0 *= (float)Math.pow(sendCutoff0, 0.1);
        sendGain1 *= (float)Math.pow(sendCutoff1, 0.1);
        sendGain2 *= (float)Math.pow(sendCutoff2, 0.1);
        sendGain3 *= (float)Math.pow(sendCutoff3, 0.1);
        float soundDistance = (float)playerPos.method_1022(soundPos);
        float maxSoundDistance = AL10.alGetSourcef((int)sourceID, (int)4131);
        float sendGainMultiplier = 1.0f - Math.min(soundDistance / (maxSoundDistance * SoundPhysicsMod.CONFIG.reverbDistance.get().floatValue()), 1.0f);
        sendGain0 = sendGainMultiplier * sendGain0;
        sendGain1 = sendGainMultiplier * sendGain1;
        sendGain2 = sendGainMultiplier * sendGain2;
        sendGain3 = sendGainMultiplier * sendGain3;
        Loggers.logEnvironment("Final environment settings: {}, {}, {}, {}", Float.valueOf(sendGain0), Float.valueOf(sendGain1), Float.valueOf(sendGain2), Float.valueOf(sendGain3));
        assert (SoundPhysics.minecraft.field_1724 != null);
        if (SoundPhysics.minecraft.field_1724.method_5869()) {
            sendCutoff0 *= 0.4f;
            sendCutoff1 *= 0.4f;
            sendCutoff2 *= 0.4f;
            sendCutoff3 *= 0.4f;
        }
        SoundPhysics.setEnvironment(sourceID, sendGain0, sendGain1, sendGain2, sendGain3, sendCutoff0, sendCutoff1, sendCutoff2, sendCutoff3, directCutoff, directGain);
        return newSoundPos;
    }

    public static boolean isVoicechatSound(String sound) {
        return VOICECHAT_PATTERN.matcher(sound).matches();
    }

    public static boolean isAmbientSound(String sound) {
        return AMBIENT_PATTERN.matcher(sound).matches();
    }

    private static float getBlockReflectivity(class_2338 blockPos) {
        ClientLevelProxy levelProxy = SoundPhysics.getLevelProxy();
        if (levelProxy == null) {
            return SoundPhysicsMod.CONFIG.defaultBlockReflectivity.get().floatValue();
        }
        class_2680 blockState = levelProxy.method_8320(blockPos);
        return SoundPhysicsMod.REFLECTIVITY_CONFIG.getBlockDefinitionValue(blockState);
    }

    private static class_243 reflect(class_243 dir, class_243 normal) {
        double dot = dir.method_1026(normal) * 2.0;
        double x = dir.field_1352 - dot * normal.field_1352;
        double y = dir.field_1351 - dot * normal.field_1351;
        double z = dir.field_1350 - dot * normal.field_1350;
        return new class_243(x, y, z);
    }

    private static double calculateOcclusion(class_243 soundPos, class_243 playerPos, class_3419 category, String sound) {
        if (SoundPhysicsMod.CONFIG.strictOcclusion.get().booleanValue()) {
            return Math.min(SoundPhysics.runOcclusion(soundPos, playerPos), (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue());
        }
        boolean isBlock = category == class_3419.field_15245 || BLOCK_PATTERN.matcher(sound).matches();
        double variationFactor = SoundPhysicsMod.CONFIG.occlusionVariation.get().floatValue();
        if (isBlock) {
            variationFactor = Math.max(variationFactor, 0.49);
        }
        double occlusionAccMin = Double.MAX_VALUE;
        occlusionAccMin = Math.min(occlusionAccMin, SoundPhysics.runOcclusion(soundPos, playerPos));
        if (variationFactor > 0.0) {
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        class_243 offset = new class_243((double)x, (double)y, (double)z).method_1021(variationFactor);
                        occlusionAccMin = Math.min(occlusionAccMin, SoundPhysics.runOcclusion(soundPos.method_1019(offset), playerPos.method_1019(offset)));
                    }
                }
            }
        }
        return Math.min(occlusionAccMin, (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue());
    }

    private static double runOcclusion(class_243 soundPos, class_243 playerPos) {
        ClientLevelProxy levelProxy = SoundPhysics.getLevelProxy();
        if (levelProxy == null) {
            return 0.0;
        }
        double occlusionAccumulation = 0.0;
        class_243 rayOrigin = soundPos;
        class_2338 lastBlockPos = class_2338.method_49638((class_2374)soundPos);
        for (int i = 0; i < SoundPhysicsMod.CONFIG.maxOcclusionRays.get(); ++i) {
            class_3965 rayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), rayOrigin, playerPos, lastBlockPos);
            lastBlockPos = rayHit.method_17777();
            if (rayHit.method_17783() == class_239.class_240.field_1333) {
                RaycastRenderer.addOcclusionRay(rayOrigin, playerPos.method_1031(0.0, -0.1, 0.0), class_3532.method_15369((float)(0.33333334f * (1.0f - Math.min(1.0f, (float)occlusionAccumulation / 12.0f))), (float)1.0f, (float)1.0f));
                break;
            }
            RaycastRenderer.addOcclusionRay(rayOrigin, rayHit.method_17784(), class_3532.method_15369((float)(0.33333334f * (1.0f - Math.min(1.0f, (float)occlusionAccumulation / 12.0f))), (float)1.0f, (float)1.0f));
            class_2338 blockHitPos = rayHit.method_17777();
            rayOrigin = rayHit.method_17784();
            class_2680 blockHit = levelProxy.method_8320(blockHitPos);
            float blockOcclusion = SoundPhysicsMod.OCCLUSION_CONFIG.getBlockDefinitionValue(blockHit);
            class_243 dirVec = rayOrigin.method_1023((double)blockHitPos.method_10263() + 0.5, (double)blockHitPos.method_10264() + 0.5, (double)blockHitPos.method_10260() + 0.5);
            class_2350 sideHit = class_2350.method_10142((double)dirVec.field_1352, (double)dirVec.field_1351, (double)dirVec.field_1350);
            if (!blockHit.method_26206((class_1922)levelProxy, rayHit.method_17777(), sideHit)) {
                blockOcclusion *= SoundPhysicsMod.CONFIG.nonFullBlockOcclusionFactor.get().floatValue();
            }
            Loggers.logOcclusion("{} \t{},{},{}", blockHit.method_26204().method_63499(), rayOrigin.field_1352, rayOrigin.field_1351, rayOrigin.field_1350);
            occlusionAccumulation += (double)blockOcclusion;
            if (!(occlusionAccumulation > (double)SoundPhysicsMod.CONFIG.maxOcclusion.get().floatValue())) continue;
            Loggers.logOcclusion("Max occlusion reached after {} steps", i + 1);
            break;
        }
        return occlusionAccumulation;
    }

    private static ClientLevelProxy getLevelProxy() {
        return LevelAccessUtils.getClientLevelProxy(minecraft);
    }

    @Nullable
    private static class_243 getSharedAirspace(class_3965 hit, class_243 listenerPosition) {
        Vector3f hitNormal = hit.method_17780().method_23955();
        class_243 rayStart = new class_243(hit.method_17784().field_1352 + (double)hitNormal.x() * 0.001, hit.method_17784().field_1351 + (double)hitNormal.y() * 0.001, hit.method_17784().field_1350 + (double)hitNormal.z() * 0.001);
        return SoundPhysics.getSharedAirspace(rayStart, listenerPosition);
    }

    @Nullable
    private static class_243 getSharedAirspace(class_243 soundPosition, class_243 listenerPosition) {
        class_3965 finalRayHit = RaycastUtils.rayCast(SoundPhysics.getLevelProxy(), soundPosition, listenerPosition, null);
        if (finalRayHit.method_17783() == class_239.class_240.field_1333) {
            RaycastRenderer.addSoundBounceRay(soundPosition, listenerPosition.method_1031(0.0, -0.1, 0.0), class_124.field_1068.method_532());
            return soundPosition.method_1020(listenerPosition);
        }
        return null;
    }

    public static void setDefaultEnvironment(int sourceID) {
        SoundPhysics.setDefaultEnvironment(sourceID, false);
    }

    public static void setDefaultEnvironment(int sourceID, boolean auxOnly) {
        SoundPhysics.setEnvironment(sourceID, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, auxOnly ? 0.0f : 1.0f);
    }

    public static void setEnvironment(int sourceID, float sendGain0, float sendGain1, float sendGain2, float sendGain3, float sendCutoff0, float sendCutoff1, float sendCutoff2, float sendCutoff3, float directCutoff, float directGain) {
        if (!SoundPhysicsMod.CONFIG.enabled.get().booleanValue()) {
            return;
        }
        if (maxAuxSends >= 4) {
            EXTEfx.alFilterf((int)sendFilter0, (int)1, (float)sendGain0);
            EXTEfx.alFilterf((int)sendFilter0, (int)2, (float)sendCutoff0);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot0, (int)3, (int)sendFilter0);
            Loggers.logALError("Set environment filter0:");
        }
        if (maxAuxSends >= 3) {
            EXTEfx.alFilterf((int)sendFilter1, (int)1, (float)sendGain1);
            EXTEfx.alFilterf((int)sendFilter1, (int)2, (float)sendCutoff1);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot1, (int)2, (int)sendFilter1);
            Loggers.logALError("Set environment filter1:");
        }
        if (maxAuxSends >= 2) {
            EXTEfx.alFilterf((int)sendFilter2, (int)1, (float)sendGain2);
            EXTEfx.alFilterf((int)sendFilter2, (int)2, (float)sendCutoff2);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot2, (int)1, (int)sendFilter2);
            Loggers.logALError("Set environment filter2:");
        }
        if (maxAuxSends >= 1) {
            EXTEfx.alFilterf((int)sendFilter3, (int)1, (float)sendGain3);
            EXTEfx.alFilterf((int)sendFilter3, (int)2, (float)sendCutoff3);
            AL11.alSource3i((int)sourceID, (int)131078, (int)auxFXSlot3, (int)0, (int)sendFilter3);
            Loggers.logALError("Set environment filter3:");
        }
        EXTEfx.alFilterf((int)directFilter0, (int)1, (float)directGain);
        EXTEfx.alFilterf((int)directFilter0, (int)2, (float)directCutoff);
        AL11.alSourcei((int)sourceID, (int)131077, (int)directFilter0);
        Loggers.logALError("Set environment directFilter0:");
        AL11.alSourcef((int)sourceID, (int)131079, (float)SoundPhysicsMod.CONFIG.airAbsorption.get().floatValue());
        Loggers.logALError("Set environment airAbsorption:");
    }

    private static void setSoundPos(int sourceID, class_243 pos) {
        AL11.alSource3f((int)sourceID, (int)4100, (float)((float)pos.field_1352), (float)((float)pos.field_1351), (float)((float)pos.field_1350));
    }

    protected static void setReverbParams(ReverbParams r, int auxFXSlot, int reverbSlot) {
        EXTEfx.alEffectf((int)reverbSlot, (int)1, (float)r.density);
        Loggers.logALError("Error while assigning reverb density: " + r.density);
        EXTEfx.alEffectf((int)reverbSlot, (int)2, (float)r.diffusion);
        Loggers.logALError("Error while assigning reverb diffusion: " + r.diffusion);
        EXTEfx.alEffectf((int)reverbSlot, (int)3, (float)r.gain);
        Loggers.logALError("Error while assigning reverb gain: " + r.gain);
        EXTEfx.alEffectf((int)reverbSlot, (int)4, (float)r.gainHF);
        Loggers.logALError("Error while assigning reverb gainHF: " + r.gainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)6, (float)r.decayTime);
        Loggers.logALError("Error while assigning reverb decayTime: " + r.decayTime);
        EXTEfx.alEffectf((int)reverbSlot, (int)7, (float)r.decayHFRatio);
        Loggers.logALError("Error while assigning reverb decayHFRatio: " + r.decayHFRatio);
        EXTEfx.alEffectf((int)reverbSlot, (int)9, (float)r.reflectionsGain);
        Loggers.logALError("Error while assigning reverb reflectionsGain: " + r.reflectionsGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)12, (float)r.lateReverbGain);
        Loggers.logALError("Error while assigning reverb lateReverbGain: " + r.lateReverbGain);
        EXTEfx.alEffectf((int)reverbSlot, (int)13, (float)r.lateReverbDelay);
        Loggers.logALError("Error while assigning reverb lateReverbDelay: " + r.lateReverbDelay);
        EXTEfx.alEffectf((int)reverbSlot, (int)19, (float)r.airAbsorptionGainHF);
        Loggers.logALError("Error while assigning reverb airAbsorptionGainHF: " + r.airAbsorptionGainHF);
        EXTEfx.alEffectf((int)reverbSlot, (int)22, (float)r.roomRolloffFactor);
        Loggers.logALError("Error while assigning reverb roomRolloffFactor: " + r.roomRolloffFactor);
        EXTEfx.alAuxiliaryEffectSloti((int)auxFXSlot, (int)1, (int)reverbSlot);
    }
}

