/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.orthocamera.client;

import com.dimaskama.orthocamera.client.config.ModConfig;
import com.dimaskama.orthocamera.client.config.ModConfigScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class OrthoCamera
implements ClientModInitializer {
    public static final String MOD_ID = "orthocamera";
    public static final Logger LOGGER = LogManager.getLogger((String)"OrthoCamera");
    public static final ModConfig CONFIG = new ModConfig("config/orthocamera.json", "assets/orthocamera/default_config.json");
    private static final class_304 TOGGLE_KEY = OrthoCamera.createKeybinding("toggle", 324);
    private static final class_304 SCALE_INCREASE_KEY = OrthoCamera.createKeybinding("scale_increase", 333);
    private static final class_304 SCALE_DECREASE_KEY = OrthoCamera.createKeybinding("scale_decrease", 334);
    private static final class_304 OPEN_OPTIONS_KEY = OrthoCamera.createKeybinding("options", -1);
    private static final class_304 FIX_CAMERA_KEY = OrthoCamera.createKeybinding("fix_camera", 332);
    private static final class_304 FIXED_CAMERA_ROTATE_UP_KEY = OrthoCamera.createKeybinding("fixed_camera_rotate_up", -1);
    private static final class_304 FIXED_CAMERA_ROTATE_DOWN_KEY = OrthoCamera.createKeybinding("fixed_camera_rotate_down", -1);
    private static final class_304 FIXED_CAMERA_ROTATE_LEFT_KEY = OrthoCamera.createKeybinding("fixed_camera_rotate_left", -1);
    private static final class_304 FIXED_CAMERA_ROTATE_RIGHT_KEY = OrthoCamera.createKeybinding("fixed_camera_rotate_right", -1);
    private static final class_2561 ENABLED_TEXT = class_2561.method_43471((String)"orthocamera.enabled");
    private static final class_2561 DISABLED_TEXT = class_2561.method_43471((String)"orthocamera.disabled");
    private static final class_2561 FIXED_TEXT = class_2561.method_43471((String)"orthocamera.fixed");
    private static final class_2561 UNFIXED_TEXT = class_2561.method_43471((String)"orthocamera.unfixed");
    private static final float SCALE_MUL_INTERVAL = 1.1f;

    public void onInitializeClient() {
        CONFIG.loadOrCreate();
        OrthoCamera.CONFIG.enabled &= OrthoCamera.CONFIG.save_enabled_state;
        KeyBindingHelper.registerKeyBinding((class_304)TOGGLE_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)SCALE_INCREASE_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)SCALE_DECREASE_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)OPEN_OPTIONS_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FIX_CAMERA_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FIXED_CAMERA_ROTATE_UP_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FIXED_CAMERA_ROTATE_DOWN_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FIXED_CAMERA_ROTATE_LEFT_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FIXED_CAMERA_ROTATE_RIGHT_KEY);
        ClientTickEvents.START_CLIENT_TICK.register(c -> CONFIG.tick());
        ClientTickEvents.END_CLIENT_TICK.register(this::handleInput);
        ClientLifecycleEvents.CLIENT_STOPPING.register(this::onClientStopping);
    }

    private void handleInput(class_310 client) {
        boolean messageSent = false;
        while (TOGGLE_KEY.method_1436()) {
            CONFIG.toggle();
            client.method_44714().method_44736(OrthoCamera.CONFIG.enabled ? ENABLED_TEXT : DISABLED_TEXT, true);
            messageSent = true;
        }
        boolean on = OrthoCamera.CONFIG.enabled;
        boolean scaleChanged = false;
        while (SCALE_INCREASE_KEY.method_1436()) {
            if (!on) continue;
            CONFIG.setScaleX(OrthoCamera.CONFIG.scale_x * 1.1f);
            CONFIG.setScaleY(OrthoCamera.CONFIG.scale_y * 1.1f);
            CONFIG.setDirty(true);
            scaleChanged = true;
        }
        while (SCALE_DECREASE_KEY.method_1436()) {
            if (!on) continue;
            CONFIG.setScaleX(OrthoCamera.CONFIG.scale_x / 1.1f);
            CONFIG.setScaleY(OrthoCamera.CONFIG.scale_y / 1.1f);
            CONFIG.setDirty(true);
            scaleChanged = true;
        }
        if (scaleChanged && !messageSent) {
            client.method_44714().method_44736((class_2561)class_2561.method_43469((String)"orthocamera.scale", (Object[])new Object[]{String.format("%.1f", Float.valueOf(OrthoCamera.CONFIG.scale_x)), String.format("%.1f", Float.valueOf(OrthoCamera.CONFIG.scale_y))}), true);
            messageSent = true;
        }
        boolean fixPressed = false;
        while (FIX_CAMERA_KEY.method_1436()) {
            fixPressed = true;
            CONFIG.setFixed(!OrthoCamera.CONFIG.fixed);
        }
        if (!messageSent && fixPressed) {
            client.method_44714().method_44736(OrthoCamera.CONFIG.fixed ? FIXED_TEXT : UNFIXED_TEXT, true);
        }
        if (FIXED_CAMERA_ROTATE_LEFT_KEY.method_1434()) {
            CONFIG.setFixedYaw(OrthoCamera.CONFIG.fixed_yaw + OrthoCamera.CONFIG.fixed_rotate_speed_y);
        }
        if (FIXED_CAMERA_ROTATE_RIGHT_KEY.method_1434()) {
            CONFIG.setFixedYaw(OrthoCamera.CONFIG.fixed_yaw - OrthoCamera.CONFIG.fixed_rotate_speed_y);
        }
        if (FIXED_CAMERA_ROTATE_UP_KEY.method_1434()) {
            CONFIG.setFixedPitch(OrthoCamera.CONFIG.fixed_pitch + OrthoCamera.CONFIG.fixed_rotate_speed_x);
        }
        if (FIXED_CAMERA_ROTATE_DOWN_KEY.method_1434()) {
            CONFIG.setFixedPitch(OrthoCamera.CONFIG.fixed_pitch - OrthoCamera.CONFIG.fixed_rotate_speed_x);
        }
        boolean openScreen = false;
        while (OPEN_OPTIONS_KEY.method_1436()) {
            openScreen = true;
        }
        if (openScreen) {
            client.method_1507((class_437)new ModConfigScreen(null));
        }
    }

    private void onClientStopping(class_310 client) {
        if (CONFIG.isDirty()) {
            CONFIG.save();
        }
    }

    public static boolean isEnabled() {
        return OrthoCamera.CONFIG.enabled;
    }

    public static Matrix4f createOrthoMatrix(float delta, float minScale) {
        class_310 client = class_310.method_1551();
        float width = Math.max(minScale, CONFIG.getScaleX(delta) * (float)client.method_22683().method_4489() / (float)client.method_22683().method_4506());
        float height = Math.max(minScale, CONFIG.getScaleY(delta));
        return new Matrix4f().setOrtho(-width, width, -height, height, OrthoCamera.CONFIG.min_distance, OrthoCamera.CONFIG.max_distance);
    }

    private static class_304 createKeybinding(String name, int key) {
        return new class_304("orthocamera.key." + name, class_3675.class_307.field_1668, key, MOD_ID);
    }
}

