/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.orthocamera.client.config;

import com.dimaskama.orthocamera.client.config.JsonConfig;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5498;

public class ModConfig
extends JsonConfig {
    public static final float MIN_SCALE = 0.01f;
    public static final float MAX_SCALE = 10000.0f;
    private transient boolean dirty;
    private transient float prevScaleX;
    private transient float prevScaleY;
    private transient float prevFixedYaw;
    private transient float prevFixedPitch;
    private transient class_5498 prevPerspective;
    public boolean enabled = false;
    public boolean save_enabled_state;
    public float scale_x = 3.0f;
    public float scale_y = 3.0f;
    public float min_distance = -1000.0f;
    public float max_distance = 1000.0f;
    public boolean fixed = false;
    public float fixed_yaw = 0.0f;
    public float fixed_pitch = 0.0f;
    public float fixed_rotate_speed_y = 3.0f;
    public float fixed_rotate_speed_x = 3.0f;
    public boolean auto_third_person = true;

    public ModConfig(String path, String defaultPath) {
        super(path, defaultPath);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void tick() {
        this.prevScaleX = this.scale_x;
        this.prevScaleY = this.scale_y;
        this.prevFixedYaw = this.fixed_yaw;
        this.prevFixedPitch = this.fixed_pitch;
    }

    public float getScaleX(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevScaleX, (float)this.scale_x);
    }

    public float getScaleY(float delta) {
        return class_3532.method_16439((float)delta, (float)this.prevScaleY, (float)this.scale_y);
    }

    public float getFixedYaw(float delta) {
        return class_3532.method_17821((float)delta, (float)this.prevFixedYaw, (float)this.fixed_yaw);
    }

    public float getFixedPitch(float delta) {
        return class_3532.method_17821((float)delta, (float)this.prevFixedPitch, (float)this.fixed_pitch);
    }

    public void setScaleX(float scale) {
        if ((scale = class_3532.method_15363((float)scale, (float)0.01f, (float)10000.0f)) != this.scale_x) {
            this.scale_x = scale;
            this.setDirty(true);
        }
    }

    public void setScaleY(float scale) {
        if ((scale = class_3532.method_15363((float)scale, (float)0.01f, (float)10000.0f)) != this.scale_y) {
            this.scale_y = scale;
            this.setDirty(true);
        }
    }

    public void setFixedYaw(float yaw) {
        if (yaw < 0.0f) {
            yaw = 360.0f + yaw;
        }
        if ((yaw %= 360.0f) != this.fixed_yaw) {
            this.fixed_yaw = yaw;
            this.setDirty(true);
        }
    }

    public void setFixedPitch(float pitch) {
        if ((pitch = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f)) != this.fixed_pitch) {
            this.fixed_pitch = pitch;
            this.setDirty(true);
        }
    }

    public void setFixed(boolean fixed) {
        class_1297 entity;
        this.fixed = fixed;
        if (fixed && (entity = class_310.method_1551().method_1560()) != null) {
            this.setFixedYaw(entity.method_36454() + 180.0f);
            this.prevFixedYaw = this.fixed_yaw;
            this.setFixedPitch(entity.method_36455());
            this.prevFixedPitch = this.fixed_pitch;
        }
        this.setDirty(true);
    }

    public void toggle() {
        boolean bl = this.enabled = !this.enabled;
        if (this.auto_third_person) {
            class_310 client = class_310.method_1551();
            if (this.enabled) {
                this.prevPerspective = client.field_1690.method_31044();
                client.field_1690.method_31043(class_5498.field_26665);
            } else if (this.prevPerspective != null) {
                client.field_1690.method_31043(this.prevPerspective);
            }
        }
        this.setDirty(true);
    }
}

