/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.orthocamera.mixin;

import com.dimaskama.orthocamera.client.OrthoCamera;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_10366;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={class_757.class})
abstract class GameRendererMixin {
    GameRendererMixin() {
    }

    @ModifyArg(method={"renderWorld"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;setupFrustum(Lnet/minecraft/util/math/Vec3d;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"), index=2)
    private Matrix4f orthoFrustumProjMat(Matrix4f projMat) {
        if (OrthoCamera.isEnabled()) {
            return OrthoCamera.createOrthoMatrix(1.0f, 20.0f);
        }
        return projMat;
    }

    @ModifyArg(method={"renderWorld"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;render(Lnet/minecraft/client/util/ObjectAllocator;Lnet/minecraft/client/render/RenderTickCounter;ZLnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/GameRenderer;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;)V"), index=6)
    private Matrix4f orthoProjMat(Matrix4f projMat, @Local(argsOnly=true) class_9779 tickCounter) {
        if (OrthoCamera.isEnabled()) {
            Matrix4f mat = OrthoCamera.createOrthoMatrix(tickCounter.method_60637(false), 0.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)mat, (class_10366)class_10366.field_54954);
            return mat;
        }
        return projMat;
    }

    @ModifyExpressionValue(method={"renderWorld"}, at={@At(value="INVOKE", target="Lorg/joml/Quaternionf;conjugate(Lorg/joml/Quaternionf;)Lorg/joml/Quaternionf;")})
    private Quaternionf modifyRotation(Quaternionf original, @Local(argsOnly=true) class_9779 tickCounter) {
        if (OrthoCamera.isEnabled() && OrthoCamera.CONFIG.fixed) {
            float delta = tickCounter.method_60637(false);
            return original.rotationXYZ(OrthoCamera.CONFIG.getFixedPitch(delta) * ((float)Math.PI / 180), OrthoCamera.CONFIG.getFixedYaw(delta) * ((float)Math.PI / 180) - (float)Math.PI, 0.0f);
        }
        return original;
    }
}

