/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import com.google.common.hash.Hashing;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.BobbyConfig;
import de.johni0702.minecraft.bobby.FakeChunk;
import de.johni0702.minecraft.bobby.ext.ChunkLightProviderExt;
import de.johni0702.minecraft.bobby.ext.LightingProviderExt;
import de.johni0702.minecraft.bobby.ext.WorldChunkExt;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2804;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2902;
import net.minecraft.class_3568;
import net.minecraft.class_4076;
import net.minecraft.class_5455;
import net.minecraft.class_6606;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7522;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_2804 COMPLETELY_DARK = new class_2804();
    private static final class_2804 COMPLETELY_LIT = new class_2804();
    private static final Codec<class_2841<class_2680>> BLOCK_CODEC;

    public static class_2487 serialize(class_2818 chunk, class_3568 lightingProvider) {
        class_2499 blockEntitiesTag;
        class_5455 registryManager = chunk.method_12200().method_30349();
        class_2378 biomeRegistry = registryManager.method_30530(class_7924.field_41236);
        Codec biomeCodec = class_2841.method_44347((class_2359)biomeRegistry.method_40295(), (Codec)biomeRegistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)((class_6880)biomeRegistry.method_10223(class_1972.field_9451.method_29177()).orElseThrow()));
        class_1923 chunkPos = chunk.method_12004();
        class_2487 level = new class_2487();
        level.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
        level.method_10569("xPos", chunkPos.field_9181);
        level.method_10569("yPos", chunk.method_32891());
        level.method_10569("zPos", chunkPos.field_9180);
        level.method_10556("isLightOn", true);
        level.method_10582("Status", "full");
        class_2826[] chunkSections = chunk.method_12006();
        class_2499 sectionsTag = new class_2499();
        for (int y = lightingProvider.method_31929(); y < lightingProvider.method_31930(); ++y) {
            class_2804 skyLight;
            class_2804 blockLight;
            class_2826 chunkSection;
            boolean empty = true;
            class_2487 sectionTag = new class_2487();
            sectionTag.method_10567("Y", (byte)y);
            int i = chunk.method_31603(y);
            class_2826 class_28262 = chunkSection = i >= 0 && i < chunkSections.length ? chunkSections[i] : null;
            if (chunkSection != null) {
                sectionTag.method_10566("block_states", (class_2520)BLOCK_CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_12265()).getOrThrow());
                sectionTag.method_10566("biomes", (class_2520)biomeCodec.encodeStart((DynamicOps)class_2509.field_11560, (Object)chunkSection.method_38294()).getOrThrow());
                empty = false;
            }
            if (chunk instanceof FakeChunk) {
                FakeChunk fakeChunk = (FakeChunk)chunk;
                v1 = fakeChunk.blockLight[i + 1];
            } else {
                v1 = blockLight = lightingProvider.method_15562(class_1944.field_9282).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y));
            }
            if (blockLight != null && !blockLight.method_12146()) {
                sectionTag.method_10570("BlockLight", blockLight.method_12137());
                empty = false;
            }
            if (chunk instanceof FakeChunk) {
                FakeChunk fakeChunk = (FakeChunk)chunk;
                v2 = fakeChunk.skyLight[i + 1];
            } else {
                v2 = skyLight = lightingProvider.method_15562(class_1944.field_9284).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y));
            }
            if (skyLight != null && !skyLight.method_12146()) {
                sectionTag.method_10570("SkyLight", skyLight.method_12137());
                empty = false;
            }
            if (empty) continue;
            sectionsTag.add((Object)sectionTag);
        }
        level.method_10566("sections", (class_2520)sectionsTag);
        if (chunk instanceof FakeChunk) {
            FakeChunk fakeChunk = (FakeChunk)chunk;
            blockEntitiesTag = fakeChunk.serializedBlockEntities;
        } else {
            blockEntitiesTag = new class_2499();
            for (class_2338 pos : chunk.method_12021()) {
                class_2487 blockEntityTag = chunk.method_20598(pos, (class_7225.class_7874)registryManager);
                if (blockEntityTag == null) continue;
                blockEntitiesTag.add((Object)blockEntityTag);
            }
        }
        level.method_10566("block_entities", (class_2520)blockEntitiesTag);
        class_2487 hightmapsTag = new class_2487();
        for (Map.Entry entry : chunk.method_12011()) {
            if (!chunk.method_12009().method_12160().contains(entry.getKey())) continue;
            hightmapsTag.method_10566(((class_2902.class_2903)entry.getKey()).method_12605(), (class_2520)new class_2501(((class_2902)entry.getValue()).method_12598()));
        }
        level.method_10566("Heightmaps", (class_2520)hightmapsTag);
        return level;
    }

    public static Pair<class_2818, Supplier<class_2818>> deserialize(class_1923 pos, class_2487 level, class_1937 world) {
        int y;
        BobbyConfig config = Bobby.getInstance().getConfig();
        class_1923 chunkPos = new class_1923(level.method_10550("xPos"), level.method_10550("zPos"));
        if (!Objects.equals(pos, chunkPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)pos, (Object)pos, (Object)chunkPos);
        }
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        Codec biomeCodec = class_2841.method_44343((class_2359)biomeRegistry.method_40295(), (Codec)biomeRegistry.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)((class_6880)biomeRegistry.method_10223(class_1972.field_9451.method_29177()).orElseThrow()));
        class_2499 sectionsTag = level.method_10554("sections", 10);
        class_2826[] chunkSections = new class_2826[world.method_32890()];
        Object[] blockLight = new class_2804[chunkSections.length + 2];
        class_2804[] skyLight = new class_2804[chunkSections.length + 2];
        Arrays.fill(blockLight, COMPLETELY_DARK);
        for (int i = 0; i < sectionsTag.size(); ++i) {
            class_2487 sectionTag = sectionsTag.method_10602(i);
            y = sectionTag.method_10571("Y");
            int yIndex = world.method_31603(y);
            if (yIndex < -1 || yIndex > chunkSections.length) continue;
            if (yIndex >= 0 && yIndex < chunkSections.length) {
                class_2841 blocks = sectionTag.method_10573("block_states", 10) ? (class_2841)BLOCK_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)sectionTag.method_10562("block_states")).promotePartial(errorMessage -> ChunkSerializer.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow() : new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569);
                class_2841 biomes = sectionTag.method_10573("biomes", 10) ? (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)sectionTag.method_10562("biomes")).promotePartial(errorMessage -> ChunkSerializer.logRecoverableError(chunkPos, y, errorMessage)).getOrThrow() : new class_2841(biomeRegistry.method_40295(), (Object)((class_6880)biomeRegistry.method_10223(class_1972.field_9451.method_29177()).orElseThrow()), class_2841.class_6563.field_34570);
                class_2826 chunkSection = new class_2826(blocks, (class_7522)biomes);
                chunkSection.method_12253();
                if (!chunkSection.method_38292()) {
                    chunkSections[yIndex] = chunkSection;
                }
            }
            if (sectionTag.method_10573("BlockLight", 7)) {
                blockLight[yIndex + 1] = new class_2804(sectionTag.method_10547("BlockLight"));
            }
            if (!sectionTag.method_10573("SkyLight", 7)) continue;
            skyLight[yIndex + 1] = new class_2804(sectionTag.method_10547("SkyLight"));
        }
        class_2804 fullSectionAbove = null;
        class_2804 inferredSection = COMPLETELY_LIT;
        for (y = skyLight.length - 1; y >= 0; --y) {
            class_2804 section = skyLight[y];
            if (section != null) {
                inferredSection = null;
                fullSectionAbove = section;
                continue;
            }
            if (inferredSection == null) {
                assert (fullSectionAbove != null);
                inferredSection = ChunkSerializer.floodSkylightFromAbove(fullSectionAbove);
            }
            skyLight[y] = inferredSection;
        }
        FakeChunk chunk = new FakeChunk(world, pos, chunkSections);
        class_2487 hightmapsTag = level.method_10562("Heightmaps");
        EnumSet<class_2902.class_2903> missingHightmapTypes = EnumSet.noneOf(class_2902.class_2903.class);
        for (class_2902.class_2903 type : chunk.method_12009().method_12160()) {
            String key = type.method_12605();
            if (hightmapsTag.method_10573(key, 12)) {
                chunk.method_12037(type, hightmapsTag.method_10565(key));
                continue;
            }
            missingHightmapTypes.add(type);
        }
        class_2902.method_16684((class_2791)chunk, missingHightmapTypes);
        if (!config.isNoBlockEntities()) {
            class_2499 blockEntitiesTag = level.method_10554("block_entities", 10);
            for (int i = 0; i < blockEntitiesTag.size(); ++i) {
                chunk.method_12042(blockEntitiesTag.method_10602(i));
            }
        }
        return Pair.of((Object)((Object)chunk), ChunkSerializer.loadChunk(chunk, (class_2804[])blockLight, skyLight, config));
    }

    private static Supplier<class_2818> loadChunk(FakeChunk chunk, class_2804[] blockLight, class_2804[] skyLight, BobbyConfig config) {
        return () -> {
            class_1923 pos = chunk.method_12004();
            class_1937 world = chunk.method_12200();
            class_2826[] chunkSections = chunk.method_12006();
            boolean hasSkyLight = world.method_8597().comp_642();
            class_2802 chunkManager = world.method_8398();
            class_3568 lightingProvider = chunkManager.method_12130();
            LightingProviderExt lightingProviderExt = LightingProviderExt.get(lightingProvider);
            ChunkLightProviderExt blockLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9282));
            ChunkLightProviderExt skyLightProvider = ChunkLightProviderExt.get(lightingProvider.method_15562(class_1944.field_9284));
            lightingProviderExt.bobby_enabledColumn(class_4076.method_51687((int)pos.field_9181, (int)pos.field_9180));
            for (int i = -1; i < chunkSections.length + 1; ++i) {
                int y = world.method_31604(i);
                if (blockLightProvider != null) {
                    blockLightProvider.bobby_addSectionData(class_4076.method_18681((class_1923)pos, (int)y).method_18694(), blockLight[i + 1]);
                }
                if (skyLightProvider == null || !hasSkyLight) continue;
                skyLightProvider.bobby_addSectionData(class_4076.method_18681((class_1923)pos, (int)y).method_18694(), skyLight[i + 1]);
            }
            chunk.setTainted(config.isTaintFakeChunks());
            for (class_2338 blockPos : chunk.method_12021()) {
                chunk.method_8321(blockPos);
            }
            return chunk;
        };
    }

    public static Pair<class_2818, Supplier<class_2818>> shallowCopy(class_2818 original) {
        BobbyConfig config = Bobby.getInstance().getConfig();
        class_1937 world = original.method_12200();
        class_1923 chunkPos = original.method_12004();
        class_2826[] chunkSections = original.method_12006();
        class_2804[] blockLight = new class_2804[chunkSections.length + 2];
        class_2804[] skyLight = new class_2804[chunkSections.length + 2];
        class_3568 lightingProvider = world.method_8398().method_12130();
        class_6606 initialLightData = WorldChunkExt.get(original).bobby_getInitialLightData();
        if (initialLightData != null) {
            Iterator blockNibbles = initialLightData.method_38610().iterator();
            Iterator skyNibbles = initialLightData.method_38606().iterator();
            int y = lightingProvider.method_31929();
            int i = 0;
            while (y < lightingProvider.method_31930()) {
                boolean hasBlockData = initialLightData.method_38608().get(i);
                boolean isBlockZero = initialLightData.method_38609().get(i);
                if (hasBlockData || isBlockZero) {
                    blockLight[i] = hasBlockData ? new class_2804((byte[])((byte[])blockNibbles.next()).clone()) : new class_2804();
                }
                boolean hasSkyData = initialLightData.method_38601().get(i);
                boolean isSkyZero = initialLightData.method_38604().get(i);
                if (hasSkyData || isSkyZero) {
                    skyLight[i] = hasSkyData ? new class_2804((byte[])((byte[])skyNibbles.next()).clone()) : new class_2804();
                }
                ++y;
                ++i;
            }
        } else {
            int y = lightingProvider.method_31929();
            int i = 0;
            while (y < lightingProvider.method_31930()) {
                blockLight[i] = lightingProvider.method_15562(class_1944.field_9282).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y));
                skyLight[i] = lightingProvider.method_15562(class_1944.field_9284).method_15544(class_4076.method_18681((class_1923)chunkPos, (int)y));
                ++y;
                ++i;
            }
        }
        FakeChunk fake = new FakeChunk(world, chunkPos, chunkSections);
        fake.blockLight = blockLight;
        fake.skyLight = skyLight;
        for (Map.Entry entry : original.method_12011()) {
            fake.setHeightmap((class_2902.class_2903)entry.getKey(), (class_2902)entry.getValue());
        }
        class_2499 blockEntitiesTag = new class_2499();
        for (class_2338 pos : original.method_12021()) {
            class_2487 blockEntityTag = original.method_20598(pos, (class_7225.class_7874)world.method_30349());
            if (blockEntityTag == null) continue;
            blockEntitiesTag.add((Object)blockEntityTag);
            if (config.isNoBlockEntities()) continue;
            fake.method_12042(blockEntityTag);
        }
        fake.serializedBlockEntities = blockEntitiesTag;
        return Pair.of((Object)((Object)fake), ChunkSerializer.loadChunk(fake, blockLight, skyLight, config));
    }

    private static class_2804 floodSkylightFromAbove(class_2804 above) {
        if (above.method_12146()) {
            return new class_2804();
        }
        byte[] aboveBytes = above.method_12137();
        byte[] belowBytes = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(aboveBytes, 0, belowBytes, i * 128, 128);
        }
        return new class_2804(belowBytes);
    }

    private static void logRecoverableError(class_1923 chunkPos, int y, String message) {
        LOGGER.error("Recoverable errors when loading section [" + chunkPos.field_9181 + ", " + y + ", " + chunkPos.field_9180 + "]: " + message);
    }

    public static long fingerprint(class_2818 chunk) {
        class_2826[] sectionArray = chunk.method_12006();
        BitSet opaqueBlocks = new BitSet(sectionArray.length * 16 * 16 * 16);
        boolean lowQuality = true;
        int i = 0;
        for (class_2826 chunkSection : sectionArray) {
            if (chunkSection == null) {
                i += 4096;
                continue;
            }
            class_2841 container = chunkSection.method_12265();
            for (int y = 0; y < 16; ++y) {
                int opaqueCount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState.method_26225()) {
                            opaqueBlocks.set(i);
                            ++opaqueCount;
                        }
                        ++i;
                    }
                }
                if (!lowQuality || opaqueCount <= 0 || opaqueCount >= 256) continue;
                lowQuality = false;
            }
        }
        if (lowQuality) {
            return 1L;
        }
        long fingerprint = Hashing.farmHashFingerprint64().hashBytes(opaqueBlocks.toByteArray()).asLong();
        if (fingerprint == 0L || fingerprint == 1L) {
            return fingerprint + 2L;
        }
        return fingerprint;
    }

    static {
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    COMPLETELY_LIT.method_12145(x, y, z, 15);
                }
            }
        }
        BLOCK_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    }
}

