/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.collection;

import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6880;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.ITextCollection;

public class GuiComboBox
extends GuiLabel {
    protected GuiComboBoxExtension extension;
    public CompiledText[] lines;
    private int index;
    public boolean extensionLostFocus;
    private boolean searchbar;

    public GuiComboBox(String name, ITextCollection builder) {
        super(name);
        this.lines = builder.build();
        if (this.index >= this.lines.length) {
            this.index = 0;
        }
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].setAlign(Align.CENTER);
        }
        this.updateDisplay();
    }

    public boolean hasSearchbar() {
        return this.searchbar;
    }

    public GuiComboBox setSearchbar(boolean searchbar) {
        this.searchbar = searchbar;
        return this;
    }

    public void next() {
        int index = this.index + 1;
        if (index >= this.lines.length) {
            index = 0;
        }
        this.select(index);
    }

    public void previous() {
        int index = this.index - 1;
        if (index < 0) {
            index = this.lines.length - 1;
        }
        this.select(index);
    }

    protected void updateDisplay() {
        this.text = this.index >= 0 && this.index < this.lines.length ? this.lines[this.index] : CompiledText.EMPTY;
    }

    @Override
    public void flowX(int width, int preferred) {
        for (CompiledText text : this.lines) {
            text.setDimension(width, Integer.MAX_VALUE);
        }
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        for (CompiledText text : this.lines) {
            text.setMaxHeight(height);
        }
    }

    @Override
    public int preferredWidth(int availableWidth) {
        int width = 0;
        for (CompiledText text : this.lines) {
            width = Math.max(width, text.getTotalWidth() + 3);
        }
        return width;
    }

    @Override
    public int preferredHeight(int width, int availableHeight) {
        int height = 0;
        for (CompiledText text : this.lines) {
            height = Math.max(height, text.getTotalHeight());
        }
        return height;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean select(int index) {
        if (index >= 0 && index < this.lines.length) {
            this.index = index;
            this.updateDisplay();
            this.raiseEvent(new GuiControlChangedEvent<GuiComboBox>(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (this.extension == null) {
            this.openBox(rect);
        } else {
            this.closeBox();
        }
        GuiComboBox.playSound((class_6880.class_6883<class_3414>)class_3417.field_15015);
        return true;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.CLICKABLE;
    }

    public void openBox(Rect rect) {
        this.extension = this.createBox();
        GuiChildControl child = this.getLayer().addHoverControl(this.extension);
        rect = this.toLayerRect(new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight()));
        this.extension.init();
        child.setX((int)rect.minX);
        child.setY((int)rect.maxY);
        child.setWidth((int)rect.getWidth(), (int)this.getLayer().rect.getWidth() - this.getContentOffset() * 2);
        child.flowX();
        int height = (int)this.getLayer().rect.getHeight() - this.getContentOffset() * 2;
        child.setHeight(child.getPreferredHeight(height), height);
        child.flowY();
        Rect absolute = this.extension.getIntegratedParent().toScreenRect(this.extension.getLayer(), child.rect.copy());
        Rect screen = Rect.getScreenRect();
        if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
            child.setY(child.getY() - ((int)rect.getHeight() + child.getHeight()));
        }
    }

    protected GuiComboBoxExtension createBox() {
        return new GuiComboBoxExtension(this.name + "extension", this);
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }

    @Override
    public void looseFocus() {
        if (this.extensionLostFocus && this.extension != null) {
            this.closeBox();
        }
    }
}

