/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.sync;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSync;
import team.creative.creativecore.common.gui.sync.GuiSyncControl;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobal;
import team.creative.creativecore.common.gui.sync.GuiSyncGlobalLayer;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.gui.sync.GuiSyncLocalLayer;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiSyncHolder {
    public static final GuiSyncHolderGlobal GLOBAL = new GuiSyncHolderGlobal();

    public static GuiSync followPath(String path, IGuiIntegratedParent parent) {
        String holderName;
        GuiSyncHolder holder;
        if (path.startsWith("global:")) {
            holder = GLOBAL;
            holderName = path.substring(7);
        } else {
            int index = path.indexOf(58);
            String syncpath = path.substring(0, index);
            holderName = path.substring(index + 1);
            GuiControl control = parent.get(syncpath);
            if (control instanceof GuiLayer) {
                GuiLayer layer = (GuiLayer)control;
                holder = layer.getSyncHolder();
            } else {
                holder = null;
            }
        }
        if (holder == null) {
            throw new RuntimeException("Could not find holder for " + path);
        }
        GuiSync sync = ((GuiSyncHolder)holder).getSync(holderName);
        if (sync == null) {
            throw new RuntimeException("Could not find sync for " + path);
        }
        return sync;
    }

    public static GuiSyncControl followPathControl(String path, IGuiIntegratedParent parent) {
        String holderName;
        GuiSyncHolder holder;
        if (path.startsWith("global:")) {
            holder = GLOBAL;
            holderName = path.substring(7);
        } else {
            int index = path.indexOf(58);
            String syncpath = path.substring(0, index);
            holderName = path.substring(index + 1);
            GuiControl control = parent.get(syncpath);
            if (control instanceof GuiLayer) {
                GuiLayer layer = (GuiLayer)control;
                holder = layer.getSyncHolder();
            } else {
                holder = null;
            }
        }
        if (holder == null) {
            throw new RuntimeException("Could not find holder for " + path);
        }
        GuiSyncControl sync = ((GuiSyncHolder)holder).getControlSync(holderName);
        if (sync == null) {
            throw new RuntimeException("Could not find sync for " + path);
        }
        return sync;
    }

    public abstract String path();

    public abstract GuiSync getSync(String var1);

    public abstract GuiSyncControl getControlSync(String var1);

    public static class GuiSyncHolderGlobal
    extends GuiSyncHolder {
        protected final NamedHandlerRegistry<GuiSync> SYNC_REGISTRY = new NamedHandlerRegistry<Object>(null);
        protected final NamedHandlerRegistry<GuiSyncControl> SYNC_CONTROL_REGISTRY = new NamedHandlerRegistry<Object>(null);

        public <C extends GuiControl, T extends class_2520> GuiSyncGlobal<C, T> register(String id, BiConsumer<C, T> consumer) {
            GuiSyncGlobal<C, T> sync = new GuiSyncGlobal<C, T>(this, id, consumer);
            this.SYNC_CONTROL_REGISTRY.register(id, sync);
            return sync;
        }

        public <T extends GuiLayer> GuiSyncGlobalLayer<T> layer(String id, BiFunction<class_7225.class_7874, class_2487, T> creator) {
            GuiSyncGlobalLayer<T> sync = new GuiSyncGlobalLayer<T>(this, id, creator);
            this.SYNC_REGISTRY.register(id, sync);
            return sync;
        }

        @Override
        public String path() {
            return "global:";
        }

        @Override
        public GuiSync getSync(String id) {
            return this.SYNC_REGISTRY.get(id);
        }

        @Override
        public GuiSyncControl getControlSync(String id) {
            return this.SYNC_CONTROL_REGISTRY.get(id);
        }
    }

    public static class GuiSyncHolderLayer
    extends GuiSyncHolder {
        protected final NamedHandlerRegistry<GuiSyncControl> SYNC_CONTROL_REGISTRY = new NamedHandlerRegistry<Object>(null);
        public final GuiLayer parent;

        public GuiSyncHolderLayer(GuiLayer layer) {
            this.parent = layer;
        }

        public <T extends class_2520> GuiSyncLocal<T> register(String id, Consumer<T> consumer) {
            GuiSyncLocal<T> sync = new GuiSyncLocal<T>(this, id, consumer);
            this.SYNC_CONTROL_REGISTRY.register(id, sync);
            return sync;
        }

        public <T extends GuiLayer> GuiSyncLocalLayer<T> layer(String id, Function<class_2487, T> creator) {
            GuiSyncLocalLayer<T> sync = new GuiSyncLocalLayer<T>(this, id, creator);
            this.SYNC_CONTROL_REGISTRY.register(id, sync);
            return sync;
        }

        @Override
        public String path() {
            return this.parent.getNestedName() + ":";
        }

        @Override
        public GuiSync getSync(String id) {
            return null;
        }

        @Override
        public GuiSyncControl getControlSync(String id) {
            return this.SYNC_CONTROL_REGISTRY.get(id);
        }
    }
}

