/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.player.ETFPlayerEntity;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.features.texture_handlers.ETFTextureVariator;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFLruCache;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityIntLRU;

public class ETFManager {
    private static final ETFTexture ETF_ERROR_TEXTURE = ETFManager.getErrorETFTexture();
    private static ETFManager instance;
    public final ObjectOpenHashSet<String> EMISSIVE_SUFFIX_LIST = new ObjectOpenHashSet();
    public final ETFLruCache<UUID, ETFPlayerTexture> PLAYER_TEXTURE_MAP = new ETFLruCache();
    public final ArrayList<String> KNOWN_RESOURCEPACK_ORDER = new ArrayList();
    public final ObjectOpenHashSet<class_1299<?>> ENTITY_TYPE_IGNORE_PARTICLES = new ObjectOpenHashSet();
    public final Object2ReferenceOpenHashMap<@NotNull class_2960, @Nullable ETFTexture> ETF_TEXTURE_CACHE = new Object2ReferenceOpenHashMap();
    public final EntityIntLRU LAST_SUFFIX_OF_ENTITY = new EntityIntLRU();
    public final EntityIntLRU LAST_RULE_INDEX_OF_ENTITY = new EntityIntLRU();
    public final Object2ReferenceOpenHashMap<@NotNull class_2960, @NotNull ETFDirectory> ETF_DIRECTORY_CACHE = new Object2ReferenceOpenHashMap();
    private final Object2ObjectOpenHashMap<class_2960, ETFTextureVariator> VARIATOR_MAP = new Object2ObjectOpenHashMap();
    public UUID ENTITY_DEBUG = null;
    public Boolean mooshroomBrownCustomShroomExists = null;
    public Boolean mooshroomRedCustomShroomExists = null;
    public ETFTexture redMooshroomAlt = null;
    public ETFTexture brownMooshroomAlt = null;

    private ETFManager() {
        for (class_3262 pack : class_310.method_1551().method_1478().method_29213().toList()) {
            this.KNOWN_RESOURCEPACK_ORDER.add(pack.method_14409());
        }
        try {
            ArrayList<Properties> props = new ArrayList<Properties>();
            String[] paths = new String[]{"optifine/emissive.properties", "textures/emissive.properties", "etf/emissive.properties"};
            for (String path : paths) {
                List<Properties> prop = ETFUtils2.readAndReturnAllLayeredPropertiesElseNull(ETFUtils2.res(path));
                if (prop == null) continue;
                props.addAll(prop);
            }
            for (Properties prop : props) {
                String[] keys;
                for (String key : keys = new String[]{"entities.suffix.emissive", "suffix.emissive"}) {
                    String value = prop.getProperty(key);
                    if (value == null) continue;
                    this.EMISSIVE_SUFFIX_LIST.add((Object)value);
                }
            }
            if (ETF.config().getConfig().alwaysCheckVanillaEmissiveSuffix) {
                this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
            }
            if (this.EMISSIVE_SUFFIX_LIST.isEmpty()) {
                ETFUtils2.logMessage("no emissive suffixes found: default emissive suffix '_e' used");
                this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
            } else {
                ETFUtils2.logMessage("emissive suffixes loaded: " + String.valueOf(this.EMISSIVE_SUFFIX_LIST));
            }
        }
        catch (Exception e) {
            ETFUtils2.logError("emissive suffixes could not be read: default emissive suffix '_e' used");
            this.EMISSIVE_SUFFIX_LIST.add((Object)"_e");
        }
    }

    public static ETFManager getInstance() {
        if (instance == null) {
            instance = new ETFManager();
        }
        return instance;
    }

    public static void resetInstance() {
        ETF.config().loadFromFile();
        instance = new ETFManager();
    }

    @NotNull
    public static ETFTexture getErrorETFTexture() {
        ETFUtils2.registerNativeImageToIdentifier(ETFUtils2.emptyNativeImage(), ETFUtils2.res("entity_texture_features", "error.png"));
        return new ETFTexture(ETFUtils2.res("entity_texture_features", "error.png"));
    }

    public static ETFConfig.EmissiveRenderModes getEmissiveMode() {
        ETFConfig.EmissiveRenderModes mode = ETF.config().getConfig().getEmissiveRenderMode();
        if (mode == ETFConfig.EmissiveRenderModes.BRIGHT && ETFRenderContext.getCurrentEntity() != null && !ETFRenderContext.getCurrentEntity().etf$canBeBright()) {
            return ETFConfig.EmissiveRenderModes.DULL;
        }
        return mode;
    }

    public String getGeneralPrintout() {
        return "\u00a7aGeneral: \u00a7r\n\u00a72 - amount of 'base' textures: \u00a7r" + this.VARIATOR_MAP.size() + "\n\u00a72 - total textures including variants: \u00a7r" + this.ETF_TEXTURE_CACHE.size();
    }

    public void doTheBigBoyPrintoutKronk() {
        StringBuilder out = new StringBuilder();
        out.append("\n||||||||||||||-ETF EVERYTHING LOG START-|||||||||||||||").append("\n----------------------------------------").append("\n-----------General stats-------------").append("\n----------------------------------------").append("\n known emissive suffixes: \n - ").append(this.EMISSIVE_SUFFIX_LIST).append("\n player textures: \n - ").append(this.PLAYER_TEXTURE_MAP.size()).append("\n----------------------------------------").append("\n----------Texture totals----------------").append("\n----------------------------------------").append("\n amount of textures that have or can variate: \n - ").append(this.VARIATOR_MAP.size()).append("\n amount of textures seen by ETF total (not including emissives): \n - ").append(this.ETF_TEXTURE_CACHE.size());
        StringBuilder textureLoopVariates = new StringBuilder();
        StringBuilder textureLoopNormal = new StringBuilder();
        int totalEmissive = 0;
        int totalEnchant = 0;
        for (ETFTexture texture : this.ETF_TEXTURE_CACHE.values()) {
            if (texture == null) continue;
            if (texture.isEmissive()) {
                ++totalEmissive;
            }
            if (texture.isEnchanted()) {
                ++totalEnchant;
            }
            if (this.VARIATOR_MAP.containsKey((Object)texture.thisIdentifier)) {
                textureLoopVariates.append("\n - ").append(((ETFTextureVariator)this.VARIATOR_MAP.get((Object)texture.thisIdentifier)).getPrintout().replaceAll("\n", "\n      "));
            }
            textureLoopNormal.append("\n - ").append(texture);
        }
        out.append("\n total emissives: \n - ").append(totalEmissive).append("\n total enchanted: \n - ").append(totalEnchant).append("\n----------------------------------------").append("\n----------ALL texture groups-------------").append("\n----------------------------------------").append("\n (Note: all of these can be varied via random entity rules)").append(textureLoopVariates.toString().replaceAll("\u00a7.", "")).append("\n----------------------------------------").append("\n----------ALL Textures Seen-------------").append("\n----------------------------------------").append("\n (Note: these are not all variable by random entity rules, but can usually be emissive)").append((CharSequence)textureLoopNormal).append("\n----------------------------------------");
        out.append("\n----------------------------------------").append("\n||||||||||||||-ETF EVERYTHING LOG END-|||||||||||||||");
        ETFUtils2.logMessage(out.toString());
    }

    public void grabSpecialProperties(Properties props, ETFEntity entity) {
        if (entity == null) {
            return;
        }
        if (props.containsKey("vanillaBrightnessOverride")) {
            String value = props.getProperty("vanillaBrightnessOverride").trim();
            try {
                int tryNumber = Integer.parseInt(value.replaceAll("\\D", ""));
                if (tryNumber >= 16) {
                    tryNumber = 15;
                }
                if (tryNumber < 0) {
                    tryNumber = 0;
                }
                ETF.config().getConfig().entityLightOverrides.put((Object)entity.etf$getEntityKey(), tryNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (props.containsKey("suppressParticles") && "true".equals(props.getProperty("suppressParticles"))) {
            this.ENTITY_TYPE_IGNORE_PARTICLES.add(entity.etf$getType());
        }
        if (props.containsKey("entityRenderLayerOverride")) {
            String layer;
            switch (layer = props.getProperty("entityRenderLayerOverride")) {
                case "translucent": {
                    ETF.config().getConfig().entityRenderLayerOverrides.put(entity.etf$getEntityKey(), (Object)ETFConfig.RenderLayerOverride.TRANSLUCENT);
                    break;
                }
                case "translucent_cull": {
                    ETF.config().getConfig().entityRenderLayerOverrides.put(entity.etf$getEntityKey(), (Object)ETFConfig.RenderLayerOverride.TRANSLUCENT_CULL);
                    break;
                }
                case "end_portal": {
                    ETF.config().getConfig().entityRenderLayerOverrides.put(entity.etf$getEntityKey(), (Object)ETFConfig.RenderLayerOverride.END);
                    break;
                }
                case "outline": {
                    ETF.config().getConfig().entityRenderLayerOverrides.put(entity.etf$getEntityKey(), (Object)ETFConfig.RenderLayerOverride.OUTLINE);
                }
            }
        }
    }

    public void markEntityForDebugPrint(UUID uuid) {
        if (ETF.config().getConfig().debugLoggingMode != ETFConfig.DebugLogMode.None) {
            this.ENTITY_DEBUG = uuid;
        }
    }

    @NotNull
    public ETFTexture getETFTextureNoVariation(class_2960 vanillaIdentifier) {
        return this.getOrCreateETFTexture(vanillaIdentifier);
    }

    @NotNull
    public ETFTexture getETFTextureVariant(@NotNull class_2960 vanillaIdentifier, @Nullable ETFEntity entity) {
        if (entity == null || entity.etf$getUuid() == ETFApi.ETF_GENERIC_UUID || entity.etf$getBlockPos().equals((Object)class_2382.field_11176) && entity.etf$getUuid().getLeastSignificantBits() != 0x303900003039L) {
            return this.getETFTextureNoVariation(vanillaIdentifier);
        }
        if (!this.VARIATOR_MAP.containsKey((Object)vanillaIdentifier)) {
            if ("etf_skin".equals(vanillaIdentifier.method_12836())) {
                return this.getETFTextureNoVariation(vanillaIdentifier);
            }
            this.VARIATOR_MAP.put((Object)vanillaIdentifier, (Object)ETFTextureVariator.of(vanillaIdentifier));
            if (ETF.config().getConfig().logTextureDataInitialization) {
                ETFUtils2.logMessage("Amount of 'base' textures: " + this.VARIATOR_MAP.size());
                ETFUtils2.logMessage("Total textures including variants: " + this.ETF_TEXTURE_CACHE.size());
            }
        }
        return ((ETFTextureVariator)this.VARIATOR_MAP.get((Object)vanillaIdentifier)).getVariantOf(entity);
    }

    @NotNull
    private ETFTexture getOrCreateETFTexture(class_2960 ofIdentifier) {
        return (ETFTexture)this.ETF_TEXTURE_CACHE.computeIfAbsent((Object)ofIdentifier, k -> new ETFTexture((class_2960)k));
    }

    @Nullable
    public ETFPlayerTexture getPlayerTexture(class_1657 player, class_2960 rendererGivenSkin) {
        return this.getPlayerTexture((ETFPlayerEntity)player, rendererGivenSkin);
    }

    @Nullable
    public ETFPlayerTexture getPlayerTexture(ETFPlayerEntity player, class_2960 rendererGivenSkin) {
        try {
            UUID id = player.etf$getUuid();
            if (this.PLAYER_TEXTURE_MAP.containsKey(id)) {
                ETFPlayerTexture possibleSkin = this.PLAYER_TEXTURE_MAP.get(id);
                if (possibleSkin == null || possibleSkin.player == null && possibleSkin.isCorrectObjectForThisSkin(rendererGivenSkin)) {
                    return null;
                }
                if (possibleSkin.isCorrectObjectForThisSkin(rendererGivenSkin) || class_310.method_1551().field_1755 instanceof ETFConfigScreenSkinTool) {
                    return possibleSkin;
                }
            }
            this.PLAYER_TEXTURE_MAP.put(id, null);
            ETFPlayerTexture etfPlayerTexture = new ETFPlayerTexture(player, rendererGivenSkin);
            this.PLAYER_TEXTURE_MAP.put(id, etfPlayerTexture);
            return etfPlayerTexture;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum TextureSource {
        ENTITY,
        BLOCK_ENTITY,
        ENTITY_FEATURE;

    }
}

