/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer;

import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.data.RenameData;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.data.SyncData;
import com.mrbysco.armorposer.handlers.EventHandler;
import com.mrbysco.armorposer.packets.ArmorStandRenamePayload;
import com.mrbysco.armorposer.packets.ArmorStandScreenPayload;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_3218;

public class ArmorPoser
implements ModInitializer {
    public static ConfigHolder<PoserConfig> config;

    public void onInitialize() {
        config = AutoConfig.register(PoserConfig.class, Toml4jConfigSerializer::new);
        UseItemCallback.EVENT.register((player, world, hand) -> EventHandler.onPlayerRightClickItem(player, hand));
        PayloadTypeRegistry.playS2C().register(ArmorStandScreenPayload.ID, ArmorStandScreenPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ArmorStandSyncPayload.ID, ArmorStandSyncPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ArmorStandSyncPayload.ID, (payload, context) -> {
            class_3218 serverLevel = context.player().method_51469();
            SyncData syncData = payload.data();
            context.player().field_13995.execute(() -> {
                class_1297 entity = serverLevel.method_14190(syncData.entityUUID());
                if (entity instanceof class_1531) {
                    class_1531 armorStandEntity = (class_1531)entity;
                    syncData.handleData(armorStandEntity, (class_1657)context.player());
                }
            });
        });
        PayloadTypeRegistry.playC2S().register(ArmorStandSwapPayload.ID, ArmorStandSwapPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ArmorStandSwapPayload.ID, (payload, context) -> {
            class_3218 serverLevel = context.player().method_51469();
            SwapData swapData = payload.data();
            context.player().field_13995.execute(() -> {
                class_1297 entity = serverLevel.method_14190(swapData.entityUUID());
                if (entity instanceof class_1531) {
                    class_1531 armorStandEntity = (class_1531)entity;
                    swapData.handleData(armorStandEntity);
                }
            });
        });
        PayloadTypeRegistry.playC2S().register(ArmorStandRenamePayload.ID, ArmorStandRenamePayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(ArmorStandRenamePayload.ID, (payload, context) -> {
            class_3218 serverLevel = context.player().method_51469();
            RenameData renameData = payload.data();
            context.player().field_13995.execute(() -> {
                class_1297 entity = serverLevel.method_14190(renameData.entityUUID());
                if (entity instanceof class_1531) {
                    class_1531 armorStandEntity = (class_1531)entity;
                    renameData.handleData(armorStandEntity, (class_1657)context.player());
                }
            });
        });
    }
}

