/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class NameBox
extends class_339 {
    private static final class_8666 SPRITES = new class_8666(class_2960.method_60656((String)"widget/text_field"), class_2960.method_60656((String)"widget/text_field_highlighted"));
    private final class_327 font;
    private String value = "";
    private int maxLength = 32;
    private boolean bordered = true;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private Consumer<String> responder;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (forward, p_94148_) -> class_5481.method_30747((String)forward, (class_2583)class_2583.field_24360);
    @Nullable
    private class_2561 hint;
    private long focusedTime = class_156.method_658();
    private boolean textShadow = true;

    public NameBox(class_327 font, int width, int height, class_2561 message) {
        this(font, 0, 0, width, height, message);
    }

    public NameBox(class_327 font, int x, int y, int width, int height, class_2561 message) {
        this(font, x, y, width, height, null, message);
    }

    public NameBox(class_327 font, int x, int y, int width, int height, @Nullable NameBox editBox, class_2561 message) {
        super(x, y, width, height, message);
        this.font = font;
        if (editBox != null) {
            this.setValue(editBox.getValue());
        }
        this.scrollTo(0);
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> textFormatter) {
        this.formatter = textFormatter;
    }

    protected class_5250 method_25360() {
        class_2561 component = this.method_25369();
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{component, this.value});
    }

    public void setValue(String text) {
        if (this.filter.test(text)) {
            this.value = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.moveCursorToEnd(false);
            this.setHighlightPos(this.cursorPos);
            this.onValueChange(text);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> validator) {
        this.filter = validator;
    }

    public void insertText(String textToWrite) {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k > 0) {
            String s1;
            String s = class_3544.method_57180((String)textToWrite);
            int l = s.length();
            if (k < l) {
                if (Character.isHighSurrogate(s.charAt(k - 1))) {
                    --k;
                }
                s = s.substring(0, k);
                l = k;
            }
            if (this.filter.test(s1 = new StringBuilder(this.value).replace(i, j, s).toString())) {
                this.value = s1;
                this.setCursorPosition(i + l);
                this.setHighlightPos(this.cursorPos);
                this.onValueChange(this.value);
            }
        }
    }

    private void onValueChange(String newText) {
        if (this.responder != null) {
            this.responder.accept(newText);
        }
    }

    private void deleteText(int count) {
        if (class_437.method_25441()) {
            this.deleteWords(count);
        } else {
            this.deleteChars(count);
        }
    }

    public void deleteWords(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                this.deleteCharsToPos(this.getWordPosition(num));
            }
        }
    }

    public void deleteChars(int num) {
        this.deleteCharsToPos(this.getCursorPos(num));
    }

    public void deleteCharsToPos(int num) {
        if (!this.value.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.insertText("");
            } else {
                String s;
                int j;
                int i = Math.min(num, this.cursorPos);
                if (i != (j = Math.max(num, this.cursorPos)) && this.filter.test(s = new StringBuilder(this.value).delete(i, j).toString())) {
                    this.value = s;
                    this.moveCursorTo(i, false);
                }
            }
        }
    }

    public int getWordPosition(int numWords) {
        return this.getWordPosition(numWords, this.getCursorPosition());
    }

    private int getWordPosition(int numWords, int pos) {
        return this.getWordPosition(numWords, pos, true);
    }

    private int getWordPosition(int numWords, int pos, boolean skipConsecutiveSpaces) {
        int i = pos;
        boolean flag = numWords < 0;
        int j = Math.abs(numWords);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.value.length();
                if ((i = this.value.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipConsecutiveSpaces && i < l && this.value.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipConsecutiveSpaces && i > 0 && this.value.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.value.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int delta, boolean select) {
        this.moveCursorTo(this.getCursorPos(delta), select);
    }

    private int getCursorPos(int delta) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)delta);
    }

    public void moveCursorTo(int delta, boolean select) {
        this.setCursorPosition(delta);
        if (!select) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void setCursorPosition(int pos) {
        this.cursorPos = class_3532.method_15340((int)pos, (int)0, (int)this.value.length());
        this.scrollTo(this.cursorPos);
    }

    public void moveCursorToStart(boolean select) {
        this.moveCursorTo(0, select);
    }

    public void moveCursorToEnd(boolean select) {
        this.moveCursorTo(this.value.length(), select);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_37303() && this.method_25370()) {
            switch (keyCode) {
                case 259: {
                    if (this.isEditable) {
                        this.deleteText(-1);
                    }
                    return true;
                }
                default: {
                    if (class_437.method_25439((int)keyCode)) {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        return true;
                    }
                    if (class_437.method_25438((int)keyCode)) {
                        class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                        return true;
                    }
                    if (class_437.method_25437((int)keyCode)) {
                        if (this.isEditable()) {
                            this.insertText(class_310.method_1551().field_1774.method_1460());
                        }
                        return true;
                    }
                    if (class_437.method_25436((int)keyCode)) {
                        class_310.method_1551().field_1774.method_1455(this.getHighlighted());
                        if (this.isEditable()) {
                            this.insertText("");
                        }
                        return true;
                    }
                    return false;
                }
                case 261: {
                    if (this.isEditable) {
                        this.deleteText(1);
                    }
                    return true;
                }
                case 262: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(1), class_437.method_25442());
                    } else {
                        this.moveCursor(1, class_437.method_25442());
                    }
                    return true;
                }
                case 263: {
                    if (class_437.method_25441()) {
                        this.moveCursorTo(this.getWordPosition(-1), class_437.method_25442());
                    } else {
                        this.moveCursor(-1, class_437.method_25442());
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart(class_437.method_25442());
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd(class_437.method_25442());
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.method_37303() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_3544.method_57175((char)codePoint)) {
            if (this.isEditable) {
                this.insertText(Character.toString(codePoint));
            }
            return true;
        }
        return false;
    }

    public void method_25348(double mouseX, double mouseY) {
        int i = class_3532.method_15357((double)mouseX) - this.method_46426();
        if (this.bordered) {
            i -= 4;
        }
        String s = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.method_27523(s, i).length() + this.displayPos, class_437.method_25442());
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                class_2960 resourcelocation = SPRITES.method_52729(this.method_37303(), this.method_25370());
                guiGraphics.method_52706(class_1921::method_62277, resourcelocation, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }
            int usedColor = this.isEditable ? this.textColor : this.textColorUneditable;
            int i = this.cursorPos - this.displayPos;
            String s = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
            boolean flag = i >= 0 && i <= s.length();
            boolean flag1 = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L && flag;
            int j = this.bordered ? this.method_46426() + 4 : this.method_46426();
            int k = this.bordered ? this.method_46427() + (this.field_22759 - 8) / 2 : this.method_46427();
            int l = j;
            int i1 = class_3532.method_15340((int)(this.highlightPos - this.displayPos), (int)0, (int)s.length());
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, i) : s;
                l = guiGraphics.method_51430(this.font, this.formatter.apply(s1, this.displayPos), j, k, usedColor, this.textShadow);
            }
            boolean flag2 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
            int j1 = l;
            if (!flag) {
                j1 = i > 0 ? j + this.field_22758 : j;
            } else if (flag2) {
                j1 = l - 1;
                --l;
            }
            if (!s.isEmpty() && flag && i < s.length()) {
                guiGraphics.method_51430(this.font, this.formatter.apply(s.substring(i), this.cursorPos), l, k, usedColor, this.textShadow);
            }
            if (this.hint != null && s.isEmpty() && !this.method_25370()) {
                guiGraphics.method_51439(this.font, this.hint, l, k, usedColor, this.textShadow);
            }
            if (flag1) {
                if (flag2) {
                    guiGraphics.method_51739(class_1921.method_51785(), j1, k - 1, j1 + 1, k + 1 + 9, -3092272);
                } else {
                    guiGraphics.method_51433(this.font, "_", j1, k, usedColor, this.textShadow);
                }
            }
            if (i1 != i) {
                int k1 = j + this.font.method_1727(s.substring(0, i1));
                this.renderHighlight(guiGraphics, j1, k - 1, k1 - 1, k + 1 + 9);
            }
        }
    }

    private void renderHighlight(class_332 guiGraphics, int minX, int minY, int maxX, int maxY) {
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        if (maxX > this.method_46426() + this.field_22758) {
            maxX = this.method_46426() + this.field_22758;
        }
        if (minX > this.method_46426() + this.field_22758) {
            minX = this.method_46426() + this.field_22758;
        }
        guiGraphics.method_51739(class_1921.method_51786(), minX, minY, maxX, maxY, -16776961);
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
        if (this.value.length() > length) {
            this.value = this.value.substring(0, length);
            this.onValueChange(this.value);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean enableBackgroundDrawing) {
        this.bordered = enableBackgroundDrawing;
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setTextColorUneditable(int color) {
        this.textColorUneditable = color;
    }

    public void method_25365(boolean focused) {
        if (this.canLoseFocus || focused) {
            super.method_25365(focused);
            if (focused) {
                this.focusedTime = class_156.method_658();
            }
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean enabled) {
        this.isEditable = enabled;
    }

    public int getInnerWidth() {
        return this.isBordered() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setHighlightPos(int position) {
        this.highlightPos = class_3532.method_15340((int)position, (int)0, (int)this.value.length());
        this.scrollTo(this.highlightPos);
    }

    private void scrollTo(int position) {
        if (this.font != null) {
            this.displayPos = Math.min(this.displayPos, this.value.length());
            int i = this.getInnerWidth();
            String s = this.font.method_27523(this.value.substring(this.displayPos), i);
            int j = s.length() + this.displayPos;
            if (position == this.displayPos) {
                this.displayPos -= this.font.method_27524(this.value, i, true).length();
            }
            if (position > j) {
                this.displayPos += position - j;
            } else if (position <= this.displayPos) {
                this.displayPos -= this.displayPos - position;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)this.value.length());
        }
    }

    public void setCanLoseFocus(boolean canLoseFocus) {
        this.canLoseFocus = canLoseFocus;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean isVisible) {
        this.field_22764 = isVisible;
    }

    public int getScreenX(int charNum) {
        return charNum > this.value.length() ? this.method_46426() : this.method_46426() + this.font.method_1727(this.value.substring(0, charNum));
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }

    public void setHint(class_2561 hint) {
        this.hint = hint;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public boolean getTextShadow() {
        return this.textShadow;
    }
}

