/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.ElementListWidgetExt;
import dev.isxander.yacl3.gui.LowProfileButtonWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends ElementListWidgetExt<Entry> {
    private final YACLScreen yaclScreen;
    private final ConfigCategory category;
    private ImmutableList<Entry> viewableChildren;
    private String searchQuery = "";
    private final Consumer<DescriptionWithName> hoverEvent;
    private DescriptionWithName lastHoveredOption;

    public OptionListWidget(YACLScreen screen, ConfigCategory category, class_310 client, int x, int y, int width, int height, Consumer<DescriptionWithName> hoverEvent) {
        super(client, x, y, width, height, true);
        this.yaclScreen = screen;
        this.category = category;
        this.hoverEvent = hoverEvent;
        this.refreshOptions();
        for (OptionGroup group : category.groups()) {
            if (!(group instanceof ListOption)) continue;
            ListOption listOption = (ListOption)group;
            listOption.addRefreshListener(() -> this.refreshListEntries(listOption, category));
        }
    }

    public void refreshOptions() {
        this.method_25339();
        for (OptionGroup group : this.category.groups()) {
            GroupSeparatorEntry groupSeparatorEntry;
            if (!group.isRoot()) {
                GroupSeparatorEntry groupSeparatorEntry2;
                if (group instanceof ListOption) {
                    ListOption listOption = (ListOption)group;
                    groupSeparatorEntry2 = new ListGroupSeparatorEntry(this, listOption, this.yaclScreen);
                } else {
                    groupSeparatorEntry2 = new GroupSeparatorEntry(group, this.yaclScreen);
                }
                groupSeparatorEntry = groupSeparatorEntry2;
                this.method_25321((class_350.class_351)groupSeparatorEntry);
            } else {
                groupSeparatorEntry = null;
            }
            ArrayList<Entry> optionEntries = new ArrayList<Entry>();
            if (groupSeparatorEntry instanceof ListGroupSeparatorEntry) {
                ListGroupSeparatorEntry listGroupSeparatorEntry = (ListGroupSeparatorEntry)groupSeparatorEntry;
                if (listGroupSeparatorEntry.listOption.options().isEmpty()) {
                    EmptyListLabel emptyListLabel = new EmptyListLabel(listGroupSeparatorEntry, this.category);
                    this.method_25321((class_350.class_351)emptyListLabel);
                    optionEntries.add(emptyListLabel);
                }
            }
            for (Option option : group.options()) {
                OptionEntry entry = new OptionEntry(option, this.category, group, groupSeparatorEntry, option.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
                this.method_25321((class_350.class_351)entry);
                optionEntries.add(entry);
            }
            if (groupSeparatorEntry == null) continue;
            groupSeparatorEntry.setChildEntries(optionEntries);
        }
        this.recacheViewableChildren();
        this.method_44382(0.0);
        this.resetSmoothScrolling();
    }

    private void refreshListEntries(ListOption<?> listOption, ConfigCategory category) {
        ListGroupSeparatorEntry groupSeparator = super.method_25396().stream().filter(e -> {
            if (!(e instanceof ListGroupSeparatorEntry)) return false;
            ListGroupSeparatorEntry gs = (ListGroupSeparatorEntry)((Object)e);
            if (gs.group != listOption) return false;
            return true;
        }).map(ListGroupSeparatorEntry.class::cast).findAny().orElse(null);
        if (groupSeparator == null) {
            YACLConstants.LOGGER.warn("Can't find group seperator to refresh list option entries for list option " + String.valueOf(listOption.name()));
            return;
        }
        for (Entry entry : groupSeparator.childEntries) {
            super.method_25330((class_350.class_351)entry);
        }
        groupSeparator.childEntries.clear();
        if (listOption.options().isEmpty()) {
            EmptyListLabel emptyListLabel = new EmptyListLabel(groupSeparator, category);
            this.addEntryBelow(groupSeparator, emptyListLabel);
            groupSeparator.childEntries.add(emptyListLabel);
            return;
        }
        Entry lastEntry = groupSeparator;
        for (ListOptionEntry listOptionEntry : listOption.options()) {
            OptionEntry optionEntry = new OptionEntry(listOptionEntry, category, listOption, groupSeparator, listOptionEntry.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
            this.addEntryBelow(lastEntry, optionEntry);
            groupSeparator.childEntries.add(optionEntry);
            lastEntry = optionEntry;
        }
    }

    public Dimension<Integer> getDefaultEntryDimension() {
        return Dimension.ofInt(this.method_25342(), 0, this.method_25322(), 20);
    }

    public void expandAllGroups() {
        for (Entry entry : super.method_25396()) {
            if (!(entry instanceof GroupSeparatorEntry)) continue;
            GroupSeparatorEntry groupSeparatorEntry = (GroupSeparatorEntry)entry;
            groupSeparatorEntry.setExpanded(true);
        }
    }

    public int method_25342() {
        return super.method_25342() - 6;
    }

    public int method_25322() {
        return this.method_25368() - 6 - 20;
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query;
        this.expandAllGroups();
        this.recacheViewableChildren();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (Entry child : this.method_25396()) {
            if (child == this.getEntryAtPosition(mouseX, mouseY) || !(child instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)child;
            optionEntry.widget.unfocus();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
        super.method_25401(mouseX, mouseY, horizontal, vertical);
        for (Entry child : this.method_25396()) {
            if (child.method_25401(mouseX, mouseY, horizontal, vertical)) break;
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25336() != null && this.method_25397() && this.isValidMouseClick(button)) {
            return ((Entry)this.method_25336()).method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.method_25404(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        for (Entry child : this.method_25396()) {
            if (!child.method_25400(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public void recacheViewableChildren() {
        this.viewableChildren = ImmutableList.copyOf(super.method_25396().stream().filter(Entry::isViewable).toList());
        int i = 0;
        for (Entry entry : this.viewableChildren) {
            if (entry instanceof OptionEntry) {
                OptionEntry optionEntry = (OptionEntry)entry;
                optionEntry.widget.setDimension(optionEntry.widget.getDimension().withY(this.method_25337(i)));
            }
            ++i;
        }
    }

    public List<Entry> method_25396() {
        return this.viewableChildren;
    }

    public void addEntry(int index, Entry entry) {
        super.method_25396().add(index, entry);
        this.recacheViewableChildren();
    }

    public void addEntryBelow(Entry below, Entry entry) {
        int idx = super.method_25396().indexOf((Object)below) + 1;
        if (idx == 0) {
            throw new IllegalStateException("The entry to insert below does not exist!");
        }
        this.addEntry(idx, entry);
    }

    public void addEntryBelowWithoutScroll(Entry below, Entry entry) {
        double d = (double)this.method_44395() - this.method_44387();
        this.addEntryBelow(below, entry);
        this.method_44382((double)this.method_44395() - d);
    }

    public boolean removeEntryFromTop(Entry entry) {
        boolean ret = super.method_44650((class_350.class_351)entry);
        this.recacheViewableChildren();
        return ret;
    }

    public boolean removeEntry(Entry entry) {
        boolean ret = super.method_25330((class_350.class_351)entry);
        this.recacheViewableChildren();
        return ret;
    }

    private void setHoverDescription(DescriptionWithName description) {
        if (description != this.lastHoveredOption) {
            this.lastHoveredOption = description;
            this.hoverEvent.accept(description);
        }
    }

    protected void method_57715(class_332 guiGraphics) {
    }

    public class ListGroupSeparatorEntry
    extends GroupSeparatorEntry {
        private final ListOption<?> listOption;
        private final TextScaledButtonWidget resetListButton;
        private final TooltipButtonWidget addListButton;

        private ListGroupSeparatorEntry(OptionListWidget this$0, ListOption<?> group, class_437 screen) {
            super(group, screen);
            this.listOption = group;
            this.resetListButton = new TextScaledButtonWidget(screen, this$0.method_31383() - 20, -50, 20, 20, 2.0f, (class_2561)class_2561.method_43470((String)"\u21bb"), button -> group.requestSetDefault());
            group.addListener((opt, val) -> {
                this.resetListButton.field_22763 = !opt.isPendingValueDefault() && opt.available();
            });
            this.resetListButton.field_22763 = !group.isPendingValueDefault() && group.available();
            this.addListButton = new TooltipButtonWidget(this$0.yaclScreen, this.resetListButton.method_46426() - 20, -50, 20, 20, (class_2561)class_2561.method_43470((String)"+"), (class_2561)class_2561.method_43471((String)"yacl.list.add_top"), btn -> {
                group.insertNewEntry();
                this.setExpanded(true);
            });
            this.updateExpandMinimizeText();
            this.minimizeIfUnavailable();
        }

        @Override
        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.updateExpandMinimizeText();
            super.method_25343(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            int buttonY = this.expandMinimizeButton.method_46427();
            this.resetListButton.method_46419(buttonY);
            this.addListButton.method_46419(buttonY);
            this.resetListButton.method_25394(graphics, mouseX, mouseY, tickDelta);
            this.addListButton.method_25394(graphics, mouseX, mouseY, tickDelta);
        }

        private void minimizeIfUnavailable() {
            if (!this.listOption.available() && this.isExpanded()) {
                this.setExpanded(false);
            }
        }

        @Override
        protected void updateExpandMinimizeText() {
            super.updateExpandMinimizeText();
            boolean bl = this.expandMinimizeButton.field_22763 = this.listOption == null || this.listOption.available();
            if (this.addListButton != null) {
                this.addListButton.field_22763 = this.expandMinimizeButton.field_22763 && this.listOption.numberOfEntries() < this.listOption.maximumNumberOfEntries();
            }
        }

        @Override
        public void setExpanded(boolean expanded) {
            super.setExpanded(this.listOption.available() && expanded);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton), (Object)((Object)this.addListButton), (Object)((Object)this.resetListButton));
        }
    }

    public class GroupSeparatorEntry
    extends Entry {
        protected final OptionGroup group;
        protected final class_5489 wrappedName;
        protected final class_5489 wrappedTooltip;
        protected final LowProfileButtonWidget expandMinimizeButton;
        protected final class_437 screen;
        protected final class_327 font;
        protected boolean groupExpanded;
        protected List<Entry> childEntries;
        private int y;

        private GroupSeparatorEntry(OptionGroup group, class_437 screen) {
            this.font = class_310.method_1551().field_1772;
            this.childEntries = new ArrayList<Entry>();
            this.group = group;
            this.screen = screen;
            this.wrappedName = class_5489.method_30890((class_327)this.font, (class_2561)group.name(), (int)(OptionListWidget.this.method_25322() - 45));
            this.wrappedTooltip = class_5489.method_30890((class_327)this.font, (class_2561)group.tooltip(), (int)(screen.field_22789 / 3 * 2 - 10));
            this.groupExpanded = !group.collapsed();
            this.expandMinimizeButton = new LowProfileButtonWidget(0, 0, 20, 20, (class_2561)class_2561.method_43473(), btn -> this.onExpandButtonPress());
            this.updateExpandMinimizeText();
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.y = y;
            int buttonY = y + entryHeight / 2 - this.expandMinimizeButton.method_25364() / 2 + 1;
            this.expandMinimizeButton.method_46419(buttonY);
            this.expandMinimizeButton.method_46421(x);
            this.expandMinimizeButton.method_25394(graphics, mouseX, mouseY, tickDelta);
            this.wrappedName.method_30888(graphics, x + entryWidth / 2, y + this.getYPadding());
            if (this.isHovered()) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public boolean isExpanded() {
            return this.groupExpanded;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupExpanded == expanded) {
                return;
            }
            this.groupExpanded = expanded;
            this.updateExpandMinimizeText();
            OptionListWidget.this.recacheViewableChildren();
        }

        protected void onExpandButtonPress() {
            this.setExpanded(!this.isExpanded());
        }

        protected void updateExpandMinimizeText() {
            this.expandMinimizeButton.method_25355((class_2561)class_2561.method_43470((String)(this.isExpanded() ? "\u25bc" : "\u25b6")));
        }

        public void setChildEntries(List<? extends Entry> childEntries) {
            this.childEntries.clear();
            this.childEntries.addAll(childEntries);
        }

        @Override
        public boolean isViewable() {
            return OptionListWidget.this.searchQuery.isEmpty() || this.childEntries.stream().anyMatch(Entry::isViewable);
        }

        @Override
        public int getItemHeight() {
            int n = Math.max(this.wrappedName.method_30887(), 1);
            Objects.requireNonNull(this.font);
            return n * 9 + this.getYPadding() * 2;
        }

        private int getYPadding() {
            return 6;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 builder) {
                    builder.method_37034(class_6381.field_33788, GroupSeparatorEntry.this.group.name());
                    builder.method_37034(class_6381.field_33790, GroupSeparatorEntry.this.group.tooltip());
                }
            });
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton));
        }
    }

    public class EmptyListLabel
    extends Entry {
        private final ListGroupSeparatorEntry parent;
        private final String groupName;
        private final String categoryName;

        public EmptyListLabel(ListGroupSeparatorEntry parent, ConfigCategory category) {
            this.parent = parent;
            this.groupName = parent.group.name().getString().toLowerCase();
            this.categoryName = category.name().getString().toLowerCase();
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            graphics.method_27534(class_310.method_1551().field_1772, (class_2561)class_2561.method_43471((String)"yacl.list.empty").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}), x + entryWidth / 2, y, -1);
        }

        @Override
        public boolean isViewable() {
            return this.parent.isExpanded() && (OptionListWidget.this.searchQuery.isEmpty() || this.groupName.contains(OptionListWidget.this.searchQuery));
        }

        @Override
        public int getItemHeight() {
            return 11;
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of();
        }
    }

    public class OptionEntry
    extends Entry {
        public final Option<?> option;
        public final ConfigCategory category;
        public final OptionGroup group;
        @Nullable
        public final GroupSeparatorEntry groupSeparatorEntry;
        public final AbstractWidget widget;
        private final TextScaledButtonWidget resetButton;
        private final String categoryName;
        private final String groupName;

        public OptionEntry(Option<?> option, ConfigCategory category, @Nullable OptionGroup group, GroupSeparatorEntry groupSeparatorEntry, AbstractWidget widget) {
            this.option = option;
            this.category = category;
            this.group = group;
            this.groupSeparatorEntry = groupSeparatorEntry;
            this.widget = widget;
            this.categoryName = category.name().getString().toLowerCase();
            this.groupName = group.name().getString().toLowerCase();
            if (option.canResetToDefault() && this.widget.canReset()) {
                this.widget.setDimension(this.widget.getDimension().expanded(-20, 0));
                this.resetButton = new TextScaledButtonWidget((class_437)OptionListWidget.this.yaclScreen, (int)widget.getDimension().xLimit(), -50, 20, 20, 2.0f, (class_2561)class_2561.method_43470((String)"\u21bb"), button -> option.requestSetDefault());
                option.addListener((opt, val) -> {
                    this.resetButton.field_22763 = !opt.isPendingValueDefault() && opt.available();
                });
                this.resetButton.field_22763 = !option.isPendingValueDefault() && option.available();
            } else {
                this.resetButton = null;
            }
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widget.setDimension(this.widget.getDimension().withY(y));
            this.widget.method_25394(graphics, mouseX, mouseY, tickDelta);
            if (this.resetButton != null) {
                this.resetButton.method_46419(y);
                this.resetButton.method_25394(graphics, mouseX, mouseY, tickDelta);
            }
            if (this.isHovered()) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontal, double vertical) {
            return this.widget.method_25401(mouseX, mouseY, horizontal, vertical);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            return this.widget.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25400(char chr, int modifiers) {
            return this.widget.method_25400(chr, modifiers);
        }

        @Override
        public boolean isViewable() {
            return !(this.groupSeparatorEntry != null && !this.groupSeparatorEntry.isExpanded() || !OptionListWidget.this.searchQuery.isEmpty() && !this.groupName.contains(OptionListWidget.this.searchQuery) && !this.widget.matchesSearch(OptionListWidget.this.searchQuery));
        }

        @Override
        public int getItemHeight() {
            return Math.max(this.widget.getDimension().height(), this.resetButton != null ? this.resetButton.method_25364() : 0) + 2;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public List<? extends class_6379> method_37025() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }

        public List<? extends class_364> method_25396() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }
    }

    public abstract class Entry
    extends ElementListWidgetExt.Entry<Entry> {
        public boolean isViewable() {
            return true;
        }

        protected boolean isHovered() {
            return Objects.equals(OptionListWidget.this.method_37019(), (Object)this);
        }
    }
}

