/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ConfiguredSound {
    public static final Codec<ConfiguredSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId), (App)class_2960.field_25139.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent.method_40237().method_29177()), (App)Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay), (App)Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch), (App)Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume)).apply((Applicative)instance, ConfiguredSound::new));
    public final String id;
    public final class_310 client;
    public boolean enabled;
    public class_6880.class_6883<class_3414> soundEvent;
    public float pitch = 1.0f;
    public float volume = 1.0f;
    private float _pendingPitch = 1.0f;
    private float _pendingVolume = 1.0f;
    private class_6880.class_6883<class_3414> _pendingSoundEvent;
    protected static long lastShownToast = -1L;

    public ConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume) {
        this.enabled = enabled;
        this.soundEvent = class_6880.class_6883.method_40234((class_7876)class_7923.field_41172, (class_5321)class_5321.method_29179((class_5321)class_7923.field_41172.method_46765(), (class_2960)soundEvent));
        this.pitch = pitch;
        this.volume = volume;
        this._pendingPitch = pitch;
        this._pendingVolume = volume;
        this._pendingSoundEvent = this.soundEvent;
        this.id = id;
        this.client = class_310.method_1551();
    }

    public ConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.method_40237().method_29177(), enabled, pitch, volume);
    }

    public ConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume) {
        this(id, soundEvent.comp_3319(), enabled, pitch, volume);
    }

    public ConfiguredSound(String id, class_6880<class_3414> soundEvent, boolean enabled, float pitch, float volume) {
        this(id, (class_3414)soundEvent.comp_349(), enabled, pitch, volume);
    }

    private <T extends ConfiguredSound> ArrayList<Option<?>> createDefaultOptions(T defaults) {
        Option volumeOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.volume.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.volume.description")}).build()).binding((Object)Float.valueOf(defaults.volume), () -> Float.valueOf(this.volume), val -> {
            this.volume = val.floatValue();
        }).listener((opt, val) -> {
            this._pendingVolume = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option pitchOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.pitch.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.pitch.description")}).build()).binding((Object)Float.valueOf(defaults.pitch), () -> Float.valueOf(this.pitch), val -> {
            this.pitch = val.floatValue();
        }).listener((opt, val) -> {
            this._pendingPitch = val.floatValue();
        }).controller(opt -> ((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).step((Number)Float.valueOf(0.1f))).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(2.0f))).build();
        Option soundEventOpt = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.event.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.event.description")}).build()).binding((Object)defaults.soundEvent.method_40237().method_29177().toString(), () -> this.soundEvent.method_40237().method_29177().toString(), val -> {
            this.soundEvent = class_6880.class_6883.method_40234((class_7876)class_7923.field_41172, (class_5321)class_5321.method_29179((class_5321)class_7923.field_41172.method_46765(), (class_2960)class_2960.method_12829((String)val)));
        }).listener((opt, val) -> {
            this._pendingSoundEvent = class_6880.class_6883.method_40234((class_7876)class_7923.field_41172, (class_5321)class_5321.method_29179((class_5321)class_7923.field_41172.method_46765(), (class_2960)class_2960.method_12829((String)val)));
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(class_7923.field_41172.method_42021().stream().map(class_5321::method_29177).map(class_2960::toString).toList())).build();
        return new ArrayList(List.of(volumeOpt, pitchOpt, soundEventOpt));
    }

    public <T extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(T defaults) {
        return new ArrayList();
    }

    public ButtonOption getPreviewButton() {
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43469((String)"sounds.config.preview.name", (Object[])new Object[]{""})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sounds.config.preview.option.description")})).action((a, b) -> this.playPreviewSound()).build();
    }

    public OptionGroup getOptionGroup(ConfiguredSound defaults) {
        ArrayList<Option<?>> defaultOptions = this.createDefaultOptions(defaults);
        ArrayList<Option<?>> extraOptions = this.addExtraOptions(defaults);
        ArrayList allOptions = new ArrayList(defaultOptions);
        allOptions.addAll(extraOptions);
        Option shouldPlay = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.shouldPlay.option")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.shouldPlay.option.description")}).build()).binding((Object)defaults.enabled, () -> this.enabled, val -> {
            this.enabled = val;
        }).listener((opt, val) -> allOptions.forEach(option -> option.setAvailable(val.booleanValue()))).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).yesNoFormatter()).build();
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)("sounds.config." + this.id + ".option")).method_27692(class_124.field_1073)).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)("sounds.config." + this.id + ".option.description"))}).build()).option((Option)this.getPreviewButton()).option(shouldPlay).options(allOptions).collapsed(true).build();
    }

    public final class_3414 fetchSoundEvent() {
        return (class_3414)class_7923.field_41172.method_29107(this.soundEvent.method_40237());
    }

    public void playSound() {
        block3: {
            if (this.enabled) {
                try {
                    class_3414 event = (class_3414)class_7923.field_41172.method_29107(this.soundEvent.method_40237());
                    this.playSound(event, this.pitch, this.volume);
                }
                catch (Exception ignored) {
                    if (System.currentTimeMillis() <= lastShownToast + 5000L) break block3;
                    lastShownToast = System.currentTimeMillis();
                    class_310 client = class_310.method_1551();
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47586, (class_2561)class_2561.method_43471((String)"sounds.config.play.error.title"), (class_2561)class_2561.method_43469((String)"sounds.config.play.error.description", (Object[])new Object[]{this.getId()})));
                }
            }
        }
    }

    private void playPreviewSound() {
        block2: {
            try {
                class_3414 event = (class_3414)class_7923.field_41172.method_29107(this._pendingSoundEvent.method_40237());
                this.playSound(event, this._pendingPitch, this._pendingVolume);
            }
            catch (Exception ignored) {
                if (System.currentTimeMillis() <= lastShownToast + 5000L) break block2;
                lastShownToast = System.currentTimeMillis();
                class_310 client = class_310.method_1551();
                client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47586, (class_2561)class_2561.method_43471((String)"sounds.config.preview.error.title"), (class_2561)class_2561.method_43471((String)"sounds.config.preview.error.description")));
            }
        }
    }

    private void playSound(class_3414 event, float pitch, float volume) {
        this.playSound((class_1113)class_1109.method_4757((class_3414)event, (float)pitch, (float)volume));
    }

    @Nullable
    public class_1109 getSoundInstance() {
        if (this.enabled) {
            try {
                class_3414 event = (class_3414)class_7923.field_41172.method_29107(this.soundEvent.method_40237());
                return class_1109.method_4757((class_3414)event, (float)this.pitch, (float)this.volume);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        return null;
    }

    public void playSound(class_1113 soundInstance) {
        if (this.enabled) {
            this.client.method_1483().method_4873(soundInstance);
        }
    }

    public void stopSound(class_1113 soundInstance) {
        if (this.enabled) {
            this.client.method_1483().method_4870(soundInstance);
        }
    }

    public boolean shouldPlay() {
        return this.enabled;
    }

    public class_3414 getSoundEvent() {
        return (class_3414)class_7923.field_41172.method_29107(this.soundEvent.method_40237());
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public String getId() {
        return this.id;
    }
}

