/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.TagList;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class TagPair {
    private static final Codec<class_2498> BLOCK_GROUP_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("pitch").forGetter(class_2498::method_10599), (App)Codec.FLOAT.fieldOf("volume").forGetter(class_2498::method_10597), (App)class_3414.field_41698.fieldOf("break").forGetter(class_2498::method_10595), (App)class_3414.field_41698.fieldOf("step").forGetter(class_2498::method_10594), (App)class_3414.field_41698.fieldOf("place").forGetter(class_2498::method_10598), (App)class_3414.field_41698.fieldOf("hit").forGetter(class_2498::method_10596), (App)class_3414.field_41698.fieldOf("fall").forGetter(class_2498::method_10593)).apply((Applicative)instance, class_2498::new));
    public static final Codec<TagPair> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagList.getCodec(class_7923.field_41175.method_46765()).fieldOf("keys").forGetter(TagPair::getKeys), (App)BLOCK_GROUP_CODEC.fieldOf("group").forGetter(TagPair::getGroup), (App)Codec.BOOL.fieldOf("enabled").forGetter(TagPair::isEnabled)).apply((Applicative)instance, TagPair::new));
    private final TagList<class_2248> keys;
    private class_2498 group;
    private class_2498 pendingGroup;
    private boolean enabled;

    public TagList<class_2248> getKeys() {
        return this.keys;
    }

    public class_2498 getGroup() {
        return this.group;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group) {
        this.keys = keys;
        this.group = group;
        this.pendingGroup = group;
        this.enabled = true;
    }

    public TagPair(TagList<class_2248> keys, class_2498 group, boolean enabled) {
        this(keys, group);
        this.enabled = enabled;
    }

    private void playSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)event, (float)this.group.method_10599(), (float)this.group.method_10597()));
    }

    public ButtonOption createAction(String type) {
        Consumer<Void> action = e -> {
            switch (type) {
                case "break": {
                    this.playSound(this.group.method_10595());
                    break;
                }
                case "step": {
                    this.playSound(this.group.method_10594());
                    break;
                }
                case "place": {
                    this.playSound(this.group.method_10598());
                    break;
                }
                case "hit": {
                    this.playSound(this.group.method_10596());
                    break;
                }
                case "fall": {
                    this.playSound(this.group.method_10593());
                }
            }
        };
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43469((String)"sounds.config.preview.name.brackets", (Object[])new Object[]{class_2561.method_43471((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43471((String)"sounds.config.preview.description")})).action((a, b) -> action.accept(null)).build();
    }

    private class_2960 getSoundId(class_3414 event) {
        return event.comp_3319();
    }

    public Option<String> createSoundOpt(TagPair defaults, String type) {
        Option.Builder builder = Option.createBuilder().name((class_2561)class_2561.method_43469((String)"sounds.config.event.name.brackets", (Object[])new Object[]{class_2561.method_43471((String)("sounds.config.preview." + type)).getString()})).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.event.description")}).build());
        return builder.binding((Object)(switch (type) {
            case "break" -> this.getSoundId(defaults.group.method_10595()).toString();
            case "step" -> this.getSoundId(defaults.group.method_10594()).toString();
            case "place" -> this.getSoundId(defaults.group.method_10598()).toString();
            case "hit" -> this.getSoundId(defaults.group.method_10596()).toString();
            case "fall" -> this.getSoundId(defaults.group.method_10593()).toString();
            default -> "";
        }), () -> switch (type) {
            case "break" -> this.getSoundId(this.group.method_10595()).toString();
            case "step" -> this.getSoundId(this.group.method_10594()).toString();
            case "place" -> this.getSoundId(this.group.method_10598()).toString();
            case "hit" -> this.getSoundId(this.group.method_10596()).toString();
            case "fall" -> this.getSoundId(this.group.method_10593()).toString();
            default -> "";
        }, val -> {
            class_3414 event = (class_3414)class_7923.field_41172.method_63535(class_2960.method_12829((String)val));
            switch (type) {
                case "break": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), event, this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "step": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), event, this.group.method_10598(), this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "place": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), event, this.group.method_10596(), this.group.method_10593());
                    break;
                }
                case "hit": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), event, this.group.method_10593());
                    break;
                }
                case "fall": {
                    this.group = new class_2498(this.group.method_10599(), this.group.method_10597(), this.group.method_10595(), this.group.method_10594(), this.group.method_10598(), this.group.method_10596(), event);
                }
            }
        }).listener((opt, val) -> {
            class_3414 event = (class_3414)class_7923.field_41172.method_63535(class_2960.method_12829((String)val));
            switch (type) {
                case "break": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), event, this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "step": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), event, this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "place": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), event, this.pendingGroup.method_10596(), this.pendingGroup.method_10593());
                    break;
                }
                case "hit": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), event, this.pendingGroup.method_10593());
                    break;
                }
                case "fall": {
                    this.pendingGroup = new class_2498(this.pendingGroup.method_10599(), this.pendingGroup.method_10597(), this.pendingGroup.method_10595(), this.pendingGroup.method_10594(), this.pendingGroup.method_10598(), this.pendingGroup.method_10596(), event);
                }
            }
        }).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(class_7923.field_41172.method_42021().stream().map(class_5321::method_29177).map(class_2960::toString).toList())).build();
    }

    public static class Builder {
        private final TagList<class_2248> keys = new TagList(new ArrayList());
        private class_2498 group = class_2498.field_11544;
        private boolean enabled = true;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder group(float pitch, float volume, class_3414 breakSound, class_3414 stepSound, class_3414 placeSound, class_3414 hitSound, class_3414 fallSound) {
            this.group = new class_2498(pitch, volume, breakSound, stepSound, placeSound, hitSound, fallSound);
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_2248 ... keys) {
            for (class_2248 key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(class_2248 key) {
            this.keys.add((Either<class_5321<class_2248>, class_6862<class_2248>>)Either.left((Object)((class_5321)class_7923.field_41175.method_29113((Object)key).orElseThrow(() -> new RuntimeException("TagPair.Builder: Could not find RegistryKey for " + key.toString())))));
            return this;
        }

        @SafeVarargs
        public final Builder addMultipleKeys(class_6862<class_2248> ... keys) {
            for (class_6862<class_2248> key : keys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKey(class_6862<class_2248> key) {
            this.keys.add((Either<class_5321<class_2248>, class_6862<class_2248>>)Either.right(key));
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public TagPair build() {
            return new TagPair(this.keys, this.group, this.enabled);
        }
    }
}

