/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.LootTableMineableCollector;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class HarvestToolProvider
implements IBlockComponentProvider,
class_4013 {
    public static final HarvestToolProvider INSTANCE = new HarvestToolProvider();
    public final Cache<class_2680, ImmutableList<class_1799>> resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private List<class_2248> shearableBlocks = List.of();
    public static final Map<class_2960, ToolHandler> TOOL_HANDLERS = Maps.newLinkedHashMap();
    private static final class_2561 CHECK = class_2561.method_43470((String)"\u2714");
    private static final class_2561 X = class_2561.method_43470((String)"\u2715");
    private static final class_241 ITEM_SIZE = new class_241(10.0f, 0.0f);

    public static ImmutableList<class_1799> getTool(class_2680 state, class_1937 world, class_2338 pos) {
        ImmutableList.Builder tools = ImmutableList.builder();
        for (ToolHandler handler : TOOL_HANDLERS.values()) {
            class_1799 tool = handler.test(state, world, pos);
            if (tool.method_7960()) continue;
            tools.add((Object)tool);
        }
        return tools.build();
    }

    public static synchronized void registerHandler(ToolHandler handler) {
        TOOL_HANDLERS.put(handler.getUid(), handler);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        class_1657 player = accessor.getPlayer();
        if (!config.get(JadeIds.MC_HARVEST_TOOL_CREATIVE) && (player.method_7337() || player.method_7325())) {
            return;
        }
        class_1937 level = accessor.getLevel();
        class_2338 pos = accessor.getPosition();
        class_1934 gameType = ClientProxy.getGameMode();
        if (gameType == class_1934.field_9216 && player.method_21701(level, pos, gameType)) {
            return;
        }
        class_2680 state = accessor.getBlockState();
        float destroySpeed = state.method_26214((class_1922)level, pos);
        float destroyProgress = state.method_26165(player, (class_1922)level, pos);
        if (destroySpeed < 0.0f || destroyProgress <= 0.0f) {
            if (config.get(JadeIds.MC_SHOW_UNBREAKABLE)) {
                class_5250 text = IThemeHelper.get().failure(class_2561.method_43471((String)"jade.harvest_tool.unbreakable"));
                tooltip.add(IElementHelper.get().text((class_2561)text).message(null));
            }
            return;
        }
        boolean newLine = config.get(JadeIds.MC_HARVEST_TOOL_NEW_LINE);
        List<IElement> elements = this.getText(accessor, config);
        if (elements.isEmpty()) {
            return;
        }
        elements.forEach(e -> e.message(null));
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config) {
        class_2680 state = accessor.getBlockState();
        if (!state.method_29291() && !config.get(JadeIds.MC_EFFECTIVE_TOOL)) {
            return List.of();
        }
        List tools = List.of();
        try {
            tools = (List)this.resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            Jade.LOGGER.error("Failed to get harvest tool", (Throwable)e);
        }
        if (tools.isEmpty()) {
            return List.of();
        }
        int offsetY = -3;
        boolean newLine = config.get(JadeIds.MC_HARVEST_TOOL_NEW_LINE);
        ArrayList elements = Lists.newArrayList();
        for (class_1799 tool : tools) {
            elements.add(IElementHelper.get().item(tool, 0.75f).translate(new class_241(-1.0f, (float)offsetY)).size(ITEM_SIZE).message(null));
        }
        if (!elements.isEmpty()) {
            elements.addFirst(IElementHelper.get().spacer(newLine ? -2 : 5, newLine ? 10 : 0));
            class_1657 player = accessor.getPlayer();
            boolean canHarvest = CommonProxy.isCorrectToolForDrops(state, player, accessor.getLevel(), accessor.getPosition());
            if (state.method_29291() || !canHarvest) {
                IThemeHelper t = IThemeHelper.get();
                class_5250 text = canHarvest ? t.success(CHECK) : t.danger(X);
                elements.add(IElementHelper.get().text((class_2561)text).scale(0.75f).zOffset(800).size(class_241.field_1340).translate(new class_241(-3.0f, 6.25f + (float)offsetY)));
            }
        }
        return elements;
    }

    public void method_14491(class_3300 resourceManager) {
        this.resultCache.invalidateAll();
    }

    private void tagsUpdated(class_7225.class_7874 lookupProvider, boolean client) {
        if (client) {
            this.resultCache.invalidateAll();
        } else {
            try {
                this.shearableBlocks = Collections.unmodifiableList(LootTableMineableCollector.execute((class_7225.class_7226<class_52>)lookupProvider.method_46762(class_7924.field_50079), class_1802.field_8868.method_7854()));
            }
            catch (Throwable e) {
                Jade.LOGGER.error("Failed to collect shearable blocks", e);
            }
        }
    }

    public List<class_2248> getShearableBlocks() {
        return this.shearableBlocks;
    }

    public void setShearableBlocks(Collection<class_2248> blocks) {
        ToolHandler toolHandler = TOOL_HANDLERS.get(JadeIds.JADE("shears"));
        if (toolHandler instanceof ShearsToolHandler) {
            ShearsToolHandler handler = (ShearsToolHandler)toolHandler;
            handler.setShearableBlocks(blocks);
        }
    }

    @Override
    public class_2960 getUid() {
        return JadeIds.MC_HARVEST_TOOL;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    static {
        CommonProxy.registerTagsUpdatedListener(INSTANCE::tagsUpdated);
        if (CommonProxy.isPhysicallyClient()) {
            HarvestToolProvider.registerHandler(SimpleToolHandler.create(JadeIds.JADE("pickaxe"), List.of(class_1802.field_8647, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024)));
            HarvestToolProvider.registerHandler(SimpleToolHandler.create(JadeIds.JADE("axe"), List.of(class_1802.field_8406, class_1802.field_8062, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025)));
            HarvestToolProvider.registerHandler(SimpleToolHandler.create(JadeIds.JADE("shovel"), List.of(class_1802.field_8876, class_1802.field_8776, class_1802.field_8699, class_1802.field_8250, class_1802.field_22023)));
            HarvestToolProvider.registerHandler(SimpleToolHandler.create(JadeIds.JADE("hoe"), List.of(class_1802.field_8167, class_1802.field_8431, class_1802.field_8609, class_1802.field_8527, class_1802.field_22026)));
            HarvestToolProvider.registerHandler(SimpleToolHandler.create(JadeIds.JADE("sword"), List.of(class_1802.field_8091)).addExtraBlock(class_2246.field_10211).addExtraBlock(class_2246.field_10108));
            HarvestToolProvider.registerHandler(ShearsToolHandler.getInstance());
        }
    }
}

