/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;

public class JsonConfig<T> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().enableComplexMapKeySerialization().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setStrictness(Strictness.LENIENT).create();
    private final File file;
    private final Codec<T> codec;
    private final CachedSupplier<T> configGetter;

    public JsonConfig(String fileName, Codec<T> codec, @Nullable Consumer<T> onUpdate, Supplier<T> defaultFactory) {
        this.file = new File(CommonProxy.getConfigDirectory(), fileName + (fileName.endsWith(".json") ? "" : ".json"));
        this.codec = codec;
        this.configGetter = new CachedSupplier<Object>(() -> {
            Object object;
            if (!this.file.exists()) {
                Object def = defaultFactory.get();
                this.write(this.file, def, false);
                return def;
            }
            FileReader reader = new FileReader(this.file, StandardCharsets.UTF_8);
            try {
                Object ret2 = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)reader, JsonElement.class))).getOrThrow();
                if (ret2 == null) {
                    ret2 = defaultFactory.get();
                    this.write(this.file, ret2, false);
                }
                object = ret2;
            }
            catch (Throwable ret2) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        ret2.addSuppressed(throwable);
                    }
                    throw ret2;
                }
                catch (Throwable e) {
                    Jade.LOGGER.error("Failed to read config file %s".formatted(this.file), e);
                    if (this.file.length() > 0L) {
                        try {
                            this.file.renameTo(new File(this.file.getPath() + ".invalid"));
                        }
                        catch (Exception ret2) {
                            // empty catch block
                        }
                    }
                    Object def = defaultFactory.get();
                    this.write(this.file, def, false);
                    return def;
                }
            }
            reader.close();
            return object;
        });
        this.configGetter.onUpdate = onUpdate;
        this.mkdirs(this.file);
    }

    public JsonConfig(String fileName, Codec<T> codec, @Nullable Consumer<T> onUpdate) {
        this(fileName, codec, onUpdate, () -> JadeCodecs.createFromEmptyMap(codec));
        JadeCodecs.createFromEmptyMap(codec);
    }

    public T get() {
        return this.configGetter.get();
    }

    public void save() {
        this.saveTo(this.getFile());
    }

    public void saveTo(File file) {
        this.write(file, this.get(), false);
    }

    public void write(File file, T t, boolean invalidate) {
        this.mkdirs(file);
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8);){
            writer.write(GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t).getOrThrow()));
            if (invalidate) {
                this.invalidate();
            }
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Failed to write config file %s".formatted(file), e);
        }
    }

    private void mkdirs(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
    }

    public void invalidate() {
        this.configGetter.invalidate();
    }

    public File getFile() {
        return this.file;
    }

    static class CachedSupplier<T> {
        private final Supplier<T> supplier;
        private T value;
        private Consumer<T> onUpdate;

        public CachedSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.value == null) {
                CachedSupplier cachedSupplier = this;
                synchronized (cachedSupplier) {
                    this.value = this.supplier.get();
                    T _value = this.value;
                    Objects.requireNonNull(_value);
                    if (this.onUpdate != null) {
                        this.onUpdate.accept(_value);
                    }
                }
            }
            return this.value;
        }

        public void invalidate() {
            this.value = null;
        }
    }
}

