/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources;
import java.util.List;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record WaterSensititiveEntityLuminance(List<EntityLuminance> outOfWater, List<EntityLuminance> inWater) implements EntityLuminance
{
    public static final MapCodec<WaterSensititiveEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityLuminance.LIST_CODEC.optionalFieldOf("out_of_water", List.of()).forGetter(WaterSensititiveEntityLuminance::outOfWater), (App)EntityLuminance.LIST_CODEC.optionalFieldOf("in_water", List.of()).forGetter(WaterSensititiveEntityLuminance::inWater)).apply((Applicative)instance, WaterSensititiveEntityLuminance::new));

    @NotNull
    public EntityLuminance.Type type() {
        return EntityLightSources.WATER_SENSITIVE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
        boolean submergedInWater = entity.method_5869();
        boolean shouldCareAboutWater = (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get();
        if (submergedInWater && (shouldCareAboutWater || this.outOfWater.isEmpty())) {
            return EntityLuminance.getLuminance((ItemLightSourceManager)itemLightSourceManager, (class_1297)entity, this.inWater);
        }
        return EntityLuminance.getLuminance((ItemLightSourceManager)itemLightSourceManager, (class_1297)entity, this.outOfWater);
    }
}

