/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.mehvahdjukaar.modelfix.ModelFix;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.modelfix.moonlight_configs.yacl.YACLCompat;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

public final class FabricConfigSpec
extends ConfigSpec {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final ConfigSubCategory mainEntry;
    private final File file = this.getFullPath().toFile();
    private boolean initialized = false;
    private static final boolean YACL = FabricLoader.getInstance().isModLoaded("yet-another-config-lib");
    private static final boolean CLOTH_CONFIG = FabricLoader.getInstance().isModLoaded("cloth-config");

    @ApiStatus.Internal
    public static void loadAllConfigs() {
        for (ConfigSpec spec : FabricConfigSpec.getTrackedSpecs()) {
            spec.forceLoad();
        }
    }

    public FabricConfigSpec(class_2960 name, ConfigSubCategory mainEntry, ConfigType type, Runnable changeCallback) {
        super(name, "json", FabricLoader.getInstance().getConfigDir(), type, changeCallback);
        this.mainEntry = mainEntry;
        if (this.isSynced()) {
            // empty if block
        }
    }

    public ConfigSubCategory getMainEntry() {
        return this.mainEntry;
    }

    @Override
    public boolean isLoaded() {
        return this.initialized;
    }

    @Override
    public void forceLoad() {
        if (this.isLoaded()) {
            return;
        }
        try {
            JsonElement config = null;
            if (this.file.exists() && this.file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(this.file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
                }
            }
            if (config instanceof JsonObject) {
                JsonObject jo = (JsonObject)config;
                this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
            }
            if (!this.initialized) {
                this.initialized = true;
                this.saveConfig();
                ModelFix.LOGGER.info("Loaded config {}", (Object)this.getFileName());
            }
        }
        catch (Exception e2) {
            throw new ConfigSpec.ConfigLoadingException(this, e2);
        }
    }

    public void saveConfig() {
        try (FileOutputStream stream = new FileOutputStream(this.file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            JsonObject jo = new JsonObject();
            jo.addProperty("#README", "This config file does not support comments. To see them configure it in-game using YACL or Cloth Config (or just use Forge)");
            this.mainEntry.getEntries().forEach(e -> e.saveToJson(jo));
            GSON.toJson((JsonElement)jo, (Appendable)writer);
        }
        catch (IOException e2) {
            ModelFix.LOGGER.error("Failed to save config {}:", (Object)this.getReadableName(), (Object)e2);
        }
        this.onRefresh();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent, class_2960 background) {
        if (YACL) {
            return YACLCompat.makeScreen(parent, this, background);
        }
        if (CLOTH_CONFIG) {
            // empty if block
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return CLOTH_CONFIG || YACL;
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        JsonElement config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
        this.onRefresh();
    }
}

