/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.List;
import java.util.Properties;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.features.property_reading.properties.optifine_properties.NBTProperty;
import traben.entity_texture_features.utils.ETFEntity;

public class NBTMethod
extends MathMethod {
    public NBTMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        String nbtKey = args.get(0);
        String nbtQuery = args.get(1);
        Properties properties = new Properties();
        properties.setProperty("nbt.1." + nbtKey, nbtQuery);
        NBTProperty propertyTester = NBTProperty.getPropertyOrNull((Properties)properties, (int)1);
        if (propertyTester == null) {
            EMFUtils.logError("nbt() animation function did not parse: nbt(" + nbtKey + " " + nbtQuery + "), please check your syntax.");
            throw new EMFMathException("nbt() animation function did not parse: nbt(" + nbtKey + " " + nbtQuery + "), please check your syntax.");
        }
        this.setSupplierAndOptimize(() -> {
            if (EMFAnimationEntityContext.getEMFEntity() == null) {
                return Float.NEGATIVE_INFINITY;
            }
            return MathValue.fromBoolean(propertyTester.testEntity((ETFEntity)EMFAnimationEntityContext.getEMFEntity(), false));
        });
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 2;
    }
}

