/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigCodec;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.class_3518;

public class ConfigHandler {
    private static ConfigCodec LOADED_CONFIG = new ConfigCodec(true, ConfigCodec.Legacy.DEFAULT, ConfigCodec.Features.DEFAULT, ConfigCodec.Experimental.DEFAULT);

    public static ConfigCodec getConfig() {
        return LOADED_CONFIG;
    }

    public static void load(Path path) {
        block11: {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                ConfigHandler.write(path);
            }
            try (BufferedReader reader = Files.newBufferedReader(path);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                Optional result = ConfigCodec.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result();
                if (result.isPresent()) {
                    LOADED_CONFIG = (ConfigCodec)result.get();
                    break block11;
                }
                throw new JsonParseException("Invalid codec");
            }
            catch (JsonParseException e) {
                Tectonic.LOGGER.error("Couldn't parse config file, resetting to default config");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ConfigHandler.write(path);
    }

    private static void write(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            JsonElement element = (JsonElement)ConfigCodec.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)LOADED_CONFIG).result().get();
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setIndent("  ");
            class_3518.method_43677((JsonWriter)jsonWriter, (JsonElement)element, Comparator.naturalOrder());
            writer.write(ConfigHandler.commentHack(stringWriter.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String commentHack(String json) {
        return json.replaceAll("\"__.\": \"", "// ").replaceAll("\"...__\": \"", "// ").replace("\",", "");
    }
}

