/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.datafix;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class Types {
    public static final DSL.TypeReference MEMORY_DATA = class_1208.method_59518((String)"chesttracker/memory_data");
    public static final DSL.TypeReference MEMORY_DATA_2_3_3 = class_1208.method_59518((String)"chesttracker/memory_data_2_3_3");
    private static final String VERSION_KEY = "MinecraftDataVersion";

    public static <T> Codec<T> wrapInFixer(final DSL.TypeReference type, final Codec<T> codec, final int fallbackVersion) {
        final DataFixer fixer = class_310.method_1551().method_1543();
        final int currentVersion = class_155.method_16673().method_37912().method_38494();
        return new Codec<T>(){

            public <A> DataResult<A> encode(T input, DynamicOps<A> ops, A prefix) {
                return codec.encode(input, ops, prefix).flatMap(encoded -> ops.mergeToMap(encoded, ops.createString(Types.VERSION_KEY), ops.createInt(currentVersion)));
            }

            public <A> DataResult<Pair<T, A>> decode(DynamicOps<A> ops, A input) {
                int version = ops.get(input, Types.VERSION_KEY).flatMap(arg_0 -> ops.getNumberValue(arg_0)).map(Number::intValue).result().orElse(fallbackVersion);
                Dynamic stripped = new Dynamic(ops, ops.remove(input, Types.VERSION_KEY));
                Dynamic fixedUpped = fixer.update(type, stripped, version, currentVersion);
                return codec.decode(fixedUpped);
            }
        };
    }

    public static TypeTemplate getMemoryDataType(Schema schema) {
        return DSL.fields((String)"memories", (TypeTemplate)DSL.compoundList((TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.fields((String)"items", (TypeTemplate)DSL.list((TypeTemplate)class_1208.field_5712.in(schema)))), (String)"overrides", (TypeTemplate)DSL.remainder());
    }

    public static TypeTemplate get2_3_3MemoryDataType(Schema schema) {
        return DSL.compoundList((TypeTemplate)DSL.constType((Type)DSL.string()), (TypeTemplate)DSL.fields((String)"items", (TypeTemplate)DSL.list((TypeTemplate)class_1208.field_5712.in(schema))));
    }
}

