/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.screen;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2363;
import net.minecraft.class_2377;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_3708;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4739;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.memory.counting.CountingPredicate;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.compat.Compatibility;
import red.jackf.chesttracker.impl.compat.mods.searchables.SearchablesUtil;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.config.ChestTrackerConfigScreenBuilder;
import red.jackf.chesttracker.impl.gui.screen.EditMemoryBankScreen;
import red.jackf.chesttracker.impl.gui.screen.MemoryBankManagerScreen;
import red.jackf.chesttracker.impl.gui.util.TextColours;
import red.jackf.chesttracker.impl.gui.widget.ChangeableImageButton;
import red.jackf.chesttracker.impl.gui.widget.CustomEditBox;
import red.jackf.chesttracker.impl.gui.widget.ItemButton;
import red.jackf.chesttracker.impl.gui.widget.ItemListWidget;
import red.jackf.chesttracker.impl.gui.widget.ResizeWidget;
import red.jackf.chesttracker.impl.gui.widget.VerticalScrollWidget;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.util.GuiUtil;
import red.jackf.chesttracker.impl.util.ItemStacks;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class ChestTrackerScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"chesttracker.title");
    private static final int TITLE_LEFT = 8;
    private static final int TITLE_TOP = 8;
    private static final int SEARCH_LEFT = 8;
    private static final int SEARCH_TOP = 27;
    private static final int GRID_LEFT = 7;
    private static final int GRID_TOP = 41;
    private static final int BUTTON_SIZE = 14;
    private static final int MEMORY_ICON_OFFSET = 24;
    private static final int MEMORY_ICON_SPACING = 24;
    private static final int SMALL_MENU_WIDTH = 192;
    private static final int SMALL_MENU_HEIGHT = 156;
    private static ContainerFilter containerFilter = ContainerFilter.ALL;
    private static ItemSort itemSort = ItemSort.COUNT_DESCENDING;
    private final class_437 parent;
    private int left = 0;
    private int top = 0;
    private int menuWidth;
    private int menuHeight;
    private boolean ignoreTextInput = false;
    private class_342 search;
    private ItemListWidget itemList;
    @Nullable
    private ResizeWidget resize = null;
    private VerticalScrollWidget scroll;
    private class_2960 currentMemoryKey;
    private List<class_1799> items = Collections.emptyList();

    public ChestTrackerScreen(@Nullable class_437 parent) {
        super(TITLE);
        ChestTracker.LOGGER.debug("Open Screen");
        this.parent = parent;
        this.currentMemoryKey = ProviderUtils.getPlayersCurrentKey().orElseGet(() -> ChestTracker.id("unknown"));
    }

    protected void method_25426() {
        MemoryBankImpl bank = MemoryBankAccessImpl.INSTANCE.getLoadedInternal().orElse(null);
        if (bank == null) {
            class_310.method_1551().method_1507((class_437)new MemoryBankManagerScreen(this.parent, () -> new ChestTrackerScreen(this)));
            return;
        }
        ChestTrackerConfig config = (ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance();
        int liveGridWidth = config.gui.gridWidth + 1;
        int liveGridHeight = config.gui.gridHeight + 1;
        do {
            this.menuWidth = 192 + (--liveGridWidth - 9) * 18;
        } while (this.menuWidth > this.field_22789 && liveGridWidth > 9);
        do {
            this.menuHeight = 156 + (--liveGridHeight - 6) * 18;
        } while (this.menuHeight > this.field_22790 && liveGridHeight > 6);
        this.left = (this.field_22789 - this.menuWidth) / 2;
        this.top = (this.field_22790 - this.menuHeight) / 2;
        super.method_25426();
        this.itemList = new ItemListWidget(this.left + 7, this.top + 41, liveGridWidth, liveGridHeight);
        this.scroll = (VerticalScrollWidget)this.method_37063((class_364)new VerticalScrollWidget(this.left + this.menuWidth - 19, this.top + 41, this.itemList.method_25364(), (class_2561)class_2561.method_43473()));
        this.scroll.setResponder(this.itemList::onScroll);
        this.method_37063((class_364)this.itemList);
        boolean shouldFocusSearch = this.search == null || this.search.method_25370();
        shouldFocusSearch &= config.gui.autofocusSearchBar;
        if (config.gui.showAutocomplete && Compatibility.SEARCHABLES) {
            this.search = (class_342)this.method_37063((class_364)SearchablesUtil.getEditBox(this.field_22793, this.left + 8, this.top + 27, this.menuWidth - 16, 12, this.search, () -> this.items, this::filter));
        } else {
            this.search = (class_342)this.method_37063((class_364)new CustomEditBox(this.field_22793, this.left + 8, this.top + 27, this.menuWidth - 16, 12, this.search, CustomEditBox.SEARCH_MESSAGE));
            this.search.method_47404(CustomEditBox.SEARCH_MESSAGE);
            this.search.method_1863(this::filter);
        }
        this.search.method_1868(TextColours.getTextColour());
        this.search.method_1858(false);
        this.search.method_1852(this.search.method_1882());
        this.search.method_48591(-1);
        this.ifSearchables(() -> this.method_37063((class_364)SearchablesUtil.getWrappedAutocomplete(this.search)));
        if (shouldFocusSearch) {
            this.method_48265((class_364)this.search);
        }
        this.method_37063((class_364)GuiUtil.close(this.left + this.menuWidth - 17, this.top + 5, button -> this.method_25419()));
        ((class_344)this.method_37063((class_364)new class_344(this.left + this.menuWidth - 34, this.top + 5, 14, 14, GuiUtil.twoSprite("mod_settings/button"), button -> class_310.method_1551().method_1507(ChestTrackerConfigScreenBuilder.build(this))))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.modSettings")));
        ((class_344)this.method_37063((class_364)new class_344(this.left + this.menuWidth - 51, this.top + 5, 14, 14, GuiUtil.twoSprite("change_memory_bank/button"), this::openMemoryManager))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.openMemoryManager")));
        ((class_344)this.method_37063((class_364)new class_344(this.left + this.menuWidth - 68, this.top + 5, 14, 14, GuiUtil.twoSprite("memory_bank_settings/button"), this::openMemoryBankSettings))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"chesttracker.gui.memoryBankSettings")));
        ((ChangeableImageButton)this.method_37063((class_364)new ChangeableImageButton(this.left + this.menuWidth - 85, this.top + 5, 14, 14, ChestTrackerScreen.containerFilter.sprites, class_5244.field_39003, this::cycleContainerFilter))).method_47400(this.getContainerFilterTooltip());
        ((ChangeableImageButton)this.method_37063((class_364)new ChangeableImageButton(this.left + this.menuWidth - 102, this.top + 5, 14, 14, ChestTrackerScreen.itemSort.sprites, class_5244.field_39003, this::cycleItemSort))).method_47400(this.getItemSortTooltip());
        if (config.gui.showResizeWidget) {
            this.resize = (ResizeWidget)this.method_37063((class_364)new ResizeWidget(this.left + this.menuWidth - 10, this.top + this.menuHeight - 10, this.left, this.top, 18, config.gui.gridWidth, config.gui.gridHeight, 9, 6, 18, 12, (w, h) -> {
                ChestTracker.LOGGER.debug("Resizing to {}w, {}h", w, h);
                ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.gridWidth = w;
                ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.gridHeight = h;
                ChestTrackerConfig.INSTANCE.save();
                this.method_41843();
            }));
        }
        bank.getKeys().forEach(loc -> bank.getMetadata().getVisualSettings().getOrCreateIcon((class_2960)loc));
        List<class_2960> todo = bank.getKeys().stream().sorted(Misc.bringToFront(bank.getMetadata().getVisualSettings().getKeyOrder())).toList();
        HashMap<class_2960, ItemButton> buttons = new HashMap<class_2960, ItemButton>();
        for (int index = 0; index < todo.size(); ++index) {
            class_2960 resloc = todo.get(index);
            class_1799 icon = bank.getMetadata().getVisualSettings().getOrCreateIcon(resloc);
            ItemButton button2 = (ItemButton)this.method_37063((class_364)new ItemButton(icon, this.left - 24, this.top + index * 24, b -> {
                if (buttons.containsKey(this.currentMemoryKey)) {
                    ((ItemButton)((Object)((Object)buttons.get(this.currentMemoryKey)))).setHighlighted(false);
                }
                this.currentMemoryKey = resloc;
                this.updateItems();
                ((ItemButton)((Object)((Object)buttons.get(resloc)))).setHighlighted(true);
            }, ItemButton.Background.CUSTOM));
            button2.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)resloc.toString())));
            buttons.put(resloc, button2);
            if (!this.currentMemoryKey.equals((Object)resloc)) continue;
            button2.setHighlighted(true);
        }
        this.updateItems();
    }

    private void cycleItemSort(ChangeableImageButton button) {
        itemSort = Misc.next(itemSort);
        button.method_47400(this.getItemSortTooltip());
        button.setSprites(ChestTrackerScreen.itemSort.sprites);
        this.updateItems();
    }

    private class_7919 getItemSortTooltip() {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)"chesttracker.gui.itemSort", (Object[])new Object[]{ChestTrackerScreen.itemSort.tooltip}));
    }

    private class_7919 getContainerFilterTooltip() {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)"chesttracker.gui.containerFilter", (Object[])new Object[]{ChestTrackerScreen.containerFilter.tooltip}));
    }

    private void cycleContainerFilter(ChangeableImageButton button) {
        containerFilter = Misc.next(containerFilter);
        button.method_47400(this.getContainerFilterTooltip());
        button.setSprites(ChestTrackerScreen.containerFilter.sprites);
        this.updateItems();
    }

    protected void method_48640() {
        super.method_48640();
    }

    private void updateItems() {
        MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> {
            int maxRange = bank.getMetadata().getSearchSettings().itemListRange;
            CountingPredicate predicate = this.getItemListFilter(maxRange);
            this.items = bank.getCounts(this.currentMemoryKey, predicate, bank.getMetadata().getSearchSettings().stackMergeMode, bank.getMetadata().getSearchSettings().unpackNested).stream().sorted(ChestTrackerScreen.itemSort.sort).toList();
            this.filter(this.search.method_1882());
        });
    }

    private CountingPredicate getItemListFilter(int maxRange) {
        CountingPredicate predicate = ChestTrackerScreen.containerFilter.filter;
        if (class_310.method_1551().field_1724 != null && Objects.equals(ProviderUtils.getPlayersCurrentKey().orElse(null), this.currentMemoryKey)) {
            class_243 origin = class_310.method_1551().field_1724.method_33571();
            predicate = predicate.and(CountingPredicate.within(origin, maxRange));
        }
        return predicate;
    }

    private void filter(String filter) {
        List<class_1799> filtered = Compatibility.SEARCHABLES ? SearchablesUtil.ITEM_STACK.filterEntries(this.items, filter.toLowerCase()) : this.items.stream().filter((? super T stack) -> ItemStacks.defaultPredicate(stack, filter.toLowerCase())).toList();
        this.itemList.setItems(filtered);
        ChestTrackerConfig.Gui guiConfig = ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui;
        this.scroll.setDisabled(filtered.size() <= guiConfig.gridWidth * guiConfig.gridHeight);
    }

    private boolean ifSearchables(Predicate<class_339> predicate) {
        return Compatibility.SEARCHABLES && SearchablesUtil.ifSearchables(this.search, predicate);
    }

    private void ifSearchables(Runnable ifSearchables) {
        this.ifSearchables((class_339 ignored) -> {
            ifSearchables.run();
            return false;
        });
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float tickDelta) {
        this.itemList.setHideTooltip(this.search.method_25370() && this.ifSearchables((class_339 a) -> a.method_25405((double)mouseX, (double)mouseY)));
        super.method_25394(graphics, mouseX, mouseY, tickDelta);
        graphics.method_51439(this.field_22793, this.field_22785, this.left + 8, this.top + 8, TextColours.getLabelColour(), false);
    }

    public void method_25420(@NotNull class_332 graphics, int i, int j, float f) {
        super.method_25420(graphics, i, j, f);
        graphics.method_52706(class_1921::method_62277, GuiUtil.BACKGROUND_SPRITE, this.left, this.top, this.menuWidth, this.menuHeight);
        this.ifSearchables(() -> graphics.method_52706(class_1921::method_62277, GuiUtil.SEARCH_BAR_SPRITE, this.search.method_46426() - 2, this.search.method_46427() - 2, this.search.method_25368() + 4, this.search.method_25364()));
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        this.ignoreTextInput = false;
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.search.method_25370() && this.ifSearchables((class_339 a) -> a.method_25402(mouseX, mouseY, button))) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        double finalDelta = deltaY;
        if (this.search.method_25370() && this.ifSearchables((class_339 a) -> a.method_25401(mouseX, mouseY, deltaX, finalDelta))) {
            return true;
        }
        if (this.itemList.method_25405(mouseX, mouseY) || this.scroll.method_25405(mouseX, mouseY)) {
            return this.scroll.method_25401(mouseX, mouseY, deltaX, deltaY /= (double)Math.max(1, this.itemList.getRows() - ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.gridHeight));
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.resize != null && this.resize.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    private void openMemoryManager(class_4185 ignored) {
        class_310.method_1551().method_1507((class_437)new MemoryBankManagerScreen(() -> MemoryBankAccessImpl.INSTANCE.getLoadedInternal().isEmpty() ? this.parent : this, () -> class_310.method_1551().method_1507((class_437)this)));
    }

    private void openMemoryBankSettings(class_4185 button) {
        MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> class_310.method_1551().method_1507((class_437)new EditMemoryBankScreen(this, this::updateItems, bank.getId())));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ContainerFilter {
        ALL(GuiUtil.twoSprite("container_filter/all"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.all"), (pos, memory) -> true),
        CHESTS(GuiUtil.twoSprite("container_filter/chests"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.chests"), (pos, memory) -> memory.container().map(b -> b instanceof class_4739).orElse(false)),
        BARRELS(GuiUtil.twoSprite("container_filter/barrels"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.barrels"), (pos, memory) -> memory.container().map(b -> b instanceof class_3708).orElse(false)),
        SHULKER_BOXES(GuiUtil.twoSprite("container_filter/shulker_boxes"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.shulkerBoxes"), (pos, memory) -> memory.container().map(b -> b instanceof class_2480).orElse(false)),
        HOPPERS(GuiUtil.twoSprite("container_filter/hoppers"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.hoppers"), (pos, memory) -> memory.container().map(b -> b instanceof class_2377).orElse(false)),
        FURNACES(GuiUtil.twoSprite("container_filter/furnaces"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.containerFilter.furnaces"), (pos, memory) -> memory.container().map(b -> b instanceof class_2363).orElse(false));

        private final class_8666 sprites;
        private final class_2561 tooltip;
        private final CountingPredicate filter;

        private ContainerFilter(class_8666 sprites, class_2561 tooltip, CountingPredicate filter) {
            this.sprites = sprites;
            this.tooltip = tooltip;
            this.filter = filter;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ItemSort {
        COUNT_DESCENDING(GuiUtil.twoSprite("item_sort/count_descending"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.itemSort.countDescending"), Comparator.comparingInt(class_1799::method_7947).reversed()),
        COUNT_ASCENDING(GuiUtil.twoSprite("item_sort/count_ascending"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.itemSort.countAscending"), Comparator.comparingInt(class_1799::method_7947)),
        ALPHABETICAL_DESCENDING(GuiUtil.twoSprite("item_sort/alphabetical_descending"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.itemSort.alphabeticalDescending"), Comparator.comparing(stack -> stack.method_7954().getString().toLowerCase(Locale.ROOT))),
        ALPHABETICAL_ASCENDING(GuiUtil.twoSprite("item_sort/alphabetical_ascending"), (class_2561)class_2561.method_43471((String)"chesttracker.gui.itemSort.alphabeticalAscending"), Comparator.comparing(stack -> stack.method_7954().getString().toLowerCase(Locale.ROOT)).reversed());

        private final class_8666 sprites;
        private final class_2561 tooltip;
        private final Comparator<class_1799> sort;

        private ItemSort(class_8666 sprites, class_2561 tooltip, Comparator<class_1799> sort) {
            this.sprites = sprites;
            this.tooltip = tooltip;
            this.sort = sort;
        }
    }
}

