/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.Storage;

@Environment(value=EnvType.CLIENT)
public interface MemoryBankView {
    public String id();

    public Metadata metadata();

    public List<class_2960> keys();

    @Nullable
    public MemoryKeyImpl getMemories(class_2960 var1);

    public void removeKey(class_2960 var1);

    public void remove(class_2960 var1, class_2338 var2);

    public void save();

    public static MemoryBankView of(final MemoryBankImpl bank) {
        return new MemoryBankView(){
            private final Metadata copy;
            private final List<class_2960> toRemove;
            {
                this.copy = bank.getMetadata().deepCopy();
                this.toRemove = new ArrayList<class_2960>();
            }

            @Override
            public String id() {
                return bank.getId();
            }

            @Override
            public Metadata metadata() {
                return this.copy;
            }

            @Override
            public List<class_2960> keys() {
                return this.copy.getVisualSettings().getKeyOrder();
            }

            @Override
            @Nullable
            public MemoryKeyImpl getMemories(class_2960 memoryKey) {
                return bank.getKeyInternal(memoryKey).orElse(null);
            }

            @Override
            public void removeKey(class_2960 id) {
                this.toRemove.add(id);
                this.copy.getVisualSettings().removeIcon(id);
            }

            @Override
            public void remove(class_2960 id, class_2338 pos) {
                bank.removeMemory(id, pos);
            }

            @Override
            public void save() {
                for (class_2960 key : this.toRemove) {
                    bank.removeKey(key);
                }
                bank.setMetadata(this.copy);
                Storage.save(bank);
            }
        };
    }

    public static MemoryBankView empty() {
        return new MemoryBankView(){

            @Override
            public String id() {
                return "error";
            }

            @Override
            public Metadata metadata() {
                return Metadata.blank();
            }

            @Override
            public List<class_2960> keys() {
                return Collections.emptyList();
            }

            @Override
            @Nullable
            public MemoryKeyImpl getMemories(class_2960 memoryKey) {
                return null;
            }

            @Override
            public void removeKey(class_2960 id) {
            }

            @Override
            public void remove(class_2960 id, class_2338 pos) {
            }

            @Override
            public void save() {
            }
        };
    }
}

