/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.dynamic;

import com.mojang.serialization.Codec;
import dev.imb11.sounds.api.SoundDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.class_2498;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicSoundHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicSoundHelper.class);
    protected static HashMap<String, Codec<?>> loadDirectories = new HashMap();
    protected static HashMap<String, ArrayList<?>> loadedDefinitions = new HashMap();

    protected static void declareDefinitionsToLoad(String directory, Codec<?> codec) {
        loadDirectories.put(directory, codec);
        loadedDefinitions.put(directory, new ArrayList());
    }

    protected static void clearDefinitions() {
        loadedDefinitions.values().forEach(ArrayList::clear);
    }

    public static void initialize() {
        DynamicSoundHelper.declareDefinitionsToLoad("items", SoundDefinition.getCodec(class_7923.field_41178.method_46765()));
        DynamicSoundHelper.declareDefinitionsToLoad("screens", SoundDefinition.getCodec(class_7923.field_41187.method_46765()));
    }

    public static <T> ArrayList<SoundDefinition<T>> getDefinitions(String directory) {
        return loadedDefinitions.get(directory);
    }

    public static enum BlockSoundType {
        PLACE(class_2498::method_10598),
        HIT(class_2498::method_10596),
        BREAK(class_2498::method_10595),
        FALL(class_2498::method_10593),
        STEP(class_2498::method_10594);

        private final Function<class_2498, class_3414> transformer;

        private BlockSoundType(Function<class_2498, class_3414> transformer) {
            this.transformer = transformer;
        }

        public Function<class_2498, class_3414> getTransformer() {
            return this.transformer;
        }
    }
}

