/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2335;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_251;
import net.minecraft.class_259;
import net.minecraft.class_263;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.box.BoxFace;
import team.creative.creativecore.common.util.type.list.SingletonList;
import team.creative.creativecore.common.util.unsafe.CreativeHackery;
import team.creative.creativecore.mixin.VoxelShapeAccessor;

public class BoxesVoxelShape
extends class_263 {
    public static final class_251 DISCRETE_SHAPE = new class_251(1, 1, 1){

        public boolean method_1063(int x, int y, int z) {
            return true;
        }

        public void method_1049(int x, int y, int z) {
            throw new UnsupportedOperationException();
        }

        public int method_1055(class_2350.class_2351 axis) {
            return 0;
        }

        public int method_1045(class_2350.class_2351 axis) {
            return 1;
        }

        public boolean method_1056() {
            return false;
        }
    };
    public List<ABB> boxes;

    public static BoxesVoxelShape create(List<ABB> boxes) {
        BoxesVoxelShape shape = CreativeHackery.allocateInstance(BoxesVoxelShape.class);
        shape.boxes = boxes;
        ((VoxelShapeAccessor)((Object)shape)).setShape(DISCRETE_SHAPE);
        return shape;
    }

    public static BoxesVoxelShape createVanilla(List<class_238> boxes) {
        ArrayList<ABB> converted = new ArrayList<ABB>(boxes.size());
        for (class_238 bb : boxes) {
            converted.add(new ABB(bb));
        }
        return BoxesVoxelShape.create(converted);
    }

    public static BoxesVoxelShape create(ABB box) {
        return BoxesVoxelShape.create(new SingletonList<ABB>(box));
    }

    protected BoxesVoxelShape() {
        super(null, null, 0);
    }

    public class_265 method_1096(double x, double y, double z) {
        ArrayList<ABB> boxes = new ArrayList<ABB>();
        for (ABB bb : this.boxes) {
            boxes.add(bb.moveCopy(x, y, z));
        }
        return BoxesVoxelShape.create(boxes);
    }

    public DoubleList method_1109(class_2350.class_2351 axis) {
        DoubleArrayList list = new DoubleArrayList(this.boxes.size() * 2);
        for (ABB bb : this.boxes) {
            list.add(bb.min(axis));
            list.add(bb.max(axis));
        }
        list.sort(DoubleComparators.NATURAL_COMPARATOR);
        return list;
    }

    protected double method_1099(class_2350.class_2351 axis, int index) {
        throw new UnsupportedOperationException();
    }

    public double method_1091(class_2350.class_2351 axis) {
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double method_1105(class_2350.class_2351 axis) {
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    public void method_1104(class_259.class_260 consumer) {
        for (ABB bb : this.boxes) {
            for (BoxFace face : BoxFace.values()) {
                this.forAllEdgesCorner(bb, face.corners[0], face.corners[1], consumer);
                this.forAllEdgesCorner(bb, face.corners[1], face.corners[2], consumer);
                this.forAllEdgesCorner(bb, face.corners[2], face.corners[3], consumer);
                this.forAllEdgesCorner(bb, face.corners[3], face.corners[0], consumer);
            }
        }
    }

    private void forAllEdgesCorner(ABB bb, BoxCorner corner1, BoxCorner corner2, class_259.class_260 consumer) {
        consumer.consume(bb.cornerX(corner1), bb.cornerY(corner1), bb.cornerZ(corner1), bb.cornerX(corner2), bb.cornerY(corner2), bb.cornerZ(corner2));
    }

    public void method_1089(class_259.class_260 consumer) {
        for (ABB bb : this.boxes) {
            consumer.consume(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
        }
    }

    public List<class_238> method_1090() {
        ArrayList<class_238> bbs = new ArrayList<class_238>(this.boxes.size());
        for (ABB bb : this.boxes) {
            bbs.add(bb.toVanilla());
        }
        return bbs;
    }

    public double method_35593(class_2350.class_2351 axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double min = Double.POSITIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            min = Math.min(min, bb.min(axis));
        }
        return min;
    }

    public double method_1102(class_2350.class_2351 axis, double one, double two) {
        Axis axisOne = Axis.X;
        Axis axisTwo = Axis.Z;
        double max = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            if (!bb.intersectsWithAxis(axisOne, axisTwo, one, two)) continue;
            max = Math.max(max, bb.max(axis));
        }
        return max;
    }

    protected int method_1100(class_2350.class_2351 axis, double value) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public class_3965 method_1092(class_243 pos, class_243 look, class_2338 block) {
        return ABB.clip(this.boxes, pos, look, block);
    }

    public Optional<class_243> method_33661(class_243 vec) {
        class_243 avec3 = null;
        for (ABB bb : this.boxes) {
            double d0 = class_3532.method_15350((double)vec.method_10216(), (double)bb.minX, (double)bb.maxX);
            double d1 = class_3532.method_15350((double)vec.method_10214(), (double)bb.minY, (double)bb.maxY);
            double d2 = class_3532.method_15350((double)vec.method_10215(), (double)bb.minZ, (double)bb.maxZ);
            if (avec3 != null && !(vec.method_1028(d0, d1, d2) < vec.method_1025(avec3))) continue;
            avec3 = new class_243(d0, d1, d2);
        }
        return Optional.of(avec3);
    }

    public class_265 method_20538(class_2350 direction) {
        return this;
    }

    public boolean method_1110() {
        return this.boxes.isEmpty();
    }

    public class_265 method_1097() {
        return this;
    }

    public boolean intersectsWith(class_238 bb) {
        for (ABB abb : this.boxes) {
            if (!abb.intersectsPrecise(bb)) continue;
            return true;
        }
        return false;
    }

    public boolean onlyKeepIntersecting(class_238 bb) {
        this.boxes.removeIf(x -> x.intersectsPrecise(bb));
        return !this.boxes.isEmpty();
    }

    public double method_1108(class_2350.class_2351 axis, class_238 other, double distance) {
        if (this.method_1110()) {
            return distance;
        }
        if (Math.abs(distance) < 1.0E-7) {
            return 0.0;
        }
        Axis ltAxis = Axis.get(axis);
        Axis one = ltAxis.one();
        Axis two = ltAxis.two();
        for (ABB bb : this.boxes) {
            if (distance > 0.0) {
                distance = Math.min(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
                continue;
            }
            distance = Math.max(distance, bb.calculateAxisOffset(ltAxis, one, two, other, distance));
        }
        return distance;
    }

    protected double method_1103(class_2335 cycle, class_238 other, double distance) {
        throw new UnsupportedOperationException();
    }

    public class_238 method_1107() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (ABB bb : this.boxes) {
            minX = Math.min(minX, bb.minX);
            minY = Math.min(minY, bb.minY);
            minZ = Math.min(minZ, bb.minZ);
            maxX = Math.max(maxX, bb.maxX);
            maxY = Math.max(maxY, bb.maxY);
            maxZ = Math.max(maxZ, bb.maxZ);
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public String toString() {
        return "AABBListVoxelShape[" + String.valueOf(this.boxes) + "]";
    }
}

