/*
 * Decompiled with CFR 0.152.
 */
package visuality.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import visuality.VisualityMod;
import visuality.registry.HitParticleRegistry;
import visuality.registry.VisualityParticles;
import visuality.util.ParticleUtils;
import visuality.util.ShinyArmorUtils;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    class_1309 self = (class_1309)class_1309.class.cast((Object)this);
    @Unique
    int ticksDelay = 0;

    @Shadow
    public abstract boolean method_5805();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        class_310 client = class_310.method_1551();
        if (this.method_37908().method_8608() && this.ticksDelay != 0) {
            --this.ticksDelay;
        }
        if (this.method_37908().method_8608() && this.method_5805() && client.field_1724 != null && VisualityMod.config.shinyArmorEnabled) {
            int shinyLevel = ShinyArmorUtils.getShinyLevel(this.self);
            if (client.field_1724.method_5667().equals(this.method_5667())) {
                if (!client.field_1690.method_31044().method_31034()) {
                    this.spawnSparkles(shinyLevel);
                }
            } else {
                this.spawnSparkles(shinyLevel);
            }
        }
    }

    public boolean method_5643(class_1282 source) {
        class_1297 class_12972;
        if (this.method_37908().method_8608() && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (this.ticksDelay == 0 && this.method_5805() && VisualityMod.config.hitParticlesEnabled) {
                HitParticleRegistry.ENTRIES.forEach(entry -> {
                    if (this.method_5864().equals(entry.entity())) {
                        this.ticksDelay = 10;
                        class_1799 stack = attacker.method_6047();
                        int count = this.field_5974.method_43048(3);
                        if (stack.method_57353().method_57832(class_9334.field_49636)) {
                            class_9285 data = (class_9285)stack.method_57353().method_57829(class_9334.field_49636);
                            for (class_9285.class_9287 att : data.comp_2393()) {
                                if (!att.comp_2395().equals((Object)class_5134.field_23721)) continue;
                                count = (int)((float)att.comp_2396().comp_2449() * 0.5f);
                            }
                        }
                        this.spawnHitParticles(entry.particle(), count);
                    }
                });
            }
        }
        return super.method_5643(source);
    }

    @Unique
    private void spawnHitParticles(class_2394 particle, int count) {
        float height = this.method_17682();
        height = height * 100.0f < 100.0f ? 1.0f : (height += 0.5f);
        for (int i = 0; i <= Math.min(count, 10); ++i) {
            double randomHeight = (double)this.field_5974.method_43048((int)height * 10) / 10.0;
            ParticleUtils.add(this.method_37908(), particle, this.method_23317(), this.method_23318() + 0.2 + randomHeight, this.method_23321());
        }
    }

    @Unique
    private void spawnSparkles(int shinyLevel) {
        if (shinyLevel > 0 && this.field_5974.method_43048(20 - shinyLevel) == 0) {
            double x = this.field_5974.method_43057() * 2.0f - 1.0f;
            double y = this.field_5974.method_43057();
            double z = this.field_5974.method_43057() * 2.0f - 1.0f;
            ParticleUtils.add(this.method_37908(), (class_2394)VisualityParticles.SPARKLE, this.method_23317() + x, this.method_23318() + y + 1.0, this.method_23321() + z);
        }
    }
}

