/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.util.stats;

import com.google.common.collect.Lists;
import io.github.thecsdev.betterstats.BetterStats;
import io.github.thecsdev.betterstats.api.client.badge.BSClientPlayerBadge;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUStat;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.TUtils;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public final class SUPlayerBadgeStat
extends SUStat<PlayerBadge> {
    protected final PlayerBadge playerBadge;
    protected final boolean isEmpty;
    public final int value;

    public SUPlayerBadgeStat(IStatsProvider statsProvider, PlayerBadge playerBadge) throws NullPointerException {
        super(statsProvider, Objects.requireNonNull(playerBadge.getId().orElse(null)), playerBadge.getName());
        this.playerBadge = playerBadge;
        int clientSideAward = 0;
        if (BetterStats.isClient() && playerBadge instanceof BSClientPlayerBadge) {
            Function<IStatsProvider, Integer> statCrit = ((BSClientPlayerBadge)playerBadge).getStatCriteria();
            clientSideAward = statCrit != null ? statCrit.apply(statsProvider) : 0;
        }
        this.value = statsProvider.getPlayerBadgeValue(this.getStatID()) + clientSideAward;
        this.isEmpty = this.value == 0;
    }

    public final PlayerBadge getPlayerBadge() {
        return this.playerBadge;
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public static List<SUPlayerBadgeStat> getPlayerBadgeStats(IStatsProvider statsProvider, @Nullable Predicate<SUPlayerBadgeStat> filter) {
        ArrayList<SUPlayerBadgeStat> result = new ArrayList<SUPlayerBadgeStat>();
        for (Map.Entry entry : TRegistries.PLAYER_BADGE) {
            SUPlayerBadgeStat pbStat = new SUPlayerBadgeStat(statsProvider, (PlayerBadge)entry.getValue());
            if (filter != null && !filter.test(pbStat)) continue;
            result.add(pbStat);
        }
        return result;
    }

    public static Map<String, List<SUPlayerBadgeStat>> getPlayerBadgeStatsByModGroups(IStatsProvider statsProvider, @Nullable Predicate<SUPlayerBadgeStat> filter) {
        LinkedHashMap<String, List<SUPlayerBadgeStat>> result = new LinkedHashMap<String, List<SUPlayerBadgeStat>>();
        String mcModId = "minecraft";
        result.put("minecraft", Lists.newArrayList());
        for (SUPlayerBadgeStat pbStat : SUPlayerBadgeStat.getPlayerBadgeStats(statsProvider, filter)) {
            String entityModId = pbStat.getStatID().method_12836();
            if (!result.containsKey(entityModId)) {
                result.put(entityModId, Lists.newArrayList());
            }
            Collection resultList = result.get(entityModId);
            resultList.add(pbStat);
        }
        if (((List)result.get("minecraft")).size() == 0) {
            result.remove("minecraft");
        }
        return result;
    }

    public static Map<class_2561, List<SUPlayerBadgeStat>> getPlayerBadgeStatsByModGroupsB(IStatsProvider statsProvider, @Nullable Predicate<SUPlayerBadgeStat> filter) {
        Map<String, List<SUPlayerBadgeStat>> stats = SUPlayerBadgeStat.getPlayerBadgeStatsByModGroups(statsProvider, filter);
        LinkedHashMap<class_2561, List<SUPlayerBadgeStat>> mapped = new LinkedHashMap<class_2561, List<SUPlayerBadgeStat>>();
        for (Map.Entry<String, List<SUPlayerBadgeStat>> entry : stats.entrySet()) {
            class_5250 txt = entry.getKey() != null ? TextUtils.literal((String)TUtils.getModName((String)entry.getKey())) : TextUtils.literal((String)"*");
            mapped.put((class_2561)txt, entry.getValue());
        }
        return mapped;
    }
}

