/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<L, R> {
    @Contract(pure=true)
    @NotNull
    public static <L, R> Left<L, R> left(L value) {
        return new Left(value);
    }

    @Contract(pure=true)
    @NotNull
    public static <L, R> Right<L, R> right(R value) {
        return new Right(value);
    }

    @Contract(pure=true)
    public L getLeft();

    @Contract(pure=true)
    public R getRight();

    @Contract(pure=true)
    public boolean isLeft();

    @Contract(pure=true)
    public boolean isRight();

    default public void ifLeft(@NotNull Consumer<? super L> action) {
    }

    default public void ifRight(@NotNull Consumer<? super R> action) {
    }

    public void ifLeftOrElse(@NotNull Consumer<? super L> var1, @NotNull Runnable var2);

    public void ifRightOrElse(@NotNull Consumer<? super R> var1, @NotNull Runnable var2);

    public void apply(@NotNull Consumer<? super L> var1, @NotNull Consumer<? super R> var2);

    public <NL> Either<NL, R> mapLeft(@NotNull Function<? super L, ? extends NL> var1);

    public <NR> Either<L, NR> mapRight(@NotNull Function<? super R, ? extends NR> var1);

    public <NL, NR> Either<NL, NR> map(@NotNull Function<? super L, ? extends NL> var1, @NotNull Function<? super R, ? extends NR> var2);

    public <U> U fold(@NotNull Function<? super L, ? extends U> var1, @NotNull Function<? super R, ? extends U> var2);

    @Contract(value="-> new", pure=true)
    @NotNull
    public Either<R, L> swap();

    public static final class Left<L, R>
    implements Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        @Contract(value="-> fail", pure=true)
        public R getRight() {
            throw new NoSuchElementException("No right value present");
        }

        @Override
        @Contract(value="-> true", pure=true)
        public boolean isLeft() {
            return true;
        }

        @Override
        @Contract(value="-> false", pure=true)
        public boolean isRight() {
            return false;
        }

        @Override
        public void ifLeft(@NotNull Consumer<? super L> action) {
            action.accept(this.value);
        }

        @Override
        public void ifLeftOrElse(@NotNull Consumer<? super L> leftAction, @NotNull Runnable rightAction) {
            leftAction.accept(this.value);
        }

        @Override
        public void ifRightOrElse(@NotNull Consumer<? super R> rightAction, @NotNull Runnable leftAction) {
            leftAction.run();
        }

        @Override
        public void apply(@NotNull Consumer<? super L> leftAction, @NotNull Consumer<? super R> rightAction) {
            leftAction.accept(this.value);
        }

        @Override
        public <NL> Either<NL, R> mapLeft(@NotNull Function<? super L, ? extends NL> mapper) {
            return new Left<NL, R>(mapper.apply(this.value));
        }

        @Override
        @Contract(value="_ -> this", pure=true)
        public <NR> Either<L, NR> mapRight(@NotNull Function<? super R, ? extends NR> mapper) {
            return this;
        }

        @Override
        public <NL, NR> Either<NL, NR> map(@NotNull Function<? super L, ? extends NL> leftMapper, @NotNull Function<? super R, ? extends NR> rightMapper) {
            return new Left<NL, R>(leftMapper.apply(this.value));
        }

        @Override
        public <U> U fold(@NotNull Function<? super L, ? extends U> leftMapper, @NotNull Function<? super R, ? extends U> rightMapper) {
            return leftMapper.apply(this.value);
        }

        @Override
        @NotNull
        public Either<R, L> swap() {
            return new Right(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Left left = (Left)o;
            return Objects.equals(this.value, left.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Either{left=" + this.value + "}";
        }
    }

    public static final class Right<L, R>
    implements Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        @Contract(value="-> fail", pure=true)
        public L getLeft() {
            throw new NoSuchElementException("No left value present");
        }

        @Override
        public R getRight() {
            return this.value;
        }

        @Override
        @Contract(value="-> false", pure=true)
        public boolean isLeft() {
            return false;
        }

        @Override
        @Contract(value="-> true", pure=true)
        public boolean isRight() {
            return true;
        }

        @Override
        public void ifRight(@NotNull Consumer<? super R> action) {
            action.accept(this.value);
        }

        @Override
        public void ifLeftOrElse(@NotNull Consumer<? super L> leftAction, @NotNull Runnable rightAction) {
            rightAction.run();
        }

        @Override
        public void ifRightOrElse(@NotNull Consumer<? super R> rightAction, @NotNull Runnable leftAction) {
            rightAction.accept(this.value);
        }

        @Override
        public void apply(@NotNull Consumer<? super L> leftAction, @NotNull Consumer<? super R> rightAction) {
            rightAction.accept(this.value);
        }

        @Override
        @Contract(value="_ -> this", pure=true)
        public <NL> Either<NL, R> mapLeft(@NotNull Function<? super L, ? extends NL> mapper) {
            return this;
        }

        @Override
        public <NR> Either<L, NR> mapRight(@NotNull Function<? super R, ? extends NR> mapper) {
            return new Right<L, NR>(mapper.apply(this.value));
        }

        @Override
        public <NL, NR> Either<NL, NR> map(@NotNull Function<? super L, ? extends NL> leftMapper, @NotNull Function<? super R, ? extends NR> rightMapper) {
            return new Right<L, NR>(rightMapper.apply(this.value));
        }

        @Override
        public <U> U fold(@NotNull Function<? super L, ? extends U> leftMapper, @NotNull Function<? super R, ? extends U> rightMapper) {
            return rightMapper.apply(this.value);
        }

        @Override
        @NotNull
        public Either<R, L> swap() {
            return new Left(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Right right = (Right)o;
            return Objects.equals(this.value, right.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Either{right=" + this.value + "}";
        }
    }
}

