/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.commons.event;

import dev.yumi.commons.collections.toposort.NodeSorting;
import dev.yumi.commons.collections.toposort.SortableNode;
import dev.yumi.commons.event.InvokableEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Event<I extends Comparable<? super I>, T>
implements InvokableEvent<T> {
    private final Class<? super T> type;
    private final I defaultPhaseId;
    final Function<T[], T> invokerFactory;
    final Lock lock = new ReentrantLock();
    private volatile T invoker;
    T[] listeners;
    final Map<I, PhaseData<I, T>> phases = new LinkedHashMap<I, PhaseData<I, T>>();
    final List<PhaseData<I, T>> sortedPhases = new ArrayList<PhaseData<I, T>>();

    Event(@NotNull Class<? super T> type, @NotNull I defaultPhaseId, @NotNull Function<T[], T> invokerFactory) {
        Objects.requireNonNull(type, "The class specifying the type of T in the event cannot be null.");
        Objects.requireNonNull(defaultPhaseId, "The default phase identifier of the event cannot be null.");
        Objects.requireNonNull(invokerFactory, "The function to generate the invoker implementation for T cannot be null.");
        this.type = type;
        this.defaultPhaseId = defaultPhaseId;
        this.invokerFactory = invokerFactory;
        this.listeners = (Object[])Array.newInstance(type, 0);
        this.update();
    }

    @Contract(pure=true)
    @NotNull
    public Class<? super T> type() {
        return this.type;
    }

    @Contract(pure=true)
    @NotNull
    public I defaultPhaseId() {
        return this.defaultPhaseId;
    }

    public void register(@NotNull T listener) {
        this.register(this.defaultPhaseId, listener);
    }

    public void register(@NotNull I phaseIdentifier, @NotNull T listener) {
        Objects.requireNonNull(phaseIdentifier, "Cannot register a listener for a null phase.");
        Objects.requireNonNull(listener, "Cannot register a null listener.");
        this.lock.lock();
        try {
            this.getOrCreatePhase(phaseIdentifier, true).addListener(listener);
            this.rebuildInvoker(this.listeners.length + 1);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseOrdering(@NotNull I firstPhase, @NotNull I secondPhase) {
        Objects.requireNonNull(firstPhase, "Tried to order a null phase.");
        Objects.requireNonNull(secondPhase, "Tried to order a null phase.");
        if (firstPhase.equals(secondPhase)) {
            throw new IllegalArgumentException("Cannot make a phase depend on itself.");
        }
        this.lock.lock();
        try {
            PhaseData<I, T> first = this.getOrCreatePhase(firstPhase, false);
            PhaseData<I, T> second = this.getOrCreatePhase(secondPhase, false);
            PhaseData.link(first, second);
            this.sortPhases();
            this.rebuildInvoker(this.listeners.length);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public T invoker() {
        return this.invoker;
    }

    PhaseData<I, T> getOrCreatePhase(@NotNull I id, boolean sortIfCreate) {
        PhaseData<I, Object> phase = this.phases.get(id);
        if (phase == null) {
            phase = new PhaseData<I, T>(id, this.type);
            this.phases.put(id, phase);
            this.sortedPhases.add(phase);
            if (sortIfCreate) {
                this.sortPhases();
            }
        }
        return phase;
    }

    void sortPhases() {
        NodeSorting.sort(this.sortedPhases, "event phases");
    }

    void rebuildInvoker(int newLength) {
        if (this.sortedPhases.size() == 1) {
            this.listeners = this.sortedPhases.get((int)0).listeners;
        } else {
            Object[] newListeners = (Object[])Array.newInstance(this.type, newLength);
            int nextStart = 0;
            for (PhaseData<I, T> phase : this.sortedPhases) {
                int phaseListenersCount = phase.listeners.length;
                System.arraycopy(phase.listeners, 0, newListeners, nextStart, phaseListenersCount);
                nextStart += phaseListenersCount;
            }
            this.listeners = newListeners;
        }
        this.update();
    }

    void update() {
        this.invoker = this.invokerFactory.apply((T[][])Arrays.copyOf(this.listeners, this.listeners.length));
    }

    public String toString() {
        return "Event{type=" + this.type + ", defaultPhaseId=" + this.defaultPhaseId + ", invoker=" + this.invoker + ", listeners=" + Arrays.toString(this.listeners) + ", phases=" + this.phases + ", sortedPhases=" + this.sortedPhases + "}";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @ApiStatus.Internal
    static class PhaseData<I, T>
    extends SortableNode<I, PhaseData<I, T>> {
        private final I id;
        T[] listeners;

        PhaseData(@NotNull I id, @NotNull Class<? super T> listenerType) {
            Objects.requireNonNull(id);
            this.id = id;
            this.listeners = (Object[])Array.newInstance(listenerType, 0);
        }

        @Override
        @NotNull
        public I getId() {
            return this.id;
        }

        void addListener(@NotNull T listener) {
            int oldLength = this.listeners.length;
            this.listeners = Arrays.copyOf(this.listeners, oldLength + 1);
            this.listeners[oldLength] = listener;
        }
    }
}

