/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.controller.ControllerInfo;
import dev.isxander.controlify.controller.ECSComponent;
import dev.isxander.controlify.controller.GamepadControllerConfig;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.controller.JoystickControllerConfig;
import dev.isxander.controlify.controller.battery.BatteryLevelComponent;
import dev.isxander.controlify.controller.dualsense.DualSenseComponent;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.haptic.HDHapticComponent;
import dev.isxander.controlify.controller.haptic.SimpleHapticComponent;
import dev.isxander.controlify.controller.impl.ConfigImpl;
import dev.isxander.controlify.controller.impl.ECSEntityImpl;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.keyboard.NativeKeyboardComponent;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controller.rumble.TriggerRumbleComponent;
import dev.isxander.controlify.controller.serialization.ConfigHolder;
import dev.isxander.controlify.controller.serialization.IConfig;
import dev.isxander.controlify.controller.touchpad.TouchpadComponent;
import dev.isxander.controlify.driver.Driver;
import dev.isxander.controlify.utils.CUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import org.apache.commons.lang3.SerializationException;
import org.jetbrains.annotations.NotNull;

public class ControllerEntity
extends ECSEntityImpl {
    private final ControllerInfo info;
    private final List<Driver> drivers;

    public ControllerEntity(ControllerInfo info, List<Driver> drivers) {
        this.info = info;
        this.drivers = drivers;
        this.setComponent(new ConfigImpl<GenericControllerConfig>(GenericControllerConfig::new, GenericControllerConfig.class));
        for (Driver driver : Lists.reverse(drivers)) {
            driver.addComponents(this);
        }
        this.getAllComponents().values().forEach(ECSComponent::finalise);
    }

    public ControllerInfo info() {
        return this.info;
    }

    @NotNull
    public String name() {
        String nickname = this.genericConfig().config().nickname;
        if (nickname != null) {
            return nickname;
        }
        String friendlyName = this.info().type().friendlyName();
        if (friendlyName != null) {
            return friendlyName;
        }
        return this.info().driverName();
    }

    public ImmutableList<Driver> drivers() {
        return ImmutableList.copyOf(this.drivers);
    }

    public Optional<InputComponent> input() {
        return this.getComponent(InputComponent.ID);
    }

    public Optional<RumbleComponent> rumble() {
        return this.getComponent(RumbleComponent.ID);
    }

    public Optional<TriggerRumbleComponent> triggerRumble() {
        return this.getComponent(TriggerRumbleComponent.ID);
    }

    public Optional<GyroComponent> gyro() {
        return this.getComponent(GyroComponent.ID);
    }

    public Optional<TouchpadComponent> touchpad() {
        return this.getComponent(TouchpadComponent.ID);
    }

    public Optional<BatteryLevelComponent> batteryLevel() {
        return this.getComponent(BatteryLevelComponent.ID);
    }

    public Optional<HDHapticComponent> hdHaptics() {
        return this.getComponent(HDHapticComponent.ID);
    }

    public Optional<SimpleHapticComponent> simpleHaptics() {
        return this.getComponent(SimpleHapticComponent.ID);
    }

    public Optional<DualSenseComponent> dualSense() {
        return this.getComponent(DualSenseComponent.ID);
    }

    public IConfig<GenericControllerConfig> genericConfig() {
        return (IConfig)this.getComponent(GenericControllerConfig.ID).orElseThrow();
    }

    public Optional<IConfig<GamepadControllerConfig>> gamepadConfig() {
        return this.getComponent(GamepadControllerConfig.ID);
    }

    public Optional<IConfig<JoystickControllerConfig>> joystickConfig() {
        return this.getComponent(JoystickControllerConfig.ID);
    }

    public Optional<BluetoothDeviceComponent> bluetooth() {
        return this.getComponent(BluetoothDeviceComponent.ID);
    }

    public Optional<NativeKeyboardComponent> nativeKeyboard() {
        return this.getComponent(NativeKeyboardComponent.ID);
    }

    public Map<class_2960, IConfig<?>> getAllConfigs() {
        HashMap configs = new HashMap();
        this.getAllComponents().forEach((id, component) -> {
            if (component instanceof IConfig) {
                IConfig config = (IConfig)component;
                configs.put((class_2960)id, config);
            }
            if (component instanceof ConfigHolder) {
                ConfigHolder configHolder = (ConfigHolder)((Object)component);
                configs.put((class_2960)id, configHolder.config());
            }
        });
        return configs;
    }

    public void serializeToObject(JsonObject object, Gson gson) throws SerializationException {
        for (Map.Entry<class_2960, IConfig<?>> entry : this.getAllConfigs().entrySet()) {
            class_2960 key = entry.getKey();
            IConfig<?> config = entry.getValue();
            object.add(key.toString(), config.serialize(gson, this));
        }
    }

    public void deserializeFromObject(JsonObject object, Gson gson) throws SerializationException {
        for (Map.Entry<class_2960, IConfig<?>> entry : this.getAllConfigs().entrySet()) {
            class_2960 key = entry.getKey();
            IConfig<?> config = entry.getValue();
            JsonElement element = object.remove(key.toString());
            if (element != null) {
                config.deserialize(element, gson, this);
                continue;
            }
            CUtil.LOGGER.warn("Could not find component config {} whilst deserializing. Ignoring.", (Object)key);
        }
    }

    public void resetToDefaultConfig() {
        for (IConfig<?> config : this.getAllConfigs().values()) {
            config.resetToDefault();
        }
    }

    public void close() {
        this.drivers.forEach(Driver::close);
    }
}

