/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2384;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_481;
import net.minecraft.class_5250;
import net.minecraft.class_636;
import net.minecraft.class_758;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import net.minecraft.class_8170;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.JadeIds;
import snownee.jade.api.TraceableException;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.ColorPalette;
import snownee.jade.api.ui.IBoxElement;
import snownee.jade.api.ui.ScreenDirection;
import snownee.jade.api.ui.TooltipRect;
import snownee.jade.conditional_key_mapping.ConditionalKeyMapping;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.WailaExceptionHandler;

public final class JadeClient {
    public static final class_370.class_9037 JADE_PLEASE_WAIT = new class_370.class_9037(2000L);
    public static final class_304[] profiles = new class_304[4];
    public static class_304 openConfig;
    public static class_304 showOverlay;
    public static class_304 toggleLiquid;
    public static class_304 showDetails;
    public static class_304 narrate;
    public static class_304 showRecipes;
    public static class_304 showUses;
    private static final Cache<class_1792.class_9635, class_1792.class_9635> hideModName;
    private static boolean translationChecked;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void init() {
        openConfig = ClientProxy.registerKeyBinding("config", 320);
        showOverlay = ClientProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientProxy.registerDetailsKeyBinding();
        for (int i = 0; i < 4; ++i) {
            JadeClient.profiles[i] = ClientProxy.registerKeyBinding("profile." + i, class_3675.field_16237.method_1444());
        }
        ClientProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        IWailaConfig.General general;
        while (openConfig.method_1436()) {
            Jade.invalidateConfig();
            ItemStorageProvider.targetCache.invalidateAll();
            ItemStorageProvider.containerCache.invalidateAll();
            class_310.method_1551().method_1507((class_437)new HomeConfigScreen(null));
        }
        while (showOverlay.method_1436()) {
            general = IWailaConfig.get().general();
            IWailaConfig.DisplayMode mode = general.getDisplayMode();
            if (mode != IWailaConfig.DisplayMode.TOGGLE) continue;
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && Jade.history().hintOverlayToggle) {
                class_310.method_1551().method_44714().method_44736((class_2561)class_2561.method_43471((String)"toast.jade.toggle_hint.1"), false);
                class_310.method_1551().method_44714().method_44736((class_2561)class_2561.method_43469((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.method_16007()}), false);
                Jade.history().hintOverlayToggle = false;
            }
            IWailaConfig.get().save();
        }
        while (toggleLiquid.method_1436()) {
            general.setDisplayFluids(!(general = IWailaConfig.get().general()).shouldDisplayFluids());
            IWailaConfig.get().save();
        }
        while (narrate.method_1436()) {
            IWailaConfig.Accessibility accessibility = IWailaConfig.get().accessibility();
            if (accessibility.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                accessibility.toggleTTS();
                if (accessibility.shouldEnableTextToSpeech() && Jade.history().hintNarratorToggle) {
                    class_310.method_1551().method_44714().method_44736((class_2561)class_2561.method_43471((String)"toast.jade.tts_hint.1"), false);
                    class_310.method_1551().method_44714().method_44736((class_2561)class_2561.method_43469((String)"toast.jade.tts_hint.2", (Object[])new Object[]{narrate.method_16007()}), false);
                    Jade.history().hintNarratorToggle = false;
                }
                IWailaConfig.get().save();
                continue;
            }
            if (WailaTickHandler.instance().rootElement == null) continue;
            WailaTickHandler.narrate(WailaTickHandler.instance().rootElement.getTooltip(), false);
        }
        if (Jade.rootConfig().isEnableProfiles()) {
            for (int i = 0; i < 4; ++i) {
                while (profiles[i].method_1436()) {
                    Jade.useProfile(i);
                }
            }
        }
    }

    public static void onGui(class_437 screen) {
        if (!translationChecked && screen instanceof class_442 && CommonProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (class_2960 id : WailaClientRegistration.instance().getConfigKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.method_12836(), id.method_12832());
                if (class_1074.method_4663((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(String.join((CharSequence)",", keys)));
            }
        }
    }

    public static void hideModNameIn(class_1792.class_9635 context) {
        hideModName.put((Object)context, (Object)context);
    }

    public static void appendModName(List<class_2561> tooltip, class_1799 stack, class_1792.class_9635 tooltipContext, class_1836 flag) {
        String name;
        if (!IWailaConfig.get().general().showItemModNameTooltip() || hideModName.getIfPresent((Object)tooltipContext) != null) {
            return;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_481) {
            class_481 screen = (class_481)class_4372;
            if (!(screen.field_2787 == null || screen.field_2787.method_7677() != stack || class_481.field_2896.method_47312() == class_1761.class_7916.field_41052 && flag.method_47370())) {
                return;
            }
        }
        try {
            name = ModIdentification.getModName(stack);
        }
        catch (Throwable e) {
            WailaExceptionHandler.handleErr(TraceableException.create(e, class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836()), null, tooltip::add);
            return;
        }
        tooltip.add((class_2561)class_2561.method_43470((String)name).method_27696(IWailaConfig.get().formatting().getItemModNameStyle()));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(class_239 hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (WailaClientRegistration.instance().maybeLowVisionUser() || !IWailaConfig.get().general().getBuiltinCamouflage()) {
            return accessor;
        }
        if (accessor instanceof BlockAccessor) {
            class_2680 state;
            BlockAccessor target = (BlockAccessor)accessor;
            class_1657 player = accessor.getPlayer();
            if (player.method_7337() || player.method_7325()) {
                return accessor;
            }
            WailaClientRegistration client = WailaClientRegistration.instance();
            if (target.getBlock() instanceof class_2281 && (state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState())) != target.getBlockState()) {
                return client.blockAccessor().from(target).blockState(state).build();
            }
            BlockAccessor.Builder builder = client.blockAccessor().from(target).blockEntity(() -> null);
            if (target.getBlock() instanceof class_2384) {
                class_2248 block = ((class_2384)target.getBlock()).method_10271();
                return builder.blockState(block.method_9564()).build();
            }
            if (target.getBlock() == class_2246.field_27879) {
                class_2248 block = class_2246.field_10491;
                return builder.blockState(block.method_9564()).build();
            }
            class_2248 block = target.getBlock();
            if (block instanceof class_8170) {
                class_8170 brushable = (class_8170)block;
                block = brushable.method_49810();
                return builder.blockState(block.method_9564()).build();
            }
        }
        return accessor;
    }

    @Nullable
    public static Accessor<?> limitMobEffectFog(class_239 hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor == null) {
            return null;
        }
        class_1657 player = accessor.getPlayer();
        class_310 mc = class_310.method_1551();
        class_765 lightTexture = mc.field_1773.method_22974();
        float darknessEffectScale = ((Double)mc.field_1690.method_42472().method_41753()).floatValue();
        float gamma = lightTexture.method_42597(1.0f) * darknessEffectScale;
        if ((gamma = lightTexture.method_42596((class_1309)player, gamma, 1.0f)) > 0.15f && accessor.getLevel().method_22339(class_2338.method_49638((class_2374)accessor.getHitResult().method_17784())) < 7) {
            return null;
        }
        class_758.class_7286 fogFunction = class_758.method_42588((class_1297)player, (float)1.0f);
        if (fogFunction == null) {
            return accessor;
        }
        class_758.class_7285 fogData = new class_758.class_7285(class_758.class_4596.field_20946);
        fogFunction.method_42591(fogData, (class_1309)player, player.method_6112(fogFunction.method_42590()), Math.max(32.0f, mc.field_1773.method_3193()), 1.0f);
        float dist = (fogData.field_38340 + fogData.field_38341) * 0.5f;
        if (accessor.getHitResult().method_24801((class_1297)player) > (double)(dist * dist)) {
            return null;
        }
        return accessor;
    }

    public static void drawBreakingProgress(IBoxElement rootElement, TooltipRect rect, class_332 guiGraphics, Accessor<?> accessor) {
        boolean roundCorner;
        if (!IWailaConfig.get().plugin().get(JadeIds.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        if (!Float.isNaN(rootElement.getBoxProgress())) {
            progressAlpha = 0.0f;
            return;
        }
        class_310 mc = class_310.method_1551();
        class_636 playerController = mc.field_1761;
        if (playerController == null || mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        class_2338 pos = playerController.field_3714;
        class_2680 state = mc.field_1687.method_8320(pos);
        if (playerController.method_2923()) {
            canHarvest = CommonProxy.isCorrectToolForDrops(state, (class_1657)mc.field_1724, (class_1937)mc.field_1687, pos);
        } else if (progressAlpha == 0.0f) {
            return;
        }
        Theme theme = IThemeHelper.get().theme();
        ColorPalette colors = theme.tooltipStyle.boxProgressColors;
        int color = canHarvest ? colors.normal() : colors.failure();
        float top = rootElement.getCachedSize().field_1342;
        float width = rootElement.getCachedSize().field_1343;
        boolean bl = roundCorner = !IWailaConfig.get().overlay().getSquare();
        if (roundCorner && theme.tooltipStyle instanceof BoxStyle.GradientBorder) {
            top += 1.0f;
        }
        progressAlpha += mc.method_61966().method_60636() * (playerController.method_2923() ? 0.1f : -0.1f);
        if (playerController.method_2923()) {
            progressAlpha = Math.min(progressAlpha, 0.6f);
            float progress = state.method_26165((class_1657)mc.field_1724, (class_1922)mc.field_1724.method_37908(), pos);
            if (playerController.field_3715 + progress >= 1.0f) {
                savedProgress = 1.0f;
                progressAlpha = 1.0f;
            } else {
                progress = playerController.field_3715 + mc.method_61966().method_60637(false) * progress;
                savedProgress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
            }
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        if (progressAlpha == 0.0f) {
            return;
        }
        color = IWailaConfig.Overlay.applyAlpha(color, progressAlpha);
        float offset0 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.UP);
        float offset1 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.RIGHT);
        float offset2 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.DOWN);
        float offset3 = theme.tooltipStyle.boxProgressOffset(ScreenDirection.LEFT);
        DisplayHelper.fill(guiGraphics, offset3, top - 1.0f + offset0, offset3 + (width += offset1 - offset3) * savedProgress, top + offset2, color);
    }

    public static class_5250 format(String s, Object ... objects) {
        try {
            return class_2561.method_43470((String)MessageFormat.format((String)class_1074.method_4662((String)s, (Object[])new Object[0]), (Object[])objects));
        }
        catch (Exception e) {
            return class_2561.method_43469((String)s, (Object[])objects);
        }
    }

    public static void pleaseWait() {
        class_370.method_27024((class_374)class_310.method_1551().method_1566(), (class_370.class_9037)JADE_PLEASE_WAIT, (class_2561)class_2561.method_43471((String)"toast.jade.please_wait.1"), (class_2561)class_2561.method_43471((String)"toast.jade.please_wait.2"));
    }

    public static Runnable recoverKeysAction(Predicate<class_304> predicate) {
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
            if (!predicate.test(keyMapping)) continue;
            keyMapBuilder.put((Object)keyMapping, (Object)ClientProxy.getBoundKeyOf(keyMapping));
        }
        ImmutableMap keyMap = keyMapBuilder.build();
        return () -> keyMap.forEach(class_304::method_1422);
    }

    public static void refreshKeyState() {
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        for (class_304 keyMapping : profiles) {
            ConditionalKeyMapping.set(keyMapping, enabled);
        }
    }

    static {
        hideModName = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    }
}

