/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.emf;

import java.util.List;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.utils.EMFUtils;

public class CatchMethod
extends MathMethod {
    public CatchMethod(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        MathComponent x = MathExpressionParser.getOptimizedExpression(args.get(0), false, calculationInstance);
        MathComponent c = MathExpressionParser.getOptimizedExpression(args.get(1), false, calculationInstance);
        String print = args.size() == 3 && !args.get(2).isBlank() ? args.get(2) : null;
        this.setSupplierAndOptimize(() -> {
            try {
                float result = x.getResult();
                if (Float.isNaN(result)) {
                    if (print != null) {
                        EMFUtils.log("print: catch(" + print + ") found NaN in x.");
                    }
                    return c.getResult();
                }
                return result;
            }
            catch (Exception e) {
                if (print != null) {
                    EMFUtils.log("print: catch(" + print + ") found Exception in x: " + e.getMessage());
                }
                return c.getResult();
            }
        }, List.of(x, c));
    }

    @Override
    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 2 || argCount == 3;
    }
}

