/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.client.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.debugify.Debugify;
import dev.isxander.debugify.fixes.BugFixData;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class BugFixDescriptionCache {
    private static final Path file = FabricLoader.getInstance().getConfigDir().resolve("debugify-descriptions.json");
    private static final Gson gson = new Gson();
    private final Map<String, String> descriptionHolder = new HashMap<String, String>();
    private final String url = "https://bugs.mojang.com/rest/api/2/issue/%s";

    public boolean loadDescriptions() {
        if (Files.notExists(file, new LinkOption[0])) {
            return false;
        }
        try {
            String json = Files.readString(file);
            ((JsonObject)gson.fromJson(json, JsonObject.class)).entrySet().forEach(entry -> this.descriptionHolder.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void cacheMissingDescriptions() {
        ExecutorService executor = Executors.newFixedThreadPool(4, r -> new Thread(r, "Debugify Description Cache"));
        HttpClient client = HttpClient.newHttpClient();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (BugFixData bugFix : Debugify.CONFIG.getBugFixes().keySet()) {
            String id = bugFix.bugId();
            if (this.descriptionHolder.containsKey(id)) continue;
            Debugify.LOGGER.info("Caching description for bug {}", (Object)id);
            futures.add(CompletableFuture.runAsync(() -> this.cacheBugDescription(client, id), executor));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
            this.save();
            executor.shutdown();
        });
    }

    private void cacheBugDescription(HttpClient client, String bugId) {
        try {
            HttpRequest request = HttpRequest.newBuilder(new URI(String.format("https://bugs.mojang.com/rest/api/2/issue/%s", bugId))).setHeader("User-Agent", "Debugify/%s mod https://github.com/isXander/Debugify/blob/1.20/src/client/java/dev/isxander/debugify/client/utils/BugFixDescriptionCache.java".formatted(Debugify.VERSION.getFriendlyString())).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                Debugify.LOGGER.error("Description Cache fail: HTTP status {} - {}", (Object)response.statusCode(), (Object)response.body());
                return;
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            JsonObject fields = json.getAsJsonObject("fields");
            String summary = fields.get("summary").getAsString();
            this.descriptionHolder.put(bugId, summary);
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void save() {
        try {
            Files.deleteIfExists(file);
            JsonObject json = new JsonObject();
            this.descriptionHolder.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
            Files.createFile(file, new FileAttribute[0]);
            Files.writeString(file, (CharSequence)gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String get(String id) {
        return this.descriptionHolder.get(id);
    }

    public boolean has(String id) {
        return this.descriptionHolder.containsKey(id);
    }
}

