/*
 * Decompiled with CFR 0.152.
 */
package com.dimaskama.orthocamera.client.config;

import com.dimaskama.orthocamera.client.OrthoCamera;
import com.dimaskama.orthocamera.client.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;

public abstract class JsonConfig
implements Config {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final transient String path;
    private final transient String defaultPath;

    public JsonConfig(String path, String defaultPath) {
        this.path = path;
        this.defaultPath = defaultPath;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    @Override
    public void loadOrCreate() {
        File file = new File(this.getPath());
        if (!file.exists()) {
            if (this.tryLoadDefault()) {
                return;
            }
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                OrthoCamera.LOGGER.warn("Can't create config: " + file.getAbsolutePath());
                return;
            }
            try {
                this.saveWithoutCatch();
            }
            catch (IOException e) {
                OrthoCamera.LOGGER.warn("Exception occurred while writing new config. ", (Throwable)e);
            }
        } else {
            this.load(file);
        }
    }

    protected boolean tryLoadDefault() {
        File defaultFile = new File(this.defaultPath);
        if (defaultFile.exists()) {
            this.load(defaultFile);
            return true;
        }
        return false;
    }

    private void load(File file) {
        try (FileReader f = new FileReader(file);){
            this.deserialize(JsonParser.parseReader((Reader)f));
        }
        catch (Exception e) {
            OrthoCamera.LOGGER.warn("Exception occurred while reading config. ", (Throwable)e);
        }
    }

    protected void deserialize(JsonElement element) {
        JsonConfig c = (JsonConfig)GSON.fromJson(element, this.getClass());
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                field.set(this, field.get(c));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void save() {
        this.save(true);
    }

    public void save(boolean log) {
        try {
            this.saveWithoutCatch();
            if (log) {
                OrthoCamera.LOGGER.info("Config saved: " + this.getPath());
            }
        }
        catch (IOException e) {
            OrthoCamera.LOGGER.warn("Exception occurred while saving config. ", (Throwable)e);
        }
    }

    @Override
    public void saveWithoutCatch() throws IOException {
        try (FileWriter w = new FileWriter(this.getPath());){
            GSON.toJson(this.serialize(), (Appendable)w);
        }
    }

    protected JsonElement serialize() {
        return GSON.toJsonTree((Object)this);
    }

    public void reset() {
        try {
            JsonConfig m = (JsonConfig)this.getClass().getConstructor(String.class, String.class).newInstance(this.getPath(), this.getDefaultPath());
            m.tryLoadDefault();
            for (Field field : this.getClass().getDeclaredFields()) {
                try {
                    field.set(this, field.get(m));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            OrthoCamera.LOGGER.error("Can't call config constructor. ", (Throwable)e);
        }
    }
}

