/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.command;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.config.Config;
import cn.alini.craftaudit.event.block.BlockInspectListener;
import cn.alini.craftaudit.rollback.RollbackService;
import cn.alini.craftaudit.rollback.UndoManager;
import cn.alini.craftaudit.storage.Database;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="craftaudit")
public final class CraftauditCommands {
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(\\d+)([smhdSMHD])$");

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"craftaudit").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"status").executes(ctx -> CraftauditCommands.report((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"inspect").executes(ctx -> CraftauditCommands.toggleAudit((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"log").executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"blocklog").executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(Commands.m_82127_((String)"near").then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(Commands.m_82127_((String)"rollback").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))))).then(Commands.m_82127_((String)"restore").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), null))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"type")))))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))))).then(Commands.m_82127_((String)"purge").then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.purge((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time")))))).then(Commands.m_82127_((String)"undo").executes(ctx -> CraftauditCommands.undo((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"help").executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u6307\u4ee4\u5217\u8868\uff1a\n\u00a7b/craftaudit status \u00a77- \u663e\u793a\u63d2\u4ef6\u72b6\u6001\n\u00a7b/craftaudit inspect \u00a77- \u5207\u6362\u5ba1\u8ba1\u6a21\u5f0f\n\u00a7b/craftaudit log [page] \u00a77- \u67e5\u770b\u4ea4\u4e92\u65e5\u5fd7\n\u00a7b/craftaudit blocklog [page] \u00a77- \u67e5\u770b\u65b9\u5757\u65e5\u5fd7\n\u00a7b/craftaudit near <radius> <time> [page] \u00a77- \u67e5\u770b\u9644\u8fd1\u65b9\u5757\u65e5\u5fd7\n\u00a7b/craftaudit rollback <player> <time> [radius] \u00a77- \u56de\u6eda\u73a9\u5bb6\u7834\u574f\u7684\u65b9\u5757\n\u00a7b/craftaudit restore <time> [radius] [type] \u00a77- \u6062\u590d\u7834\u574f/\u51fb\u6740\u8bb0\u5f55\uff08\u652f\u6301 type \u8fc7\u6ee4\uff09\n\u00a7b/craftaudit purge <time> \u00a77- \u6e05\u7406\u65e9\u4e8e\u6307\u5b9a\u65f6\u95f4\u7684\u65e5\u5fd7\uff08\u4e0d\u53ef\u64a4\u9500\uff09\n\u00a7b/craftaudit undo \u00a77- \u64a4\u9500\u4e0a\u6b21\u56de\u6eda/\u6062\u590d\n\n\u00a7b/ca ... \u00a77- /craftaudit \u7684\u7b80\u5199"), false);
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ca").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"i").executes(ctx -> CraftauditCommands.toggleAudit((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"log").executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.inspectAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"blocklog").executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.inspectBlockAudit((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))).then(Commands.m_82127_((String)"near").then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> CraftauditCommands.near((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))))))).then(Commands.m_82127_((String)"rollback").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10))).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.rollback((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius")))))))).then(Commands.m_82127_((String)"restore").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)256)).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), null))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), StringArgumentType.getString((CommandContext)ctx, (String)"type")))))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.restore((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time"), 10, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))))).then(Commands.m_82127_((String)"purge").then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> CraftauditCommands.purge((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"time")))))).then(Commands.m_82127_((String)"undo").executes(ctx -> CraftauditCommands.undo((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"help").executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u6307\u4ee4\u5217\u8868\uff1a\n\u00a7b/ca status \u00a77- \u663e\u793a\u63d2\u4ef6\u72b6\u6001\n\u00a7b/ca i \u00a77- \u5207\u6362\u5ba1\u8ba1\u6a21\u5f0f\n\u00a7b/ca log [page] \u00a77- \u67e5\u770b\u4ea4\u4e92\u65e5\u5fd7\n\u00a7b/ca blocklog [page] \u00a77- \u67e5\u770b\u65b9\u5757\u65e5\u5fd7\n\u00a7b/ca near <radius> <time> [page] \u00a77- \u67e5\u770b\u9644\u8fd1\u65b9\u5757\u65e5\u5fd7\n\u00a7b/ca rollback <player> <time> [radius] \u00a77- \u56de\u6eda\u73a9\u5bb6\u7834\u574f\u7684\u65b9\u5757\n\u00a7b/ca restore <time> [radius] [type] \u00a77- \u6062\u590d\u7834\u574f/\u51fb\u6740\u8bb0\u5f55\uff08\u652f\u6301 type \u8fc7\u6ee4\uff09\n\u00a7b/ca purge <time> \u00a77- \u6e05\u7406\u65e9\u4e8e\u6307\u5b9a\u65f6\u95f4\u7684\u65e5\u5fd7\uff08\u4e0d\u53ef\u64a4\u9500\uff09\n\u00a7b/ca undo \u00a77- \u64a4\u9500\u4e0a\u6b21\u56de\u6eda/\u6062\u590d\n\n\u00a7b/craftaudit ... \u00a77- /ca \u7684\u5168\u79f0"), false);
            return 1;
        })));
    }

    private static int report(CommandSourceStack src) {
        boolean connected = Database.isConnected();
        boolean ok = connected && Database.get().ping();
        String mode = Config.isSqlite() ? "SQLITE" : "MYSQL";
        src.m_288197_(() -> Component.m_237113_((String)("\u00a73[CraftAudit] \u6a21\u5f0f\uff1a" + mode + " | \u72b6\u6001\uff1a" + ok)), false);
        return ok ? 1 : 0;
    }

    private static int toggleAudit(CommandSourceStack src) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.exit(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u9000\u51fa\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        } else {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        return 1;
    }

    private static int inspectAudit(CommandSourceStack src, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (!AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        BlockInspectListener.queryInteractLogPage(player, page);
        return 1;
    }

    private static int inspectBlockAudit(CommandSourceStack src, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        UUID uuid = player.m_20148_();
        if (!AuditModeManager.isAuditing(uuid)) {
            AuditModeManager.enter(uuid);
            src.m_288197_(() -> Component.m_237113_((String)"\u00a73[CraftAudit] \u5df2\u8fdb\u5165\u5ba1\u8ba1\u6a21\u5f0f\u3002"), false);
        }
        BlockInspectListener.queryBlockLogPage(player, page);
        return 1;
    }

    private static int near(CommandSourceStack src, int radius, String timeStr, int page) {
        ServerPlayer player = src.m_230896_();
        if (player == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        BlockInspectListener.showNearbyLogsPaged(player, radius, sinceMs, page, timeStr);
        return 1;
    }

    private static int rollback(CommandSourceStack src, String playerName, String timeStr, int radius) {
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        ServerLevel level = executor.m_284548_();
        String dim = level.m_46472_().m_135782_().toString();
        BlockPos center = executor.m_20183_();
        int changed = RollbackService.rollback(level, dim, center, radius, sinceMs, playerName, executor.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u56de\u6eda\u5b8c\u6210\uff1a%d \u4e2a\u65b9\u5757\u3002\u8f93\u5165 /ca undo \u64a4\u9500\u672c\u6b21\u56de\u6eda\u3002", changed)), true);
        return changed > 0 ? 1 : 0;
    }

    private static int restore(CommandSourceStack src, String timeStr, int radius, String typeOpt) {
        String t;
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a5d\u300112h\u300130m\u300145s"));
            return 0;
        }
        long sinceMs = System.currentTimeMillis() - durMs;
        ServerLevel level = executor.m_284548_();
        String dim = level.m_46472_().m_135782_().toString();
        BlockPos center = executor.m_20183_();
        if (typeOpt == null) {
            int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("break", "natural_break"), null, executor.m_20148_());
            src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u6240\u6709\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
            return changed > 0 ? 1 : 0;
        }
        switch (t = typeOpt.toLowerCase()) {
            case "break": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("break"), null, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73a9\u5bb6\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
                return changed > 0 ? 1 : 0;
            }
            case "natural": 
            case "natural_break": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("natural_break"), null, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73af\u5883\u7834\u574f\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", changed)), true);
                return changed > 0 ? 1 : 0;
            }
            case "explosion": 
            case "fluid": 
            case "gravity": {
                int changed = RollbackService.restoreBreaks(level, dim, center, radius, sinceMs, List.of("natural_break"), t, executor.m_20148_());
                src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08\u73af\u5883\u7834\u574f: %s\uff09\uff1a%d \u4e2a\u65b9\u5757\u3002/ca undo \u53ef\u64a4\u9500\u3002", t, changed)), true);
                return changed > 0 ? 1 : 0;
            }
        }
        if (t.equals("kill") || t.startsWith("kill:")) {
            String entityFilter = null;
            if (t.startsWith("kill:") && (entityFilter = t.substring("kill:".length())).isBlank()) {
                entityFilter = null;
            }
            int spawned = RollbackService.restoreKills(level, dim, center, radius, sinceMs, entityFilter, executor.m_20148_());
            Object scope = entityFilter == null ? "\u6240\u6709\u51fb\u6740" : "\u51fb\u6740: " + entityFilter;
            src.m_288197_(() -> CraftauditCommands.lambda$restore$47((String)scope, spawned), true);
            return spawned > 0 ? 1 : 0;
        }
        src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u672a\u77e5\u7684 type\uff01\u53ef\u9009\uff1abreak | natural | explosion | fluid | gravity | kill | kill:<entity_id>"));
        return 0;
    }

    private static int purge(CommandSourceStack src, String timeStr) {
        long durMs = CraftauditCommands.parseDurationMillis(timeStr);
        if (durMs <= 0L) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u65f6\u95f4\u683c\u5f0f\u65e0\u6548\uff01\u793a\u4f8b\uff1a30d\u300112h\u300190m\u3001300s"));
            return 0;
        }
        long beforeMs = System.currentTimeMillis() - durMs;
        if (!Database.isConnected()) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6570\u636e\u5e93\u672a\u8fde\u63a5\uff0c\u65e0\u6cd5\u6e05\u7406\u3002"));
            return 0;
        }
        int deleted = Database.get().deleteLogsBefore(beforeMs);
        if (deleted < 0) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6e05\u7406\u65e5\u5fd7\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u3002"));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("\u00a73[CraftAudit] \u5df2\u6e05\u7406 " + deleted + " \u6761\u65e9\u4e8e " + timeStr + " \u7684\u65e5\u5fd7\u8bb0\u5f55\u3002")), true);
        return 1;
    }

    private static int undo(CommandSourceStack src) {
        ServerPlayer executor = src.m_230896_();
        if (executor == null) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c[CraftAudit] \u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\u8be5\u547d\u4ee4\uff01"));
            return 0;
        }
        if (!UndoManager.hasUndo(executor.m_20148_())) {
            src.m_81352_((Component)Component.m_237113_((String)"\u00a7c\u6ca1\u6709\u53ef\u64a4\u9500\u7684\u56de\u6eda/\u6062\u590d\u8bb0\u5f55\u3002"));
            return 0;
        }
        int changed = UndoManager.applyUndo(executor);
        src.m_288197_(() -> Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u64a4\u9500\u5b8c\u6210\uff1a%d \u9879\u66f4\u6539\u5df2\u6062\u590d\u3002", changed)), true);
        return changed > 0 ? 1 : 0;
    }

    private static long parseDurationMillis(String s) {
        if (s == null) {
            return -1L;
        }
        Matcher m = DURATION_PATTERN.matcher(s.trim());
        if (!m.matches()) {
            return -1L;
        }
        long val = Long.parseLong(m.group(1));
        char unit = Character.toLowerCase(m.group(2).charAt(0));
        return switch (unit) {
            case 's' -> val * 1000L;
            case 'm' -> val * 60000L;
            case 'h' -> val * 3600000L;
            case 'd' -> val * 86400000L;
            default -> -1L;
        };
    }

    private static /* synthetic */ Component lambda$restore$47(String scope, int spawned) {
        return Component.m_237113_((String)String.format("\u00a73[CraftAudit] \u6062\u590d\u5b8c\u6210\uff08%s\uff09\uff1a\u751f\u6210 %d \u4e2a\u5b9e\u4f53\u3002/ca undo \u53ef\u64a4\u9500\u3002", scope, spawned));
    }
}

