/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.block;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="craftaudit")
public class BucketLogListener {
    @SubscribeEvent
    public static void onBucketFill(PlayerInteractEvent.RightClickBlock event) {
        Player p = event.getEntity();
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (held.m_41619_() || held.m_41720_() != Items.f_42446_) {
            return;
        }
        Level level = player.m_9236_();
        BlockPos pos = event.getPos();
        BlockState st = level.m_8055_(pos);
        String fluidId = null;
        Block block = st.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock lb = (LiquidBlock)block;
            try {
                if ((Integer)st.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                    fluidId = ForgeRegistries.FLUIDS.getKey((Object)lb.getFluid()).toString();
                }
            }
            catch (Exception exception) {}
        } else if (st.m_60734_() instanceof PowderSnowBlock) {
            fluidId = ForgeRegistries.BLOCKS.getKey((Object)st.m_60734_()).toString();
        }
        if (fluidId != null) {
            Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), level.m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), "bucket_fill", fluidId, ""));
        }
    }

    @SubscribeEvent
    public static void onBucketEmpty(PlayerInteractEvent.RightClickBlock event) {
        Player p = event.getEntity();
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (held.m_41619_() || !(held.m_41720_() instanceof BucketItem)) {
            return;
        }
        if (held.m_41720_() == Items.f_42446_) {
            return;
        }
        String fluidId = ForgeRegistries.ITEMS.getKey((Object)held.m_41720_()).toString();
        BlockPos placePos = event.getPos().m_121945_(event.getFace());
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), placePos.m_123341_(), placePos.m_123342_(), placePos.m_123343_(), player.m_7755_().getString(), "bucket_empty", fluidId, ""));
    }

    @SubscribeEvent
    public static void onBucketCatch(PlayerInteractEvent.EntityInteractSpecific event) {
        Player p = event.getEntity();
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != Items.f_42446_) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof Bucketable)) {
            return;
        }
        BlockPos pos = target.m_20183_();
        String entId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString();
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), "bucket_catch", entId, ""));
    }

    @SubscribeEvent
    public static void onBucketMilk(PlayerInteractEvent.EntityInteractSpecific event) {
        Player p = event.getEntity();
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (AuditModeManager.isAuditing(player.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = player.m_21205_();
        if (held.m_41619_() || held.m_41720_() != Items.f_42446_) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof Cow) && !(target instanceof Goat)) {
            return;
        }
        BlockPos pos = target.m_20183_();
        String entId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString();
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), player.m_9236_().m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), player.m_7755_().getString(), "bucket_milk", entId, ""));
    }
}

