/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.block;

import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="craftaudit")
public class NaturalBreakListener {
    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        Level level = event.getLevel();
        String dim = level.m_46472_().m_135782_().toString();
        long now = System.currentTimeMillis();
        for (BlockPos pos : event.getAffectedBlocks()) {
            BlockState st = level.m_8055_(pos);
            if (st.m_60795_()) continue;
            Block block = st.m_60734_();
            String targetId = ForgeRegistries.BLOCKS.getKey((Object)block) == null ? "unknown" : ForgeRegistries.BLOCKS.getKey((Object)block).toString();
            Database.get().insertAsync(new LogEntry(now, dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), "(\u7206\u70b8)", "natural_break", targetId, "{\"cause\":\"explosion\"}"));
        }
    }

    @SubscribeEvent
    public static void onFluidPlace(BlockEvent.FluidPlaceBlockEvent event) {
        LevelAccessor levelAcc = event.getLevel();
        if (levelAcc.m_5776_()) {
            return;
        }
        BlockState oldSt = event.getOriginalState();
        if (oldSt.m_60795_()) {
            return;
        }
        if (!(oldSt.m_60734_() instanceof LiquidBlock) && !(event.getNewState().m_60734_() instanceof BaseFireBlock)) {
            String string;
            if (levelAcc instanceof Level) {
                Level lvl = (Level)levelAcc;
                string = lvl.m_46472_().m_135782_().toString();
            } else {
                string = "unknown";
            }
            String dim = string;
            String targetId = ForgeRegistries.BLOCKS.getKey((Object)oldSt.m_60734_()).toString();
            BlockPos pos = event.getPos();
            Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), "(\u73af\u5883)", "natural_break", targetId, "{\"cause\":\"fluid\"}"));
        }
    }

    @SubscribeEvent
    public static void onFallingSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof FallingBlockEntity)) {
            return;
        }
        FallingBlockEntity falling = (FallingBlockEntity)entity;
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        BlockState st = falling.m_31980_();
        String targetId = ForgeRegistries.BLOCKS.getKey((Object)st.m_60734_()).toString();
        BlockPos pos = falling.m_20183_();
        Database.get().insertAsync(new LogEntry(System.currentTimeMillis(), level.m_46472_().m_135782_().toString(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), "(\u73af\u5883)", "natural_break", targetId, "{\"cause\":\"gravity\"}"));
    }
}

