/*
 * Decompiled with CFR 0.152.
 */
package cn.alini.craftaudit.event.block;

import cn.alini.craftaudit.AuditModeManager;
import cn.alini.craftaudit.storage.Database;
import cn.alini.craftaudit.storage.LogEntry;
import cn.alini.craftaudit.util.NameLocalization;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlockInspectListener {
    private static final int PAGE_SIZE = 7;
    private static final int NEAR_PAGE_SIZE = 15;
    private static final Map<UUID, BlockPos> auditQueryPos = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, String> auditQueryDim = new HashMap<UUID, String>();
    private static final Map<UUID, Long> lastRightClickTime = new HashMap<UUID, Long>();
    private static final Map<UUID, BlockPos> lastRightClickPos = new HashMap<UUID, BlockPos>();
    private static final Map<UUID, Long> lastLeftClickTime = new HashMap<UUID, Long>();
    private static final Map<UUID, BlockPos> lastLeftClickPos = new HashMap<UUID, BlockPos>();
    private static final long LEFT_CLICK_DEDUP_TICKS = 4L;
    private static final boolean REPLACE_PAGE = true;
    private static final int CLEAR_LINES = 40;

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_9236_().m_5776_()) {
            return;
        }
        if (!AuditModeManager.isAuditing(player2.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = event.getPos();
        long nowTick = System.currentTimeMillis() / 50L;
        UUID uid = player2.m_20148_();
        Long lastTick = lastLeftClickTime.get(uid);
        BlockPos lastPos = lastLeftClickPos.get(uid);
        if (lastTick != null && lastPos != null && pos.equals((Object)lastPos) && nowTick - lastTick <= 4L) {
            event.setCanceled(true);
            return;
        }
        lastLeftClickTime.put(uid, nowTick);
        lastLeftClickPos.put(uid, pos);
        String dimension = player2.m_9236_().m_46472_().m_135782_().toString();
        auditQueryPos.put(uid, pos);
        auditQueryDim.put(uid, dimension);
        BlockInspectListener.showBlockLogsPaged(player2, dimension, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 1);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_9236_().m_5776_()) {
            return;
        }
        if (!AuditModeManager.isAuditing(player2.m_20148_())) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        long nowTick = System.currentTimeMillis() / 50L;
        BlockPos pos = event.getPos();
        String dimension = player2.m_9236_().m_46472_().m_135782_().toString();
        if (lastRightClickTime.getOrDefault(player2.m_20148_(), -1L) == nowTick && pos.equals((Object)lastRightClickPos.get(player2.m_20148_()))) {
            return;
        }
        lastRightClickTime.put(player2.m_20148_(), nowTick);
        lastRightClickPos.put(player2.m_20148_(), pos);
        auditQueryPos.put(player2.m_20148_(), pos);
        auditQueryDim.put(player2.m_20148_(), dimension);
        BlockInspectListener.showInteractLogsPaged(player2, dimension, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 1);
        event.setCanceled(true);
    }

    public static void queryBlockLogPage(ServerPlayer player, int page) {
        BlockPos pos = auditQueryPos.get(player.m_20148_());
        String dim = auditQueryDim.get(player.m_20148_());
        if (pos == null || dim == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8bf7\u5148\u5de6\u952e\u65b9\u5757\u8fdb\u884c\u67e5\u8be2\uff01"));
            return;
        }
        BlockInspectListener.showBlockLogsPaged(player, dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), page);
    }

    public static void queryInteractLogPage(ServerPlayer player, int page) {
        BlockPos pos = auditQueryPos.get(player.m_20148_());
        String dim = auditQueryDim.get(player.m_20148_());
        if (pos == null || dim == null) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7c\u8bf7\u5148\u53f3\u952e\u65b9\u5757\u8fdb\u884c\u67e5\u8be2\uff01"));
            return;
        }
        BlockInspectListener.showInteractLogsPaged(player, dim, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), page);
    }

    public static void showBlockLogsPaged(ServerPlayer player, String dimension, int x, int y, int z, int page) {
        String actionPattern = "break|place|natural_break";
        int total = Database.get().countLogsAt(dimension, x, y, z, actionPattern);
        int totalPages = Math.max((total + 7 - 1) / 7, 1);
        List<LogEntry> logs = Database.get().queryLogsAtPaged(dimension, x, y, z, actionPattern, page, 7);
        BlockInspectListener.clearBeforePage(player.m_20203_());
        player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a77-----\u00a73\u65b9\u5757\u53d8\u66f4\u8bb0\u5f55\u00a77-----(%s x%d/y%d/z%d)", dimension, x, y, z)));
        if (logs.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u65e0\u8bb0\u5f55\u3002"));
        } else {
            for (LogEntry log : logs) {
                player.m_213846_((Component)BlockInspectListener.formatBlockLogCoreProtect(log));
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a77-----"));
        BlockInspectListener.sendPageLine(player, x, y, z, page, totalPages, "block");
    }

    public static void showInteractLogsPaged(ServerPlayer player, String dimension, int x, int y, int z, int page) {
        String actionPattern = String.join((CharSequence)"|", "put", "take", "sign_edit", "ignite", "button_press", "lever_pull", "door_use", "kill", "bucket_fill", "bucket_empty", "bucket_catch", "bucket_milk", "frame_put", "frame_take", "frame_rotate", "frame_place", "frame_break", "painting_place", "painting_break");
        int total = Database.get().countLogsAt(dimension, x, y, z, actionPattern);
        int totalPages = Math.max((total + 7 - 1) / 7, 1);
        List<LogEntry> logs = Database.get().queryLogsAtPaged(dimension, x, y, z, actionPattern, page, 7);
        BlockInspectListener.clearBeforePage(player.m_20203_());
        player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a77-----\u00a73\u4ea4\u4e92\u8bb0\u5f55\u00a77-----(%s x%d/y%d/z%d)", dimension, x, y, z)));
        if (logs.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u65e0\u8bb0\u5f55\u3002"));
        } else {
            for (LogEntry log : logs) {
                player.m_213846_((Component)BlockInspectListener.formatLogCoreProtect(log));
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a77-----"));
        BlockInspectListener.sendPageLine(player, x, y, z, page, totalPages, "interact");
    }

    public static void showNearbyLogsPaged(ServerPlayer player, int radius, long sinceMillis, int page, String timeLabel) {
        BlockPos center = player.m_20183_();
        String dim = player.m_9236_().m_46472_().m_135782_().toString();
        int total = Database.get().countLogsNear(dim, center.m_123341_(), center.m_123342_(), center.m_123343_(), radius, sinceMillis);
        int totalPages = Math.max((total + 15 - 1) / 15, 1);
        List<LogEntry> logs = Database.get().queryLogsNearPaged(dim, center.m_123341_(), center.m_123342_(), center.m_123343_(), radius, sinceMillis, page, 15);
        BlockInspectListener.clearBeforePage(player.m_20203_());
        player.m_213846_((Component)Component.m_237113_((String)String.format("\u00a77-----\u00a73\u534a\u5f84\u67e5\u8be2\u00a77----- (\u7ef4\u5ea6: %s | \u534a\u5f84: %d | \u65f6\u95f4: %s\u5185 | \u4e2d\u5fc3: x%d/y%d/z%d)", dim, radius, timeLabel, center.m_123341_(), center.m_123342_(), center.m_123343_())));
        if (logs.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a77\u65e0\u8bb0\u5f55\u3002"));
        } else {
            for (LogEntry log : logs) {
                MutableComponent line = log.action().equals("break") || log.action().equals("place") || log.action().equals("natural_break") ? BlockInspectListener.formatBlockLogCoreProtect(log) : BlockInspectListener.formatLogCoreProtect(log);
                line.m_7220_((Component)Component.m_237113_((String)String.format(" @ x%d/y%d/z%d", log.x(), log.y(), log.z())).m_130940_(ChatFormatting.DARK_GRAY));
                player.m_213846_((Component)line);
            }
        }
        player.m_213846_((Component)Component.m_237113_((String)"\u00a77-----"));
        BlockInspectListener.sendNearPageLine(player, radius, timeLabel, page, totalPages);
    }

    private static MutableComponent formatBlockLogCoreProtect(LogEntry log) {
        MutableComponent msg = Component.m_237113_((String)BlockInspectListener.formatAgoPrefix(log.timeMillis())).m_130940_(ChatFormatting.GRAY);
        String action = log.action();
        String sign = action.equals("place") ? "+" : "-";
        ChatFormatting signColor = sign.equals("+") ? ChatFormatting.GOLD : ChatFormatting.RED;
        msg.m_7220_((Component)Component.m_237113_((String)sign).m_130940_(signColor));
        msg.m_7220_((Component)Component.m_237113_((String)" "));
        String uuidText = log.playerUuid() != null ? log.playerUuid() : "\u672a\u77e5";
        MutableComponent nameComp = Component.m_237113_((String)log.player()).m_130940_(ChatFormatting.BLUE);
        nameComp.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("UUID: " + uuidText)))));
        msg.m_7220_((Component)nameComp);
        msg.m_7220_((Component)Component.m_237113_((String)" "));
        switch (action) {
            case "place": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u653e\u7f6e\u4e86").m_130940_(ChatFormatting.WHITE));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "break": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7834\u574f\u4e86").m_130940_(ChatFormatting.LIGHT_PURPLE));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "natural_break": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u81ea\u7136\u7834\u574f\u4e86").m_130940_(ChatFormatting.DARK_PURPLE));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            default: {
                msg.m_7220_((Component)Component.m_237113_((String)action).m_130940_(ChatFormatting.GRAY));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)log.target()).m_130940_(ChatFormatting.AQUA));
            }
        }
        return msg;
    }

    private static MutableComponent formatLogCoreProtect(LogEntry log) {
        MutableComponent msg = Component.m_237113_((String)BlockInspectListener.formatAgoPrefix(log.timeMillis())).m_130940_(ChatFormatting.GRAY);
        String action = log.action();
        boolean isPlus = action.equals("put") || action.equals("sign_edit") || action.equals("frame_put") || action.equals("frame_place") || action.equals("painting_place") || action.startsWith("bucket_");
        String sign = isPlus ? "+" : "-";
        ChatFormatting signColor = isPlus ? ChatFormatting.GOLD : ChatFormatting.RED;
        msg.m_7220_((Component)Component.m_237113_((String)sign).m_130940_(signColor));
        msg.m_7220_((Component)Component.m_237113_((String)" "));
        String uuidText = log.playerUuid() != null ? log.playerUuid() : "\u672a\u77e5";
        MutableComponent nameComp = Component.m_237113_((String)log.player()).m_130940_(ChatFormatting.BLUE);
        nameComp.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("UUID: " + uuidText)))));
        msg.m_7220_((Component)nameComp);
        msg.m_7220_((Component)Component.m_237113_((String)" "));
        switch (action) {
            case "put": 
            case "take": {
                String actionText = action.equals("put") ? "\u5b58\u5165" : "\u53d6\u51fa";
                ChatFormatting actionColor = action.equals("put") ? ChatFormatting.YELLOW : ChatFormatting.GOLD;
                String itemId = "";
                int count = 0;
                try {
                    String data = log.data();
                    int i1 = data.indexOf("\"item\":\"") + 8;
                    int i2 = data.indexOf("\"", i1);
                    itemId = data.substring(i1, i2);
                    int c1 = data.indexOf("\"count\":") + 8;
                    int c2 = data.indexOf("}", c1);
                    count = Integer.parseInt(data.substring(c1, c2).trim());
                }
                catch (Exception e) {
                    itemId = log.data();
                }
                String itemName = NameLocalization.itemName(itemId);
                msg.m_7220_((Component)Component.m_237113_((String)actionText).m_130940_(actionColor));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)(count + "x ")).m_130940_(ChatFormatting.WHITE));
                msg.m_7220_((Component)Component.m_237113_((String)itemName).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "sign_edit": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7f16\u8f91\u4e86\u544a\u793a\u724c").m_130940_(ChatFormatting.AQUA));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                msg.m_7220_((Component)Component.m_237113_((String)(" \u6587\u672c: " + log.data())).m_130940_(ChatFormatting.GRAY));
                break;
            }
            case "ignite": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u70b9\u71c3\u4e86").m_130940_(ChatFormatting.RED));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "button_press": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u6309\u4e0b\u4e86\u6309\u94ae").m_130940_(ChatFormatting.DARK_AQUA));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "lever_pull": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u62c9\u52a8\u4e86\u62c9\u6746").m_130940_(ChatFormatting.DARK_AQUA));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "door_use": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u4f7f\u7528\u4e86\u95e8").m_130940_(ChatFormatting.DARK_AQUA));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.blockName(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "kill": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u6740\u6b7b\u4e86").m_130940_(ChatFormatting.RED));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                String victim = log.target();
                if (victim.startsWith("player:")) {
                    victim = victim.substring("player:".length());
                }
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.localize(victim)).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "bucket_fill": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7528\u6876\u88c5\u53d6\u4e86").m_130940_(ChatFormatting.YELLOW));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.localize(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "bucket_empty": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7528\u6876\u5012\u51fa\u4e86").m_130940_(ChatFormatting.YELLOW));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.localize(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "bucket_catch": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7528\u6876\u88c5\u8d77\u4e86").m_130940_(ChatFormatting.YELLOW));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.localize(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            case "bucket_milk": {
                msg.m_7220_((Component)Component.m_237113_((String)"\u7528\u6876\u6324\u5976").m_130940_(ChatFormatting.YELLOW));
                msg.m_7220_((Component)Component.m_237113_((String)" \u81ea ").m_130940_(ChatFormatting.GRAY));
                msg.m_7220_((Component)Component.m_237113_((String)NameLocalization.localize(log.target())).m_130940_(ChatFormatting.AQUA));
                break;
            }
            default: {
                msg.m_7220_((Component)Component.m_237113_((String)action).m_130940_(ChatFormatting.GRAY));
                msg.m_7220_((Component)Component.m_237113_((String)" "));
                msg.m_7220_((Component)Component.m_237113_((String)log.target()).m_130940_(ChatFormatting.AQUA));
            }
        }
        return msg;
    }

    public static MutableComponent renderLogLine(LogEntry log) {
        MutableComponent line = log.action().equals("break") || log.action().equals("place") || log.action().equals("natural_break") ? BlockInspectListener.formatBlockLogCoreProtect(log) : BlockInspectListener.formatLogCoreProtect(log);
        line.m_7220_((Component)Component.m_237113_((String)String.format(" @ %s x%d/y%d/z%d", log.dimension(), log.x(), log.y(), log.z())).m_130940_(ChatFormatting.DARK_GRAY));
        return line;
    }

    private static void sendPageLine(ServerPlayer player, int x, int y, int z, int page, int totalPages, String type) {
        String cmd;
        MutableComponent pageLine = Component.m_237113_((String)String.format("\u7b2c %d/%d \u9875 ", page, totalPages)).m_130940_(ChatFormatting.GRAY);
        String string = cmd = type.equals("block") ? "/ca blocklog " : "/ca log ";
        if (page > 1) {
            pageLine.m_7220_((Component)Component.m_237113_((String)"\u25c0 ").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + (page - 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0a\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
        }
        pageLine.m_7220_((Component)Component.m_237113_((String)"("));
        for (int i = 1; i <= totalPages; ++i) {
            if (i == page) {
                pageLine.m_7220_((Component)Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.YELLOW));
            } else {
                int finalI = i;
                pageLine.m_7220_((Component)Component.m_237113_((String)("" + finalI)).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + finalI)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("\u8df3\u8f6c\u5230\u7b2c " + finalI + " \u9875")))).m_131140_(ChatFormatting.AQUA)));
            }
            if (i >= totalPages) continue;
            pageLine.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
        }
        pageLine.m_7220_((Component)Component.m_237113_((String)") "));
        if (page < totalPages) {
            pageLine.m_7220_((Component)Component.m_237113_((String)"\u25b6").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + (page + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0b\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
        }
        player.m_213846_((Component)pageLine);
    }

    private static void sendNearPageLine(ServerPlayer player, int radius, String timeLabel, int page, int totalPages) {
        MutableComponent pageLine = Component.m_237113_((String)String.format("\u7b2c %d/%d \u9875 ", page, totalPages)).m_130940_(ChatFormatting.GRAY);
        String cmdPrefix = "/ca near " + radius + " " + timeLabel + " ";
        if (page > 1) {
            pageLine.m_7220_((Component)Component.m_237113_((String)"\u25c0 ").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + (page - 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0a\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
        }
        pageLine.m_7220_((Component)Component.m_237113_((String)"("));
        for (int i = 1; i <= totalPages; ++i) {
            if (i == page) {
                pageLine.m_7220_((Component)Component.m_237113_((String)("" + i)).m_130940_(ChatFormatting.YELLOW));
            } else {
                int finalI = i;
                pageLine.m_7220_((Component)Component.m_237113_((String)("" + finalI)).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + finalI)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("\u8df3\u8f6c\u5230\u7b2c " + finalI + " \u9875")))).m_131140_(ChatFormatting.AQUA)));
            }
            if (i >= totalPages) continue;
            pageLine.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
        }
        pageLine.m_7220_((Component)Component.m_237113_((String)") "));
        if (page < totalPages) {
            pageLine.m_7220_((Component)Component.m_237113_((String)"\u25b6").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmdPrefix + (page + 1))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"\u4e0b\u4e00\u9875"))).m_131140_(ChatFormatting.AQUA)));
        }
        player.m_213846_((Component)pageLine);
    }

    private static void clearBeforePage(CommandSourceStack src) {
        ServerPlayer viewer = src.m_230896_();
        if (viewer == null) {
            return;
        }
        for (int i = 0; i < 40; ++i) {
            viewer.m_213846_((Component)Component.m_237113_((String)" "));
        }
    }

    private static String formatAgoPrefix(long timeMs) {
        double sec;
        long deltaMs = System.currentTimeMillis() - timeMs;
        if (deltaMs < 0L) {
            deltaMs = 0L;
        }
        if ((sec = (double)deltaMs / 1000.0) < 60.0) {
            return String.format(Locale.ROOT, "%04.1f\u79d2 \u524d | ", sec);
        }
        double min = sec / 60.0;
        if (min < 60.0) {
            return String.format(Locale.ROOT, "%04.1f\u5206 \u524d | ", min);
        }
        double hours = min / 60.0;
        if (hours < 24.0) {
            return String.format(Locale.ROOT, "%04.1f\u65f6 \u524d | ", hours);
        }
        double days = hours / 24.0;
        return String.format(Locale.ROOT, "%04.1f\u5929 \u524d | ", days);
    }
}

